/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.pbem;

import games.strategy.engine.pbem.AbstractForumPoster;
import games.strategy.engine.pbem.IForumPoster;
import games.strategy.net.BrowserControl;
import games.strategy.triplea.help.HelpSupport;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartBase;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpMethodParams;

public class AxisAndAlliesForumPoster
extends AbstractForumPoster {
    private static final long serialVersionUID = 8896923978584346664L;
    public static final Pattern NUM_REPLIES_PATTERN = Pattern.compile(".*name=\"num_replies\" value=\"(\\d+)\".*", 34);
    public static final Pattern SEQ_NUM_PATTERN = Pattern.compile(".*name=\"seqnum\"\\svalue=\"(\\d+)\".*", 34);
    public static final Pattern SC_PATTERN = Pattern.compile(".*name=\"sc\"\\svalue=\"(\\w+)\".*", 34);
    public static final Pattern AN_ERROR_OCCURRED_PATTERN = Pattern.compile(".*An Error Has Occurred.*", 34);
    public static final Pattern ERROR_TEXT_PATTERN = Pattern.compile(".*<tr\\s+class=\"windowbg\">\\s*<td[^>]*>([^<]*)</td>.*", 34);
    public static final Pattern ERROR_LIST_PATTERN = Pattern.compile(".*id=\"error_list[^>]*>\\s+([^<]*)\\s+<.*", 34);
    private transient HttpState m_httpState;
    private transient HostConfiguration m_hostConfiguration;
    private transient HttpClient m_client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void login() throws Exception {
        block11: {
            this.m_client = new HttpClient();
            this.m_client.getParams().setParameter("http.protocol.single-cookie-header", true);
            this.m_client.getParams().setParameter("http.useragent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; Trident/4.0)");
            this.m_httpState = new HttpState();
            this.m_hostConfiguration = new HostConfiguration();
            this.m_hostConfiguration.setHost("www.axisandallies.org");
            PostMethod post = new PostMethod("http://www.axisandallies.org/forums/index.php?action=login2");
            try {
                post.addRequestHeader("Accept", "*/*");
                post.addRequestHeader("Accept-Language", "en-us");
                post.addRequestHeader("Cache-Control", "no-cache");
                post.addRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
                parameters.add(new NameValuePair("user", this.getUsername()));
                parameters.add(new NameValuePair("passwrd", this.getPassword()));
                post.setRequestBody(parameters.toArray(new NameValuePair[parameters.size()]));
                int status = this.m_client.executeMethod(this.m_hostConfiguration, post, this.m_httpState);
                if (status == 200) {
                    String body = post.getResponseBodyAsString();
                    if (body.toLowerCase().contains("password incorrect")) {
                        throw new Exception("Incorrect Password");
                    }
                    Header refreshHeader = post.getResponseHeader("Refresh");
                    if (refreshHeader == null) {
                        throw new Exception("Missing refresh header after login");
                    }
                    String value = refreshHeader.getValue();
                    Pattern p = Pattern.compile("[^;]*;\\s*url=(.*)", 34);
                    Matcher m = p.matcher(value);
                    if (m.matches()) {
                        String url = m.group(1);
                        GetMethod getRefreshPage = new GetMethod(url);
                        try {
                            status = this.m_client.executeMethod(this.m_hostConfiguration, getRefreshPage, this.m_httpState);
                            if (status != 200) {
                                // empty if block
                            }
                            break block11;
                        }
                        finally {
                            getRefreshPage.releaseConnection();
                        }
                    }
                    throw new Exception("The refresh header didn't contain a URL");
                }
                throw new Exception("Failed to login to forum, server responded with status code: " + status);
            }
            finally {
                post.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postTurnSummary(String message, String subject) {
        block23: {
            try {
                this.login();
                GetMethod get = new GetMethod("http://www.axisandallies.org/forums/index.php?action=post;topic=" + this.m_topicId + ".0");
                int status = this.m_client.executeMethod(this.m_hostConfiguration, get, this.m_httpState);
                String body = get.getResponseBodyAsString();
                if (status == 200) {
                    Matcher m = NUM_REPLIES_PATTERN.matcher(body);
                    if (!m.matches()) {
                        throw new Exception("Hidden field 'num_replies' not found on page");
                    }
                    String numReplies = m.group(1);
                    m = SEQ_NUM_PATTERN.matcher(body);
                    if (!m.matches()) {
                        throw new Exception("Hidden field 'seqnum' not found on page");
                    }
                    String seqNum = m.group(1);
                    m = SC_PATTERN.matcher(body);
                    if (!m.matches()) {
                        throw new Exception("Hidden field 'sc' not found on page");
                    }
                    String sc = m.group(1);
                    PostMethod post = new PostMethod("http://www.axisandallies.org/forums/index.php?action=post2;start=0;board=40");
                    try {
                        ArrayList<PartBase> parts = new ArrayList<PartBase>();
                        parts.add(this.createStringPart("topic", this.m_topicId));
                        parts.add(this.createStringPart("subject", subject));
                        parts.add(this.createStringPart("icon", "xx"));
                        parts.add(this.createStringPart("message", message));
                        parts.add(this.createStringPart("notify", "0"));
                        if (this.m_includeSaveGame && this.m_saveGameFile != null) {
                            FilePart part = new FilePart("attachment[]", this.m_saveGameFileName, this.m_saveGameFile);
                            part.setContentType("application/octet-stream");
                            part.setTransferEncoding(null);
                            part.setCharSet(null);
                            parts.add(part);
                        }
                        parts.add(this.createStringPart("post", "Post"));
                        parts.add(this.createStringPart("num_replies", numReplies));
                        parts.add(this.createStringPart("additional_options", "1"));
                        parts.add(this.createStringPart("sc", sc));
                        parts.add(this.createStringPart("seqnum", seqNum));
                        MultipartRequestEntity entity = new MultipartRequestEntity(parts.toArray(new Part[parts.size()]), new HttpMethodParams());
                        post.setRequestEntity(entity);
                        post.addRequestHeader("Referer", "http://www.axisandallies.org/forums/index.php?action=post;topic=" + this.m_topicId + ".0;num_replies=" + numReplies);
                        post.addRequestHeader("Accept", "*/*");
                        try {
                            Thread.sleep(15000L);
                        }
                        catch (InterruptedException ie) {
                            ie.printStackTrace();
                        }
                        post.setFollowRedirects(false);
                        status = this.m_client.executeMethod(this.m_hostConfiguration, post, this.m_httpState);
                        body = post.getResponseBodyAsString();
                        if (status == 302) {
                            this.m_turnSummaryRef = "http://www.axisandallies.org/forums/index.php?topic=" + this.m_topicId + ".10000";
                            break block23;
                        }
                        Matcher matcher = ERROR_LIST_PATTERN.matcher(body);
                        if (matcher.matches()) {
                            throw new Exception("The site gave an error: '" + matcher.group(1) + "'");
                        }
                        matcher = AN_ERROR_OCCURRED_PATTERN.matcher(body);
                        if (matcher.matches() && (matcher = ERROR_TEXT_PATTERN.matcher(body)).matches()) {
                            throw new Exception("The site gave an error: '" + matcher.group(1) + "'");
                        }
                        Header refreshHeader = post.getResponseHeader("Refresh");
                        if (refreshHeader != null) {
                            String value = refreshHeader.getValue();
                            Pattern p = Pattern.compile("[^;]*;\\s*url=.*spam=true.*", 34);
                            m = p.matcher(value);
                            if (m.matches()) {
                                throw new Exception("The summary was posted but was flagged as spam");
                            }
                        }
                        throw new Exception("Unknown error, post a bug to the tripleA development team");
                    }
                    finally {
                        post.releaseConnection();
                        GetMethod logout = new GetMethod("http://www.axisandallies.org/forums/index.php?action=logout;sesc=" + sc);
                        try {
                            status = this.m_client.executeMethod(this.m_hostConfiguration, logout, this.m_httpState);
                            if (status != 200) {
                                // empty if block
                            }
                        }
                        finally {
                            logout.releaseConnection();
                        }
                    }
                }
                throw new Exception("Unable to load forum post " + this.m_topicId);
            }
            catch (Exception e) {
                this.m_turnSummaryRef = e.getMessage();
                return false;
            }
        }
        return true;
    }

    private StringPart createStringPart(String name, String value) {
        StringPart stringPart = new StringPart(name, value);
        stringPart.setTransferEncoding(null);
        stringPart.setContentType(null);
        return stringPart;
    }

    public String getDisplayName() {
        return "AxisAndAllies.org";
    }

    public IForumPoster doClone() {
        AxisAndAlliesForumPoster clone = new AxisAndAlliesForumPoster();
        clone.setTopicId(this.getTopicId());
        clone.setIncludeSaveGame(this.getIncludeSaveGame());
        clone.setPassword(this.getPassword());
        clone.setUsername(this.getUsername());
        return clone;
    }

    public boolean supportsSaveGame() {
        return true;
    }

    public void viewPosted() {
        String url = "http://www.axisandallies.org/forums/index.php?topic=" + this.m_topicId + ".10000";
        BrowserControl.displayURL(url);
    }

    public String getTestMessage() {
        return "Testing, this will take about 20 seconds...";
    }

    public String getHelpText() {
        return HelpSupport.loadHelp("axisAndAlliesForum.html");
    }
}

