/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.printgenerator;

import games.strategy.engine.data.GameData;
import games.strategy.triplea.printgenerator.InitialSetup;
import games.strategy.triplea.printgenerator.PrintGenerationData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SetupFrame
extends JPanel {
    private final JLabel m_info1 = new JLabel();
    private final JLabel m_info2 = new JLabel();
    private final JLabel m_info3 = new JLabel();
    private final JPanel m_infoPanel;
    private final JPanel m_textButtonRadioPanel;
    private final JButton m_outDirButton;
    private final JButton m_runButton;
    private final JTextField m_outField;
    private final JFileChooser m_outChooser;
    private final JRadioButton m_currentState;
    private final JRadioButton m_originalState;
    private final ButtonGroup m_radioButtonGroup;
    private final GameData m_data;
    private File m_outDir;

    public SetupFrame(GameData data) {
        super(new BorderLayout());
        this.m_data = data;
        this.m_outDirButton = new JButton();
        this.m_runButton = new JButton();
        this.m_outField = new JTextField(15);
        this.m_outChooser = new JFileChooser();
        this.m_outChooser.setFileSelectionMode(1);
        this.m_currentState = new JRadioButton();
        this.m_originalState = new JRadioButton();
        this.m_radioButtonGroup = new ButtonGroup();
        this.m_info1.setText("This utility will export the map's either current or ");
        this.m_info2.setText("beginning state exactly like the boardgame, so you ");
        this.m_info3.setText("will get Setup Charts, Unit Information, etc.");
        this.m_currentState.setText("Current Position/State");
        this.m_originalState.setText("Starting Position/State");
        this.m_radioButtonGroup.add(this.m_currentState);
        this.m_radioButtonGroup.add(this.m_originalState);
        this.m_originalState.setSelected(true);
        this.m_outDirButton.setText("Choose the Output Directory");
        this.m_outDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = SetupFrame.this.m_outChooser.showOpenDialog(null);
                if (returnVal == 0) {
                    File outDir = SetupFrame.this.m_outChooser.getSelectedFile();
                    SetupFrame.this.m_outField.setText(outDir.getAbsolutePath());
                }
            }
        });
        this.m_runButton.setText("Generate the Files");
        this.m_runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!SetupFrame.this.m_outField.getText().equals("")) {
                    SetupFrame.this.m_outDir = new File(SetupFrame.this.m_outField.getText());
                    PrintGenerationData printData = new PrintGenerationData();
                    printData.setOutDir(SetupFrame.this.m_outDir);
                    printData.setData(SetupFrame.this.m_data);
                    new InitialSetup().run(printData, SetupFrame.this.m_originalState.isSelected());
                    JOptionPane.showMessageDialog(null, "Done!", "Done!", 1);
                } else {
                    JOptionPane.showMessageDialog(null, "You need to select an Output Directory.", "Select an Output Directory!", 0);
                }
            }
        });
        this.m_infoPanel = new JPanel(new GridLayout(3, 1));
        this.m_textButtonRadioPanel = new JPanel(new BorderLayout());
        this.m_infoPanel.add(this.m_info1);
        this.m_infoPanel.add(this.m_info2);
        this.m_infoPanel.add(this.m_info3);
        super.add((Component)this.m_infoPanel, "North");
        this.m_textButtonRadioPanel.add((Component)this.m_outField, "West");
        this.m_textButtonRadioPanel.add((Component)this.m_outDirButton, "East");
        JPanel panel = new JPanel(new GridLayout(1, 2));
        panel.add(this.m_originalState);
        panel.add(this.m_currentState);
        this.m_textButtonRadioPanel.add((Component)panel, "South");
        super.add((Component)this.m_textButtonRadioPanel, "Center");
        super.add((Component)this.m_runButton, "South");
    }
}

