/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.printgenerator;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.printgenerator.PrintGenerationData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnitInformation {
    private Map<UnitType, UnitAttachment> m_unitInfoMap;
    private Iterator<UnitType> m_unitTypeIterator;
    private GameData m_data;
    private PrintGenerationData m_printData;

    UnitInformation() {
    }

    private String capitalizeFirst(String s) {
        return s.length() > 0 ? Character.toUpperCase(s.charAt(0)) + s.substring(1) : s;
    }

    protected void saveToFile(PrintGenerationData printData, Map<UnitType, UnitAttachment> unitInfoMap) {
        FileWriter unitInformation = null;
        this.m_printData = printData;
        this.m_data = this.m_printData.getData();
        this.m_unitInfoMap = unitInfoMap;
        this.m_unitTypeIterator = this.m_unitInfoMap.keySet().iterator();
        this.m_printData.getOutDir().mkdir();
        try {
            int i;
            File outFile = new File(this.m_printData.getOutDir(), "General Information.csv");
            unitInformation = new FileWriter(outFile);
            for (i = 0; i < 8; ++i) {
                unitInformation.write(",");
            }
            unitInformation.write("Unit Information");
            for (i = 10; i < 20; ++i) {
                unitInformation.write(",");
            }
            unitInformation.write("\r\n");
            unitInformation.write("Unit,Cost,Movement,Attack,Defense,CanBlitz,Artillery?,ArtillerySupportable?,Factory?,Marine?,Transport Cost,AA Gun?,Air Unit?,Strategic Bomber?,Carrier Cost,Sea Unit?,Two Hit?,Transport Capacity,Carrier Capacity,Submarine?,Destroyer?");
            unitInformation.write("\r\n");
            while (this.m_unitTypeIterator.hasNext()) {
                UnitType currentType = this.m_unitTypeIterator.next();
                UnitAttachment currentAttachment = this.m_unitInfoMap.get(currentType);
                if (currentType.getName().equals("aaGun")) {
                    unitInformation.write(currentType.getName() + ",");
                } else {
                    unitInformation.write(this.capitalizeFirst(currentType.getName()) + ",");
                }
                unitInformation.write(this.getCostInformation(currentType) + ",");
                unitInformation.write(currentAttachment.getMovement(PlayerID.NULL_PLAYERID) + "," + currentAttachment.getAttack(PlayerID.NULL_PLAYERID) + "," + currentAttachment.getDefense(PlayerID.NULL_PLAYERID) + "," + (!currentAttachment.getCanBlitz() ? "-" : "true") + "," + (!currentAttachment.getArtillery() ? "-" : "true") + "," + (!currentAttachment.getArtillerySupportable() ? "-" : "true") + "," + (!currentAttachment.getIsFactory() ? "-" : "true") + "," + (!currentAttachment.getIsMarine() ? "-" : "true") + "," + (currentAttachment.getTransportCost() == -1 ? "-" : Integer.valueOf(currentAttachment.getTransportCost())) + "," + (!Matches.UnitTypeIsAAforAnything.match(currentType) ? "-" : "true") + "," + (!currentAttachment.getIsAir() ? "-" : "true") + "," + (!currentAttachment.getIsStrategicBomber() ? "-" : "true") + "," + (currentAttachment.getCarrierCost() == -1 ? "-" : Integer.valueOf(currentAttachment.getCarrierCost())) + "," + (!currentAttachment.getIsSea() ? "-" : "true") + "," + (!currentAttachment.getIsTwoHit() ? "-" : "true") + "," + (currentAttachment.getTransportCapacity() == -1 ? "-" : Integer.valueOf(currentAttachment.getTransportCapacity())) + "," + (currentAttachment.getCarrierCapacity() == -1 ? "-" : Integer.valueOf(currentAttachment.getCarrierCapacity())) + "," + (!currentAttachment.getIsSub() ? "-" : "true") + "," + (!currentAttachment.getIsDestroyer() ? "-" : "true"));
                unitInformation.write("\r\n");
            }
            unitInformation.write("\r\n");
            unitInformation.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int getCostInformation(UnitType type) {
        if (this.m_data.getProductionFrontierList().getProductionFrontier("production") != null) {
            List<ProductionRule> productionRules = this.m_data.getProductionFrontierList().getProductionFrontier("production").getRules();
            for (ProductionRule currentRule : productionRules) {
                UnitType currentType = (UnitType)currentRule.getResults().keySet().iterator().next();
                if (!currentType.equals(type)) continue;
                int cost = currentRule.getCosts().getInt(this.m_data.getResourceList().getResource("PUs"));
                return cost;
            }
        } else if (BattleCalculator.getCostsForTUV(this.m_data.getPlayerList().getPlayers().iterator().next(), this.m_data).getInt(type) > 0) {
            return BattleCalculator.getCostsForTUV(this.m_data.getPlayerList().getPlayers().iterator().next(), this.m_data).getInt(type);
        }
        return -1;
    }
}

