/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.triplea.Properties;
import games.strategy.triplea.ui.MapPanel;
import java.util.concurrent.CountDownLatch;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public abstract class ActionPanel
extends JPanel {
    private final GameData m_data;
    private PlayerID m_currentPlayer;
    private final MapPanel m_map;
    private boolean m_active;
    private CountDownLatch m_latch;
    private final Object m_latchLock = new Object();
    protected final Runnable REFRESH = new Runnable(){

        public void run() {
            ActionPanel.this.revalidate();
            ActionPanel.this.repaint();
        }
    };

    public ActionPanel(GameData data, MapPanel map) {
        this.m_data = data;
        this.m_map = map;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(5, 5, 0, 0));
    }

    public final boolean isWW2V2() {
        return Properties.getWW2V2(this.m_data);
    }

    public final boolean isWW2V3TechModel() {
        return Properties.getWW2V3TechModel(this.m_data);
    }

    public final boolean isRestrictedPurchase() {
        return Properties.getPlacementRestrictedByFactory(this.m_data);
    }

    public final boolean isSBRAffectsUnitProduction() {
        return Properties.getSBRAffectsUnitProduction(this.m_data);
    }

    public final boolean isDamageFromBombingDoneToUnitsInsteadOfTerritories() {
        return Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(this.m_data);
    }

    public final boolean isSelectableTechRoll() {
        return Properties.getSelectableTechRoll(this.m_data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForRelease() {
        Object object = this.m_latchLock;
        synchronized (object) {
            if (this.m_latch != null) {
                throw new IllegalStateException("Latch not null");
            }
            this.m_latch = new CountDownLatch(1);
            this.m_map.getUIContext().addShutdownLatch(this.m_latch);
        }
        try {
            this.m_latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        object = this.m_latchLock;
        synchronized (object) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release() {
        Object object = this.m_latchLock;
        synchronized (object) {
            if (this.m_latch == null) {
                return;
            }
            this.m_map.getUIContext().removeShutdownLatch(this.m_latch);
            this.m_latch.countDown();
            this.m_latch = null;
        }
    }

    protected GameData getData() {
        return this.m_data;
    }

    public void display(PlayerID player) {
        this.m_currentPlayer = player;
        this.setActive(true);
    }

    protected PlayerID getCurrentPlayer() {
        return this.m_currentPlayer;
    }

    protected MapPanel getMap() {
        return this.m_map;
    }

    public void setActive(boolean aBool) {
        this.m_active = aBool;
    }

    public boolean getActive() {
        return this.m_active;
    }
}

