/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.screen.Tile;
import java.lang.ref.WeakReference;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;

class BackgroundDrawer
implements Runnable {
    private final WeakReference<MapPanel> m_mapPanelRef;

    BackgroundDrawer(MapPanel panel) {
        this.m_mapPanelRef = new WeakReference<MapPanel>(panel);
    }

    public void stop() {
        this.m_mapPanelRef.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.m_mapPanelRef.get() != null) {
            MapPanel mapPanel;
            Tile tile;
            MapPanel panel = (MapPanel)this.m_mapPanelRef.get();
            if (panel == null) continue;
            LinkedBlockingQueue<Tile> undrawnTiles = panel.getUndrawnTiles();
            panel = null;
            try {
                tile = (Tile)undrawnTiles.poll(2000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                continue;
            }
            if (tile == null || (mapPanel = (MapPanel)this.m_mapPanelRef.get()) == null) continue;
            GameData data = mapPanel.getData();
            data.acquireReadLock();
            try {
                tile.getImage(data, mapPanel.getUIContext().getMapData());
            }
            finally {
                data.releaseReadLock();
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    mapPanel.repaint();
                }
            });
        }
    }
}

