/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.attatchments.UnitSupportAttachment;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.TerritoryEffectHelper;
import games.strategy.triplea.ui.TableData;
import games.strategy.triplea.ui.UIContext;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitSeperator;
import games.strategy.util.IntegerMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.table.DefaultTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BattleModel
extends DefaultTableModel {
    private final UIContext m_uiContext;
    private final GameData m_data;
    private final boolean m_attack;
    private final Collection<Unit> m_units;
    private final Territory m_location;
    private final IBattle.BattleType m_battleType;

    private static String[] varDiceArray(GameData data) {
        String[] diceColumns = new String[data.getDiceSides() + 1];
        Integer i = 0;
        while (i < diceColumns.length) {
            diceColumns[i.intValue()] = i == 0 ? " " : i.toString();
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return diceColumns;
    }

    BattleModel(GameData data, Collection<Unit> units, Territory battleLocation, boolean attack, UIContext uiContext, IBattle.BattleType battleType) {
        super(new Object[0][0], BattleModel.varDiceArray(data));
        this.m_uiContext = uiContext;
        this.m_data = data;
        this.m_attack = attack;
        this.m_units = new ArrayList<Unit>(units);
        this.m_location = battleLocation;
        this.m_battleType = battleType;
    }

    public void notifyRetreat(Collection<Unit> retreating) {
        this.m_units.removeAll(retreating);
        this.refresh();
    }

    public void removeCasualties(Collection<Unit> killed) {
        this.m_units.removeAll(killed);
        this.refresh();
    }

    public void addUnits(Collection<Unit> units) {
        this.m_units.addAll(units);
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        List[] columns = new List[this.m_data.getDiceSides() + 1];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = new ArrayList();
        }
        ArrayList<Unit> units = new ArrayList<Unit>(this.m_units);
        DiceRoll.sortByStrength(units, !this.m_attack);
        HashSet<List<UnitSupportAttachment>> supportRules = new HashSet<List<UnitSupportAttachment>>();
        IntegerMap<UnitSupportAttachment> supportLeft = new IntegerMap<UnitSupportAttachment>();
        DiceRoll.getSupport(units, supportRules, supportLeft, this.m_data, !this.m_attack);
        Set<UnitCategory> unitCategories = UnitSeperator.categorize(units, null, false, false, false);
        for (UnitCategory category : unitCategories) {
            int i;
            UnitAttachment attachment = UnitAttachment.get(category.getType());
            int[] shift = new int[this.m_data.getDiceSides() + 1];
            for (i = category.getUnits().size(); i > 0; --i) {
                int strength;
                if (this.m_battleType.equals((Object)IBattle.BattleType.AIR_BATTLE)) {
                    strength = this.m_attack ? attachment.getAirAttack(category.getOwner()) : attachment.getAirDefense(category.getOwner());
                } else {
                    if (this.m_attack) {
                        strength = attachment.getAttack(category.getOwner());
                        if (DiceRoll.isAmphibiousMarine(attachment, this.m_data)) {
                            ++strength;
                        }
                        strength += DiceRoll.getSupport(category.getType(), supportRules, supportLeft);
                    } else {
                        strength = attachment.getDefense(category.getOwner());
                        this.m_data.acquireReadLock();
                        try {
                            strength = DiceRoll.isFirstTurnLimitedRoll(category.getOwner(), this.m_data) ? Math.min(1, strength) : (strength += DiceRoll.getSupport(category.getType(), supportRules, supportLeft));
                        }
                        finally {
                            this.m_data.releaseReadLock();
                        }
                    }
                    strength += TerritoryEffectHelper.getTerritoryCombatBonus(category.getType(), this.m_location, !this.m_attack);
                }
                int n = strength = Math.min(Math.max(strength, 0), this.m_data.getDiceSides());
                shift[n] = shift[n] + 1;
            }
            for (i = 0; i < this.m_data.getDiceSides(); ++i) {
                if (shift[i] <= 0) continue;
                columns[i].add(new TableData(category.getOwner(), shift[i], category.getType(), this.m_data, category.getDamaged(), category.getDisabled(), this.m_uiContext));
            }
        }
        int rowCount = 1;
        for (int i = 0; i < columns.length; ++i) {
            rowCount = Math.max(rowCount, columns[i].size());
        }
        this.setNumRows(rowCount);
        for (int row = 0; row < rowCount; ++row) {
            for (int column = 0; column < columns.length; ++column) {
                if (columns[column].size() > row) {
                    this.setValueAt(columns[column].get(row), row, column);
                    continue;
                }
                this.setValueAt(TableData.NULL, row, column);
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }
}

