/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.MoveValidator;
import games.strategy.triplea.delegate.dataObjects.MustMoveWithDetails;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.ui.ActionPanel;
import games.strategy.triplea.ui.DefaultMapSelectionListener;
import games.strategy.triplea.ui.EditProductionPanel;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.MapSelectionListener;
import games.strategy.triplea.ui.MouseDetails;
import games.strategy.triplea.ui.MouseOverUnitListener;
import games.strategy.triplea.ui.PlayerChooser;
import games.strategy.triplea.ui.TripleAFrame;
import games.strategy.triplea.ui.UnitChooser;
import games.strategy.triplea.ui.UnitSelectionListener;
import games.strategy.triplea.util.UnitSeperator;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditPanel
extends ActionPanel {
    private TripleAFrame m_frame;
    private Action m_addUnitsAction;
    private Action m_delUnitsAction;
    private Action m_changePUsAction;
    private Action m_changeTerritoryOwnerAction;
    private Action m_currentAction = null;
    private JLabel m_actionLabel;
    private boolean m_active = false;
    private Point m_mouseSelectedPoint;
    private Point m_mouseCurrentPoint;
    private final Set<Unit> m_selectedUnits = new LinkedHashSet<Unit>();
    private Territory m_selectedTerritory = null;
    private Territory m_currentTerritory = null;
    private final UnitSelectionListener UNIT_SELECTION_LISTENER = new UnitSelectionListener(){

        @Override
        public void unitsSelected(List<Unit> units, Territory t, MouseDetails md) {
            if (!EditPanel.this.getActive()) {
                return;
            }
            if (t == null) {
                return;
            }
            if (EditPanel.this.m_currentAction != null) {
                return;
            }
            boolean rightMouse = md.isRightButton();
            if (!EditPanel.this.m_selectedUnits.isEmpty() && EditPanel.this.m_selectedTerritory != t) {
                this.deselectUnits(new ArrayList<Unit>(EditPanel.this.m_selectedUnits), t, md);
                EditPanel.this.m_selectedTerritory = null;
            }
            if (rightMouse && EditPanel.this.m_selectedTerritory == t) {
                this.deselectUnits(units, t, md);
            }
            if (!rightMouse && EditPanel.this.m_currentAction == EditPanel.this.m_addUnitsAction) {
                EditPanel.this.m_selectedTerritory = t;
                EditPanel.this.MAP_SELECTION_LISTENER.territorySelected(t, md);
            } else if (!rightMouse) {
                this.selectUnitsToRemove(units, t, md);
            }
            EditPanel.this.setWidgetActivation();
        }

        private void deselectUnits(List<Unit> units, Territory t, MouseDetails md) {
            if (units.isEmpty()) {
                if (md.isControlDown() || t != EditPanel.this.m_selectedTerritory) {
                    EditPanel.this.m_selectedUnits.clear();
                } else {
                    EditPanel.this.m_selectedUnits.remove(new ArrayList(EditPanel.this.m_selectedUnits).get(EditPanel.this.m_selectedUnits.size() - 1));
                }
            } else if (md.isControlDown() || t != EditPanel.this.m_selectedTerritory) {
                EditPanel.this.m_selectedUnits.removeAll(units);
            } else {
                for (Unit unit : units) {
                    if (!EditPanel.this.m_selectedUnits.contains(unit)) continue;
                    EditPanel.this.m_selectedUnits.remove(unit);
                    break;
                }
            }
            if (EditPanel.this.m_selectedUnits.isEmpty()) {
                EditPanel.this.CANCEL_EDIT_ACTION.actionPerformed(null);
            } else {
                EditPanel.this.getMap().setMouseShadowUnits(EditPanel.this.m_selectedUnits);
            }
        }

        private void selectUnitsToRemove(List<Unit> units, Territory t, MouseDetails md) {
            if (units.isEmpty() && EditPanel.this.m_selectedUnits.isEmpty() && !md.isShiftDown()) {
                Collection<Unit> unitsToMove = t.getUnits().getUnits();
                if (unitsToMove.isEmpty()) {
                    return;
                }
                String text = "Remove from " + t.getName();
                UnitChooser chooser = new UnitChooser(unitsToMove, EditPanel.this.m_selectedUnits, null, false, false, EditPanel.this.getData(), false, EditPanel.this.getMap().getUIContext());
                int option = JOptionPane.showOptionDialog(EditPanel.this.getTopLevelAncestor(), chooser, text, 2, -1, null, null, null);
                if (option != 0) {
                    return;
                }
                if (chooser.getSelected(false).isEmpty()) {
                    return;
                }
                EditPanel.this.m_selectedUnits.addAll(chooser.getSelected(false));
            }
            if (EditPanel.this.m_selectedTerritory == null) {
                EditPanel.this.m_selectedTerritory = t;
                EditPanel.this.m_mouseSelectedPoint = md.getMapPoint();
                EditPanel.this.m_mouseCurrentPoint = md.getMapPoint();
                EditPanel.this.CANCEL_EDIT_ACTION.setEnabled(true);
            }
            if (md.isShiftDown()) {
                EditPanel.this.m_selectedUnits.addAll(t.getUnits().getUnits());
            } else if (md.isControlDown()) {
                EditPanel.this.m_selectedUnits.addAll(units);
            } else {
                for (Unit unit : units) {
                    if (EditPanel.this.m_selectedUnits.contains(unit)) continue;
                    EditPanel.this.m_selectedUnits.add(unit);
                    break;
                }
            }
            Route defaultRoute = EditPanel.this.getData().getMap().getRoute(EditPanel.this.m_selectedTerritory, EditPanel.this.m_selectedTerritory);
            EditPanel.this.getMap().setRoute(defaultRoute, EditPanel.this.m_mouseSelectedPoint, EditPanel.this.m_mouseCurrentPoint, null);
            EditPanel.this.getMap().setMouseShadowUnits(EditPanel.this.m_selectedUnits);
        }
    };
    private final MouseOverUnitListener MOUSE_OVER_UNIT_LISTENER = new MouseOverUnitListener(){

        @Override
        public void mouseEnter(List<Unit> units, Territory territory, MouseDetails md) {
            if (!EditPanel.this.getActive()) {
                return;
            }
            if (EditPanel.this.m_currentAction != null) {
                return;
            }
            if (!units.isEmpty()) {
                EditPanel.this.getMap().setUnitHighlight(units, territory);
            } else {
                EditPanel.this.getMap().setUnitHighlight(null, null);
            }
        }
    };
    private final MapSelectionListener MAP_SELECTION_LISTENER = new DefaultMapSelectionListener(){

        public void territorySelected(Territory territory, MouseDetails md) {
            if (territory == null) {
                return;
            }
            if (EditPanel.this.m_currentAction == EditPanel.this.m_changeTerritoryOwnerAction) {
                String result;
                TerritoryAttachment ta = TerritoryAttachment.get(territory);
                if (ta == null) {
                    JOptionPane.showMessageDialog(EditPanel.this.getTopLevelAncestor(), "No TerritoryAttachment for " + territory + ".", "Could not perform edit", 0);
                    return;
                }
                PlayerID defaultPlayer = ta.getOriginalOwner();
                PlayerChooser playerChooser = new PlayerChooser(EditPanel.this.getData().getPlayerList(), defaultPlayer, EditPanel.this.getMap().getUIContext(), true);
                int option = JOptionPane.showOptionDialog(EditPanel.this.getTopLevelAncestor(), playerChooser, "Select new owner for territory", 2, -1, null, null, null);
                PlayerID player = playerChooser.getSelected();
                if (option == 0 && player != null && (result = EditPanel.this.m_frame.getEditDelegate().changeTerritoryOwner(territory, player)) != null) {
                    JOptionPane.showMessageDialog(EditPanel.this.getTopLevelAncestor(), result, "Could not perform edit", 0);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EditPanel.this.CANCEL_EDIT_ACTION.actionPerformed(null);
                    }
                });
            } else if (EditPanel.this.m_currentAction == EditPanel.this.m_addUnitsAction) {
                boolean allowNeutral = EditPanel.doesPlayerHaveUnitsOnMap(PlayerID.NULL_PLAYERID, EditPanel.this.getData());
                PlayerChooser playerChooser = new PlayerChooser(EditPanel.this.getData().getPlayerList(), EditPanel.this.getMap().getUIContext(), allowNeutral);
                int option = JOptionPane.showOptionDialog(EditPanel.this.getTopLevelAncestor(), playerChooser, "Select owner for new units", 2, -1, null, null, null);
                PlayerID player = playerChooser.getSelected();
                if (option == 0 && player != null) {
                    IntegerMap<ProductionRule> production = EditProductionPanel.getProduction(player, EditPanel.this.m_frame, EditPanel.this.getData(), EditPanel.this.getMap().getUIContext());
                    ArrayList<Unit> units = new ArrayList<Unit>();
                    for (ProductionRule productionRule : production.keySet()) {
                        int quantity = production.getInt(productionRule);
                        UnitType type = (UnitType)productionRule.getResults().keySet().iterator().next();
                        units.addAll(type.create(quantity, player));
                    }
                    String result = EditPanel.this.m_frame.getEditDelegate().addUnits(territory, units);
                    if (result != null) {
                        JOptionPane.showMessageDialog(EditPanel.this.getTopLevelAncestor(), result, "Could not perform edit", 0);
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EditPanel.this.CANCEL_EDIT_ACTION.actionPerformed(null);
                    }
                });
            }
        }

        public void mouseMoved(Territory territory, MouseDetails md) {
            if (!EditPanel.this.getActive()) {
                return;
            }
            if (territory != null) {
                if (EditPanel.this.m_currentAction == null && EditPanel.this.m_selectedTerritory != null) {
                    EditPanel.this.m_mouseCurrentPoint = md.getMapPoint();
                    EditPanel.this.getMap().setMouseShadowUnits(EditPanel.this.m_selectedUnits);
                }
                if ((EditPanel.this.m_currentAction == EditPanel.this.m_changeTerritoryOwnerAction || EditPanel.this.m_currentAction == EditPanel.this.m_addUnitsAction) && EditPanel.this.m_currentTerritory != territory) {
                    if (EditPanel.this.m_currentTerritory != null) {
                        EditPanel.this.getMap().clearTerritoryOverlay(EditPanel.this.m_currentTerritory);
                    }
                    EditPanel.this.m_currentTerritory = territory;
                    EditPanel.this.getMap().setTerritoryOverlay(EditPanel.this.m_currentTerritory, Color.WHITE, 200);
                    EditPanel.this.getMap().repaint();
                }
            }
        }
    };
    private final AbstractAction CANCEL_EDIT_ACTION = new AbstractAction("Cancel"){

        public void actionPerformed(ActionEvent e) {
            EditPanel.this.m_selectedTerritory = null;
            EditPanel.this.m_selectedUnits.clear();
            this.setEnabled(false);
            EditPanel.this.getMap().setRoute(null, EditPanel.this.m_mouseSelectedPoint, EditPanel.this.m_mouseCurrentPoint, null);
            EditPanel.this.getMap().setMouseShadowUnits(null);
            if (EditPanel.this.m_currentTerritory != null) {
                EditPanel.this.getMap().clearTerritoryOverlay(EditPanel.this.m_currentTerritory);
            }
            EditPanel.this.m_currentTerritory = null;
            EditPanel.this.m_currentAction = null;
            EditPanel.this.setWidgetActivation();
        }
    };

    public EditPanel(GameData data, MapPanel map, TripleAFrame frame) {
        super(data, map);
        this.m_frame = frame;
        this.m_actionLabel = new JLabel();
        this.m_addUnitsAction = new AbstractAction("Add Units"){

            public void actionPerformed(ActionEvent event) {
                EditPanel.this.m_currentAction = this;
                EditPanel.this.setWidgetActivation();
            }
        };
        this.m_delUnitsAction = new AbstractAction("Remove Selected Units"){

            public void actionPerformed(ActionEvent event) {
                List<Unit> bestUnits;
                EditPanel.this.m_currentAction = this;
                EditPanel.this.setWidgetActivation();
                ArrayList<Unit> allUnits = new ArrayList<Unit>(EditPanel.this.m_selectedTerritory.getUnits().getUnits());
                EditPanel.this.sortUnitsToRemove(allUnits, EditPanel.this.m_selectedTerritory);
                MustMoveWithDetails mustMoveWithDetails = MoveValidator.getMustMoveWith(EditPanel.this.m_selectedTerritory, allUnits, new HashMap<Unit, Collection<Unit>>(), EditPanel.this.getData(), EditPanel.this.getCurrentPlayer());
                boolean mustChoose = false;
                if (EditPanel.this.m_selectedUnits.containsAll(allUnits)) {
                    mustChoose = false;
                } else {
                    int selectedCategories;
                    final HashSet<UnitType> selectedUnitTypes = new HashSet<UnitType>();
                    for (Unit u : EditPanel.this.m_selectedUnits) {
                        selectedUnitTypes.add(u.getType());
                    }
                    List<Unit> allOfCorrectType = Match.getMatches(allUnits, new Match<Unit>(){

                        @Override
                        public boolean match(Unit o) {
                            return selectedUnitTypes.contains(o.getType());
                        }
                    });
                    int allCategories = UnitSeperator.categorize(allOfCorrectType, mustMoveWithDetails.getMustMoveWith(), true, true).size();
                    boolean bl = mustChoose = allCategories != (selectedCategories = UnitSeperator.categorize(EditPanel.this.m_selectedUnits, mustMoveWithDetails.getMustMoveWith(), true, true).size());
                }
                if (mustChoose) {
                    String chooserText = "Remove units from " + EditPanel.this.m_selectedTerritory + ":";
                    UnitChooser chooser = new UnitChooser(allUnits, EditPanel.this.m_selectedUnits, mustMoveWithDetails.getMustMoveWith(), true, false, EditPanel.this.getData(), false, EditPanel.this.getMap().getUIContext());
                    int option = JOptionPane.showOptionDialog(EditPanel.this.getTopLevelAncestor(), chooser, chooserText, 2, -1, null, null, null);
                    if (option != 0) {
                        EditPanel.this.CANCEL_EDIT_ACTION.actionPerformed(null);
                        return;
                    }
                    bestUnits = chooser.getSelected(true);
                } else {
                    bestUnits = new ArrayList<Unit>(EditPanel.this.m_selectedUnits);
                }
                String result = EditPanel.this.m_frame.getEditDelegate().removeUnits(EditPanel.this.m_selectedTerritory, bestUnits);
                if (result != null) {
                    JOptionPane.showMessageDialog(EditPanel.this.getTopLevelAncestor(), result, MyFormatter.pluralize("Could not remove unit", EditPanel.this.m_selectedUnits.size()), 0);
                }
                EditPanel.this.CANCEL_EDIT_ACTION.actionPerformed(null);
            }
        };
        this.m_changeTerritoryOwnerAction = new AbstractAction("Change Territory Owner"){

            public void actionPerformed(ActionEvent event) {
                EditPanel.this.m_currentAction = this;
                EditPanel.this.setWidgetActivation();
            }
        };
        this.m_changePUsAction = new AbstractAction("Change PUs"){
            private static final long serialVersionUID = -2751668909341983795L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent event) {
                int oldTotal;
                EditPanel.this.m_currentAction = this;
                EditPanel.this.setWidgetActivation();
                PlayerChooser playerChooser = new PlayerChooser(EditPanel.this.getData().getPlayerList(), EditPanel.this.getMap().getUIContext(), false);
                int option = JOptionPane.showOptionDialog(EditPanel.this.getTopLevelAncestor(), playerChooser, "Select owner of PUs to change", 2, -1, null, null, null);
                if (option != 0) {
                    return;
                }
                PlayerID player = playerChooser.getSelected();
                if (player == null) {
                    return;
                }
                Resource PUs = null;
                EditPanel.this.getData().acquireReadLock();
                try {
                    PUs = EditPanel.this.getData().getResourceList().getResource("PUs");
                }
                finally {
                    EditPanel.this.getData().releaseReadLock();
                }
                if (PUs == null) {
                    return;
                }
                int newTotal = oldTotal = player.getResources().getQuantity(PUs);
                JTextField PUsField = new JTextField(String.valueOf(oldTotal), 4);
                PUsField.setMaximumSize(PUsField.getPreferredSize());
                option = JOptionPane.showOptionDialog(EditPanel.this.getTopLevelAncestor(), new JScrollPane(PUsField), "Select new number of PUs", 2, -1, null, null, null);
                if (option != 0) {
                    return;
                }
                try {
                    newTotal = Integer.parseInt(PUsField.getText());
                }
                catch (Exception e) {
                    // empty catch block
                }
                String result = EditPanel.this.m_frame.getEditDelegate().changePUs(player, newTotal);
                if (result != null) {
                    JOptionPane.showMessageDialog(EditPanel.this.getTopLevelAncestor(), result, "Could not perform edit", 0);
                }
                EditPanel.this.CANCEL_EDIT_ACTION.actionPerformed(null);
            }
        };
        this.m_actionLabel.setText("Edit Mode Actions");
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(5, 5, 0, 0));
        this.add(this.m_actionLabel);
        this.add(new JButton(this.m_addUnitsAction));
        this.add(new JButton(this.m_delUnitsAction));
        this.add(new JButton(this.m_changeTerritoryOwnerAction));
        this.add(new JButton(this.m_changePUsAction));
        this.add(Box.createVerticalStrut(15));
        this.setWidgetActivation();
    }

    private void sortUnitsToRemove(List<Unit> units, Territory territory) {
        if (units.isEmpty()) {
            return;
        }
        Collections.sort(units, EditPanel.getRemovableUnitsOrder(units, territory, true));
    }

    public static Comparator<Unit> getRemovableUnitsOrder(List<Unit> units, Territory territory, final boolean noTies) {
        Comparator<Unit> removableUnitsOrder = new Comparator<Unit>(){

            @Override
            public int compare(Unit unit1, Unit unit2) {
                int left2;
                int left1;
                TripleAUnit u1 = TripleAUnit.get(unit1);
                TripleAUnit u2 = TripleAUnit.get(unit2);
                if (UnitAttachment.get(u1.getType()).getTransportCapacity() != -1) {
                    int cost2;
                    int cost1;
                    List<Unit> transporting1 = u1.getTransporting();
                    List<Unit> transporting2 = u2.getTransporting();
                    if (transporting1 == null) {
                        transporting1 = Collections.emptyList();
                    }
                    if (transporting2 == null) {
                        transporting2 = Collections.emptyList();
                    }
                    if ((cost1 = MoveValidator.getTransportCost(transporting1)) != (cost2 = MoveValidator.getTransportCost(transporting2))) {
                        return cost2 - cost1;
                    }
                }
                if ((left1 = u1.getMovementLeft()) != (left2 = u2.getMovementLeft())) {
                    return left1 - left2;
                }
                if (noTies) {
                    return u1.hashCode() - u2.hashCode();
                }
                return 0;
            }
        };
        return removableUnitsOrder;
    }

    private void setWidgetActivation() {
        if (this.m_frame.getEditDelegate() == null) {
            this.m_addUnitsAction.setEnabled(false);
            this.m_delUnitsAction.setEnabled(false);
            this.m_changeTerritoryOwnerAction.setEnabled(false);
            this.m_changePUsAction.setEnabled(false);
        } else {
            this.m_addUnitsAction.setEnabled(this.m_currentAction == null && this.m_selectedUnits.isEmpty());
            this.m_delUnitsAction.setEnabled(!this.m_selectedUnits.isEmpty());
            this.m_changeTerritoryOwnerAction.setEnabled(this.m_currentAction == null && this.m_selectedUnits.isEmpty());
            this.m_changePUsAction.setEnabled(this.m_currentAction == null && this.m_selectedUnits.isEmpty());
        }
    }

    @Override
    public String toString() {
        return "EditPanel";
    }

    @Override
    public void setActive(boolean active) {
        if (this.m_frame.getEditDelegate() == null) {
            this.getMap().removeMapSelectionListener(this.MAP_SELECTION_LISTENER);
            this.getMap().removeUnitSelectionListener(this.UNIT_SELECTION_LISTENER);
            this.getMap().removeMouseOverUnitListener(this.MOUSE_OVER_UNIT_LISTENER);
            this.setWidgetActivation();
        } else if (!this.m_active && active) {
            this.getMap().addMapSelectionListener(this.MAP_SELECTION_LISTENER);
            this.getMap().addUnitSelectionListener(this.UNIT_SELECTION_LISTENER);
            this.getMap().addMouseOverUnitListener(this.MOUSE_OVER_UNIT_LISTENER);
            this.setWidgetActivation();
        } else if (!active && this.m_active) {
            this.getMap().removeMapSelectionListener(this.MAP_SELECTION_LISTENER);
            this.getMap().removeUnitSelectionListener(this.UNIT_SELECTION_LISTENER);
            this.getMap().removeMouseOverUnitListener(this.MOUSE_OVER_UNIT_LISTENER);
            this.CANCEL_EDIT_ACTION.actionPerformed(null);
        }
        this.m_active = active;
    }

    @Override
    public boolean getActive() {
        return this.m_active;
    }

    private static boolean doesPlayerHaveUnitsOnMap(PlayerID player, GameData data) {
        for (Territory t : data.getMap()) {
            for (Unit u : t.getUnits()) {
                if (!u.getOwner().equals(player)) continue;
                return true;
            }
        }
        return false;
    }
}

