/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.ui.ProductionPanel;
import games.strategy.triplea.ui.UIContext;
import games.strategy.util.IntegerMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditProductionPanel
extends ProductionPanel {
    public static IntegerMap<ProductionRule> getProduction(PlayerID id, JFrame parent, GameData data, UIContext context) {
        return new EditProductionPanel(context).show(id, parent, data, false, new IntegerMap<ProductionRule>());
    }

    private EditProductionPanel(UIContext uiContext) {
        super(uiContext);
    }

    protected void setLeft(int left) {
    }

    @Override
    protected void calculateLimits() {
        for (ProductionPanel.Rule current : this.getRules()) {
            current.setMax(99);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initRules(PlayerID player, GameData data, IntegerMap<ProductionRule> initialPurchase) {
        this.m_data.acquireReadLock();
        try {
            this.m_id = player;
            HashSet<UnitType> unitsAllowed = new HashSet<UnitType>();
            if (player.getProductionFrontier() != null) {
                for (ProductionRule productionRule : player.getProductionFrontier()) {
                    ProductionPanel.Rule rule = new ProductionPanel.Rule(this, productionRule, player);
                    for (Map.Entry<NamedAttachable, Integer> entry : productionRule.getResults().entrySet()) {
                        if (!UnitType.class.isAssignableFrom(entry.getKey().getClass())) continue;
                        unitsAllowed.add((UnitType)entry.getKey());
                    }
                    int initialQuantity = initialPurchase.getInt(productionRule);
                    rule.setQuantity(initialQuantity);
                    this.m_rules.add(rule);
                }
            }
            for (Territory t : data.getMap()) {
                for (Unit u : t.getUnits()) {
                    UnitType ut;
                    if (!u.getOwner().equals(player) || unitsAllowed.contains(ut = u.getType())) continue;
                    unitsAllowed.add(ut);
                    IntegerMap<NamedAttachable> result = new IntegerMap<NamedAttachable>();
                    result.add((NamedAttachable)ut, 1);
                    IntegerMap<Resource> cost = new IntegerMap<Resource>();
                    cost.add(data.getResourceList().getResource("PUs"), 1);
                    ProductionRule newRule = new ProductionRule(ut.getName(), data, result, cost);
                    ProductionPanel.Rule rule = new ProductionPanel.Rule(this, newRule, player);
                    rule.setQuantity(0);
                    this.m_rules.add(rule);
                }
            }
        }
        finally {
            this.m_data.releaseReadLock();
        }
    }
}

