/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.stats.AbstractStat;
import games.strategy.engine.stats.IStat;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.TechAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TechAdvance;
import games.strategy.triplea.ui.StatPanel;
import games.strategy.util.CompositeMatchAnd;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ExtendedStats
extends StatPanel {
    private IStat[] m_statsExtended = new IStat[0];

    public ExtendedStats(GameData data) {
        super(data);
    }

    protected void initLayout() {
    }

    public void setGameData(GameData data) {
        super.setGameData(data);
    }

    public IStat[] getStatsExtended(GameData data) {
        if (this.m_statsExtended.length == 0) {
            this.fillExtendedStats(data);
        }
        return this.m_statsExtended;
    }

    private void fillExtendedStats(GameData data) {
        ArrayList<IStat> statsExtended;
        List<Resource> resources = data.getResourceList().getResources();
        for (Resource r : resources) {
            if (r.getName().equals("PUs") || r.getName().equals("techTokens")) continue;
            GenericResourceStat resourceStat = new GenericResourceStat();
            resourceStat.init(r.getName());
            statsExtended = new ArrayList<IStat>(Arrays.asList(this.m_statsExtended));
            statsExtended.add(resourceStat);
            this.m_statsExtended = statsExtended.toArray(new IStat[statsExtended.size()]);
        }
        if (Properties.getTechDevelopment(data)) {
            ArrayList<IStat> statsExtended2;
            if (data.getResourceList().getResource("techTokens") != null) {
                statsExtended2 = new ArrayList<IStat>(Arrays.asList(this.m_statsExtended));
                statsExtended2.add(new TechTokenStat());
                this.m_statsExtended = statsExtended2.toArray(new IStat[statsExtended2.size()]);
            }
            statsExtended2 = new ArrayList<IStat>(Arrays.asList(this.m_statsExtended));
            statsExtended2.add(new TechCountStat());
            this.m_statsExtended = statsExtended2.toArray(new IStat[statsExtended2.size()]);
            for (TechAdvance ta : TechAdvance.getTechAdvances(this.m_data, null)) {
                GenericTechNameStat techNameStat = new GenericTechNameStat();
                techNameStat.init(ta);
                statsExtended = new ArrayList<IStat>(Arrays.asList(this.m_statsExtended));
                statsExtended.add(techNameStat);
                this.m_statsExtended = statsExtended.toArray(new IStat[statsExtended.size()]);
            }
        }
        for (UnitType ut : data.getUnitTypeList()) {
            GenericUnitNameStat unitNameStat = new GenericUnitNameStat();
            unitNameStat.init(ut);
            statsExtended = new ArrayList<IStat>(Arrays.asList(this.m_statsExtended));
            statsExtended.add(unitNameStat);
            this.m_statsExtended = statsExtended.toArray(new IStat[statsExtended.size()]);
        }
    }

    public IStat[] getStats() {
        return this.m_stats;
    }

    class TechTokenStat
    extends StatPanel.ResourceStat {
        public TechTokenStat() {
            super(ExtendedStats.this, ExtendedStats.this.m_data.getResourceList().getResource("techTokens"));
        }
    }

    class GenericUnitNameStat
    extends AbstractStat {
        private UnitType m_ut = null;

        GenericUnitNameStat() {
        }

        public void init(UnitType ut) {
            this.m_ut = ut;
        }

        public String getName() {
            return "UnitType: " + this.m_ut.getName();
        }

        public double getValue(PlayerID player, GameData data) {
            int rVal = 0;
            CompositeMatchAnd<Unit> ownedBy = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.unitIsOfType(this.m_ut));
            for (Territory place : data.getMap().getTerritories()) {
                rVal += place.getUnits().countMatches(ownedBy);
            }
            return rVal;
        }
    }

    class GenericTechNameStat
    extends AbstractStat {
        private TechAdvance m_ta = null;

        GenericTechNameStat() {
        }

        public void init(TechAdvance ta) {
            this.m_ta = ta;
        }

        public String getName() {
            return "TechAdvance: " + this.m_ta.getName();
        }

        public double getValue(PlayerID player, GameData data) {
            if (this.m_ta.hasTech(TechAttachment.get(player))) {
                return 1.0;
            }
            return 0.0;
        }
    }

    class GenericResourceStat
    extends AbstractStat {
        private String m_name = null;

        GenericResourceStat() {
        }

        public void init(String name) {
            this.m_name = name;
        }

        public String getName() {
            return "Resource: " + this.m_name;
        }

        public double getValue(PlayerID player, GameData data) {
            return player.getResources().getQuantity(this.m_name);
        }
    }

    class TechCountStat
    extends AbstractStat {
        TechCountStat() {
        }

        public String getName() {
            return "Techs";
        }

        public double getValue(PlayerID player, GameData data) {
            int count = 0;
            TechAttachment ta = TechAttachment.get(player);
            if (ta.getHeavyBomber()) {
                ++count;
            }
            if (ta.getLongRangeAir()) {
                ++count;
            }
            if (ta.getJetPower()) {
                ++count;
            }
            if (ta.getRocket()) {
                ++count;
            }
            if (ta.getIndustrialTechnology()) {
                ++count;
            }
            if (ta.getSuperSub()) {
                ++count;
            }
            if (ta.getDestroyerBombard()) {
                ++count;
            }
            if (ta.getImprovedArtillerySupport()) {
                ++count;
            }
            if (ta.getParatroopers()) {
                ++count;
            }
            if (ta.getIncreasedFactoryProduction()) {
                ++count;
            }
            if (ta.getWarBonds()) {
                ++count;
            }
            if (ta.getMechanizedInfantry()) {
                ++count;
            }
            if (ta.getAARadar()) {
                ++count;
            }
            if (ta.getShipyards()) {
                ++count;
            }
            for (boolean value : ta.getGenericTech().values()) {
                if (!value) continue;
                ++count;
            }
            return count;
        }
    }
}

