/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Territory;
import games.strategy.triplea.ResourceLoader;
import games.strategy.util.PointFileReaderWriter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapData {
    private static final String DEFAULT_UNIT_SCALE_PROPERTY = "units.scale";
    private static final String HAS_RELIEF_IMAGES = "map.hasRelief";
    private static final String HAS_MAP_BLENDS = "map.mapBlends";
    private static final String MAP_BLEND_MODE = "map.mapBlendMode";
    private static final String MAP_BLEND_ALPHA = "map.mapBlendAlpha";
    private static final String SHOW_CAPITOL_MARKERS = "map.showCapitolMarkers";
    private static final String SHOW_TERRITORY_NAMES = "map.showTerritoryNames";
    private static final String SHOW_CONVOY_NAMES = "map.showConvoyNames";
    private static final String USE_NATION_CONVOY_FLAGS = "map.useNation_convoyFlags";
    private static final String USE_TERRITORY_EFFECTS_MARKERS = "map.useTerritoryEffectMarkers";
    private static final String CENTERS_FILE = "centers.txt";
    private static final String POLYGON_FILE = "polygons.txt";
    private static final String PLACEMENT_FILE = "place.txt";
    private static final String TERRITORY_EFFECT_FILE = "territory_effects.txt";
    private static final String MAP_PROPERTIES = "map.properties";
    private static final String CAPITAL_MARKERS = "capitols.txt";
    private static final String CONVOY_MARKERS = "convoy.txt";
    private static final String VC_MARKERS = "vc.txt";
    private static final String BLOCKADE_MARKERS = "blockade.txt";
    private static final String IMPASSIBLE = "Impassible";
    private static final String PU_PLACE_FILE = "pu_place.txt";
    private static final String TERRITORY_NAME_PLACE_FILE = "name_place.txt";
    private static final String KAMIKAZE_FILE = "kamikaze_place.txt";
    private static final String DONT_DRAW_TERRITORY_NAME = "dont_draw_territory_names";
    private static final String DECORATIONS_FILE = "decorations.txt";
    private final List<Color> m_defaultColours = new ArrayList<Color>(Arrays.asList(Color.RED, Color.MAGENTA, Color.YELLOW, Color.ORANGE, Color.CYAN, Color.GREEN, Color.PINK, Color.GRAY));
    private final Map<String, Color> m_playerColors = new HashMap<String, Color>();
    private Map<String, List<Point>> m_place;
    private Map<String, List<Polygon>> m_polys;
    private Map<String, Point> m_centers;
    private Map<String, Point> m_vcPlace;
    private Map<String, Point> m_blockadePlace;
    private Map<String, Point> m_convoyPlace;
    private Map<String, Point> m_PUPlace;
    private Map<String, Point> m_namePlace;
    private Map<String, Point> m_kamikazePlace;
    private Map<String, Point> m_capitolPlace;
    private Map<String, List<String>> m_contains;
    private Properties m_mapProperties;
    private Map<String, List<Point>> m_territoryEffects;
    private Set<String> m_undrawnTerritoriesNames;
    private Map<Image, List<Point>> m_decorations;
    private final Map<String, Image> m_effectImages = new HashMap<String, Image>();
    private final ResourceLoader m_resourceLoader;
    private BufferedImage m_vcImage;
    private BufferedImage m_blockadeImage;
    private BufferedImage m_errorImage = null;
    private BufferedImage m_warningImage = null;
    private BufferedImage m_infoImage = null;
    private BufferedImage m_helpImage = null;

    public boolean scrollWrapX() {
        return Boolean.valueOf(this.m_mapProperties.getProperty("map.scrollWrapX", "true"));
    }

    public MapData(String mapNameDir) {
        this(ResourceLoader.getMapResourceLoader(mapNameDir));
    }

    public MapData(ResourceLoader loader) {
        this.m_resourceLoader = loader;
        try {
            String prefix = "";
            this.m_place = PointFileReaderWriter.readOneToMany(loader.getResourceAsStream(PLACEMENT_FILE));
            this.m_territoryEffects = PointFileReaderWriter.readOneToMany(loader.getResourceAsStream(TERRITORY_EFFECT_FILE));
            this.m_polys = PointFileReaderWriter.readOneToManyPolygons(loader.getResourceAsStream(POLYGON_FILE));
            this.m_centers = PointFileReaderWriter.readOneToOneCenters(loader.getResourceAsStream(CENTERS_FILE));
            this.m_vcPlace = PointFileReaderWriter.readOneToOne(loader.getResourceAsStream(VC_MARKERS));
            this.m_convoyPlace = PointFileReaderWriter.readOneToOne(loader.getResourceAsStream(CONVOY_MARKERS));
            this.m_blockadePlace = PointFileReaderWriter.readOneToOne(loader.getResourceAsStream(BLOCKADE_MARKERS));
            this.m_capitolPlace = PointFileReaderWriter.readOneToOne(loader.getResourceAsStream(CAPITAL_MARKERS));
            this.m_PUPlace = PointFileReaderWriter.readOneToOne(loader.getResourceAsStream(PU_PLACE_FILE));
            this.m_namePlace = PointFileReaderWriter.readOneToOne(loader.getResourceAsStream(TERRITORY_NAME_PLACE_FILE));
            this.m_kamikazePlace = PointFileReaderWriter.readOneToOne(loader.getResourceAsStream(KAMIKAZE_FILE));
            this.m_mapProperties = new Properties();
            this.loadDecorations();
            try {
                URL url = loader.getResource(MAP_PROPERTIES);
                if (url == null) {
                    throw new IllegalStateException("No map.properties file defined");
                }
                this.m_mapProperties.load(url.openStream());
            }
            catch (Exception e) {
                System.out.println("Error reading map.properties:" + e);
            }
            this.initializeContains();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void close() {
        this.m_resourceLoader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDecorations() throws IOException {
        URL decorations = this.m_resourceLoader.getResource(DECORATIONS_FILE);
        if (decorations == null) {
            this.m_decorations = Collections.emptyMap();
            return;
        }
        this.m_decorations = new HashMap<Image, List<Point>>();
        InputStream stream = null;
        try {
            stream = decorations.openStream();
            Map<String, List<Point>> points = PointFileReaderWriter.readOneToMany(stream);
            for (String name : points.keySet()) {
                BufferedImage img = this.loadImage("misc/" + name);
                this.m_decorations.put(img, points.get(name));
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public double getDefaultUnitScale() {
        if (this.m_mapProperties.getProperty(DEFAULT_UNIT_SCALE_PROPERTY) == null) {
            return 1.0;
        }
        try {
            return Double.parseDouble(this.m_mapProperties.getProperty(DEFAULT_UNIT_SCALE_PROPERTY));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 1.0;
        }
    }

    public boolean shouldDrawTerritoryName(String territoryName) {
        if (this.m_undrawnTerritoriesNames == null) {
            String property = this.m_mapProperties.getProperty(DONT_DRAW_TERRITORY_NAME, "");
            this.m_undrawnTerritoriesNames = new HashSet<String>(Arrays.asList(property.split(",")));
        }
        return !this.m_undrawnTerritoriesNames.contains(territoryName);
    }

    public boolean getHasRelief() {
        return Boolean.valueOf(this.m_mapProperties.getProperty(HAS_RELIEF_IMAGES, "true"));
    }

    public boolean getHasMapBlends() {
        return Boolean.valueOf(this.m_mapProperties.getProperty(HAS_MAP_BLENDS, "false"));
    }

    public String getMapBlendMode() {
        return String.valueOf(this.m_mapProperties.getProperty(MAP_BLEND_MODE, "normal")).toString();
    }

    public float getMapBlendAlpha() {
        return Float.valueOf(this.m_mapProperties.getProperty(MAP_BLEND_ALPHA, "0.5f")).floatValue();
    }

    public boolean drawCapitolMarkers() {
        return Boolean.valueOf(this.m_mapProperties.getProperty(SHOW_CAPITOL_MARKERS, "true"));
    }

    public boolean drawTerritoryNames() {
        return Boolean.valueOf(this.m_mapProperties.getProperty(SHOW_TERRITORY_NAMES, "true"));
    }

    public boolean drawConvoyNames() {
        return Boolean.valueOf(this.m_mapProperties.getProperty(SHOW_CONVOY_NAMES, "true"));
    }

    public boolean useNation_convoyFlags() {
        return Boolean.valueOf(this.m_mapProperties.getProperty(USE_NATION_CONVOY_FLAGS, "false"));
    }

    public boolean useTerritoryEffectMarkers() {
        return Boolean.valueOf(this.m_mapProperties.getProperty(USE_TERRITORY_EFFECTS_MARKERS, "false"));
    }

    private void initializeContains() {
        this.m_contains = new HashMap<String, List<String>>();
        Iterator<String> seaIter = this.getTerritories().iterator();
        while (seaIter.hasNext()) {
            ArrayList<String> contained = new ArrayList<String>();
            String seaTerritory = seaIter.next();
            if (!seaTerritory.endsWith("Sea Zone") && !seaTerritory.startsWith("Sea Zone")) continue;
            for (String landTerritory : this.getTerritories()) {
                if (landTerritory.endsWith("Sea Zone") || landTerritory.startsWith("Sea Zone")) continue;
                Polygon landPoly = this.getPolygons(landTerritory).iterator().next();
                Polygon seaPoly = this.getPolygons(seaTerritory).iterator().next();
                if (!seaPoly.contains(landPoly.getBounds())) continue;
                contained.add(landTerritory);
            }
            if (contained.isEmpty()) continue;
            this.m_contains.put(seaTerritory, contained);
        }
    }

    public boolean getBooleanProperty(String propertiesKey) {
        return Boolean.valueOf(this.m_mapProperties.getProperty(propertiesKey, "true"));
    }

    public Color getColorProperty(String propertiesKey) throws IllegalStateException {
        if (this.m_mapProperties.getProperty(propertiesKey) != null) {
            String colorString = this.m_mapProperties.getProperty(propertiesKey);
            if (colorString.length() != 6) {
                throw new IllegalStateException("Colors must be a 6 digit hex number, eg FF0011, not:" + colorString);
            }
            try {
                Integer colorInt = Integer.decode("0x" + colorString);
                Color color = new Color(colorInt);
                return color;
            }
            catch (NumberFormatException nfe) {
                throw new IllegalStateException("Player colors must be a 6 digit hex number, eg FF0011");
            }
        }
        return null;
    }

    public Color getPlayerColor(String playerName) {
        if (this.m_playerColors.containsKey(playerName)) {
            return this.m_playerColors.get(playerName);
        }
        String propertiesKey = "color." + playerName;
        Color color = null;
        try {
            color = this.getColorProperty(propertiesKey);
        }
        catch (Exception e) {
            throw new IllegalStateException("Player colors must be a 6 digit hex number, eg FF0011");
        }
        if (color == null) {
            System.out.println("No color defined for " + playerName + ".  Edit map.properties in the map folder to set it");
            color = this.m_defaultColours.remove(0);
        }
        this.m_playerColors.put(playerName, color);
        return color;
    }

    public String getProperty(String propertiesKey) {
        return this.m_mapProperties.getProperty(propertiesKey);
    }

    public Color impassibleColor() {
        return this.getPlayerColor(IMPASSIBLE);
    }

    public Set<String> getTerritories() {
        return this.m_polys.keySet();
    }

    public boolean hasContainedTerritory(String territoryName) {
        return this.m_contains.containsKey(territoryName);
    }

    public List<String> getContainedTerritory(String territoryName) {
        return this.m_contains.get(territoryName);
    }

    public void verify(GameData data) {
        this.verifyKeys(data, this.m_centers, "centers");
        this.verifyKeys(data, this.m_polys, "polygons");
        this.verifyKeys(data, this.m_place, "place");
    }

    private void verifyKeys(GameData data, Map<String, ?> aMap, String dataTypeForErrorMessage) throws IllegalStateException {
        StringBuilder errors = new StringBuilder();
        Iterator<String> iter = aMap.keySet().iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            Territory terr = data.getMap().getTerritory(name);
            if (terr != null) continue;
            iter.remove();
        }
        Iterator<Territory> territories = data.getMap().getTerritories().iterator();
        Set<String> keySet = aMap.keySet();
        while (territories.hasNext()) {
            Territory terr = territories.next();
            if (keySet.contains(terr.getName())) continue;
            errors.append("No data of type " + dataTypeForErrorMessage + " for territory:" + terr.getName() + "\n");
        }
        if (errors.length() > 0) {
            throw new IllegalStateException(errors.toString());
        }
    }

    public List<Point> getPlacementPoints(Territory terr) {
        return this.m_place.get(terr.getName());
    }

    public List<Polygon> getPolygons(String terr) {
        return this.m_polys.get(terr);
    }

    public List<Polygon> getPolygons(Territory terr) {
        return this.getPolygons(terr.getName());
    }

    public Point getCenter(String terr) {
        if (this.m_centers.get(terr) == null) {
            throw new IllegalStateException("Missing centers.txt data for " + terr);
        }
        return new Point(this.m_centers.get(terr));
    }

    public Point getCenter(Territory terr) {
        return this.getCenter(terr.getName());
    }

    public Point getCapitolMarkerLocation(Territory terr) {
        if (this.m_capitolPlace.containsKey(terr.getName())) {
            return this.m_capitolPlace.get(terr.getName());
        }
        return this.getCenter(terr);
    }

    public Point getConvoyMarkerLocation(Territory terr) {
        if (this.m_convoyPlace.containsKey(terr.getName())) {
            return this.m_convoyPlace.get(terr.getName());
        }
        return this.getCenter(terr);
    }

    public Point getKamikazeMarkerLocation(Territory terr) {
        if (this.m_kamikazePlace.containsKey(terr.getName())) {
            return this.m_kamikazePlace.get(terr.getName());
        }
        return this.getCenter(terr);
    }

    public Point getVCPlacementPoint(Territory terr) {
        if (this.m_vcPlace.containsKey(terr.getName())) {
            return this.m_vcPlace.get(terr.getName());
        }
        return this.getCenter(terr);
    }

    public Point getBlockadePlacementPoint(Territory terr) {
        if (this.m_blockadePlace.containsKey(terr.getName())) {
            return this.m_blockadePlace.get(terr.getName());
        }
        return this.getCenter(terr);
    }

    public Point getPUPlacementPoint(Territory terr) {
        if (this.m_PUPlace.containsKey(terr.getName())) {
            return this.m_PUPlace.get(terr.getName());
        }
        return null;
    }

    public Point getNamePlacementPoint(Territory terr) {
        if (this.m_namePlace.containsKey(terr.getName())) {
            return this.m_namePlace.get(terr.getName());
        }
        return null;
    }

    public String getTerritoryAt(double x, double y) {
        String seaName = null;
        for (String name : this.m_polys.keySet()) {
            Collection polygons = this.m_polys.get(name);
            for (Polygon poly : polygons) {
                if (!poly.contains(x, y)) continue;
                if (name.endsWith("Sea Zone") || name.startsWith("Sea Zone")) {
                    seaName = name;
                    continue;
                }
                return name;
            }
        }
        return seaName;
    }

    public Dimension getMapDimensions() {
        String widthProperty = this.m_mapProperties.getProperty("map.width");
        String heightProperty = this.m_mapProperties.getProperty("map.height");
        if (widthProperty == null || heightProperty == null) {
            throw new IllegalStateException("Missing map.width or map.height in map.properties");
        }
        int width = Integer.parseInt(widthProperty.trim());
        int height = Integer.parseInt(heightProperty.trim());
        return new Dimension(width, height);
    }

    public Rectangle getBoundingRect(Territory terr) {
        String name = terr.getName();
        return this.getBoundingRect(name);
    }

    public Rectangle getBoundingRect(String name) {
        List<Polygon> polys = this.getPolygons(name);
        if (polys == null) {
            throw new IllegalStateException("No polygons found for:" + name + " All territories:" + this.m_polys.keySet());
        }
        Rectangle bounds = null;
        for (int i = 0; i < polys.size(); ++i) {
            Polygon item = polys.get(i);
            if (bounds == null) {
                bounds = item.getBounds();
                continue;
            }
            bounds.add(item.getBounds());
        }
        return bounds;
    }

    public List<String> territoriesThatOverlap(Rectangle2D bounds) {
        ArrayList<String> rVal = null;
        block0: for (String terr : this.getTerritories()) {
            List<Polygon> polygons = this.getPolygons(terr);
            for (int i = 0; i < polygons.size(); ++i) {
                Polygon item = polygons.get(i);
                if (!item.intersects(bounds) && !item.contains(bounds) && !bounds.contains(item.getBounds2D())) continue;
                if (rVal == null) {
                    rVal = new ArrayList<String>(4);
                }
                rVal.add(terr);
                continue block0;
            }
        }
        if (rVal == null) {
            return Collections.emptyList();
        }
        return rVal;
    }

    public Image getVCImage() {
        if (this.m_vcImage != null) {
            return this.m_vcImage;
        }
        this.m_vcImage = this.loadImage("misc/vc.png");
        return this.m_vcImage;
    }

    public Image getBlockadeImage() {
        if (this.m_blockadeImage != null) {
            return this.m_blockadeImage;
        }
        this.m_blockadeImage = this.loadImage("misc/blockade.png");
        return this.m_blockadeImage;
    }

    public Image getErrorImage() {
        if (this.m_errorImage != null) {
            return this.m_errorImage;
        }
        this.m_errorImage = this.loadImage("misc/error.gif");
        return this.m_errorImage;
    }

    public Image getWarningImage() {
        if (this.m_warningImage != null) {
            return this.m_warningImage;
        }
        this.m_warningImage = this.loadImage("misc/warning.gif");
        return this.m_warningImage;
    }

    public Image getInfoImage() {
        if (this.m_infoImage != null) {
            return this.m_infoImage;
        }
        this.m_infoImage = this.loadImage("misc/information.gif");
        return this.m_infoImage;
    }

    public Image getHelpImage() {
        if (this.m_helpImage != null) {
            return this.m_helpImage;
        }
        this.m_helpImage = this.loadImage("misc/help.gif");
        return this.m_helpImage;
    }

    private BufferedImage loadImage(String imageName) {
        URL url = this.m_resourceLoader.getResource(imageName);
        if (url == null) {
            throw new IllegalStateException("Could not load " + imageName);
        }
        try {
            return ImageIO.read(url);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Map<Image, List<Point>> getDecorations() {
        return Collections.unmodifiableMap(this.m_decorations);
    }

    public List<Point> getTerritoryEffectPoints(Territory territory) {
        if (this.m_territoryEffects.get(territory.getName()) == null) {
            return Arrays.asList(this.getCenter(territory));
        }
        return this.m_territoryEffects.get(territory.getName());
    }

    public Image getTerritoryEffectImage(String m_effectName) {
        if (this.m_effectImages.get(m_effectName) != null) {
            return this.m_effectImages.get(m_effectName);
        }
        BufferedImage effectImage = this.loadImage("territoryEffects/" + m_effectName + ".png");
        this.m_effectImages.put(m_effectName, effectImage);
        return effectImage;
    }
}

