/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.events.TerritoryListener;
import games.strategy.triplea.oddsCalculator.zengland.OCBattle;
import games.strategy.triplea.ui.DefaultMapSelectionListener;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.UIContext;
import java.awt.GridLayout;
import java.math.BigDecimal;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class OddsDetailPanel
extends JPanel {
    private static final int FIGHT_COUNT = 1000;
    private GameData m_data;
    private JLabel controlPercentLabel;
    private JLabel airWinPercentLabel;
    private JLabel clearedPercentLabel;
    private JLabel indecisivePercentLabel;
    private JLabel lossPercentLabel;
    private JLabel battlesLabel;
    private Territory m_currentTerritory;
    private final TerritoryListener m_territoryListener;

    public OddsDetailPanel(MapPanel mapPanel, GameData data, UIContext uiContext) {
        this.m_data = data;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(5, 5, 0, 0));
        mapPanel.addMapSelectionListener(new DefaultMapSelectionListener(){

            public void mouseEntered(Territory territory) {
                OddsDetailPanel.this.m_currentTerritory = territory;
                OddsDetailPanel.this.updateOdds();
            }
        });
        this.m_territoryListener = new TerritoryListener(){

            public void ownerChanged(Territory territory) {
            }

            public void attachmentChanged(Territory territory) {
            }

            public void unitsChanged(Territory territory) {
                if (OddsDetailPanel.this.m_currentTerritory != null && OddsDetailPanel.this.m_currentTerritory.equals(territory)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            OddsDetailPanel.this.updateOdds();
                        }
                    });
                }
            }
        };
        data.addTerritoryListener(this.m_territoryListener);
    }

    public void setGameData(GameData data) {
        this.m_data.removeTerritoryListener(this.m_territoryListener);
        this.m_data = data;
        this.m_currentTerritory = null;
        this.updateOdds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOdds() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Wrong thread");
        }
        this.removeAll();
        this.refresh();
        if (this.m_currentTerritory == null) {
            return;
        }
        this.add(new JLabel(this.m_currentTerritory.getName()));
        if (this.m_currentTerritory.getUnits().getPlayersWithUnits().size() < 2) {
            this.add(new JLabel("No pending battle"));
            return;
        }
        OCBattle terrBattle = null;
        this.m_data.acquireReadLock();
        try {
            terrBattle = new OCBattle(this.m_currentTerritory, this.m_data);
        }
        finally {
            this.m_data.releaseReadLock();
        }
        if (terrBattle.getAttackers().size() > 0 && terrBattle.getDefenders().size() > 0) {
            terrBattle.rollBattles(1000);
        }
        JPanel resultsPanel = new JPanel();
        resultsPanel.setLayout(new GridLayout(6, 2));
        JLabel controlLabel = new JLabel("Control");
        resultsPanel.add(controlLabel);
        this.controlPercentLabel = new JLabel(this.formattedPercent(terrBattle.getControlPercent()));
        resultsPanel.add(this.controlPercentLabel);
        JLabel airLabel = new JLabel("Air win");
        resultsPanel.add(airLabel);
        this.airWinPercentLabel = new JLabel(this.formattedPercent(terrBattle.getAirWinPercent()));
        resultsPanel.add(this.airWinPercentLabel);
        JLabel clearedLabel = new JLabel("Cleared");
        resultsPanel.add(clearedLabel);
        this.clearedPercentLabel = new JLabel(this.formattedPercent(terrBattle.getClearedPercent()));
        resultsPanel.add(this.clearedPercentLabel);
        JLabel indecisiveLabel = new JLabel("Indecisive");
        resultsPanel.add(indecisiveLabel);
        this.indecisivePercentLabel = new JLabel(this.formattedPercent(terrBattle.getIndecisivePercent()));
        resultsPanel.add(this.indecisivePercentLabel);
        JLabel lossLabel = new JLabel("Loss");
        resultsPanel.add(lossLabel);
        this.lossPercentLabel = new JLabel(this.formattedPercent(terrBattle.getLossPercent()));
        resultsPanel.add(this.lossPercentLabel);
        JLabel battlesTitleLabel = new JLabel("Battles rolled");
        resultsPanel.add(battlesTitleLabel);
        this.battlesLabel = new JLabel(String.valueOf(terrBattle.getBattles()));
        resultsPanel.add(this.battlesLabel);
        this.add(resultsPanel);
        this.add(Box.createVerticalGlue());
        this.refresh();
    }

    public String formattedPercent(float per) {
        BigDecimal bd = new BigDecimal(per);
        String res = bd.toString();
        int endSpace = 0;
        endSpace = res.indexOf(".") + 3 >= res.length() || res.indexOf(".") == -1 ? res.length() : res.indexOf(".") + 3;
        if ((res = res.substring(0, endSpace)).indexOf(".") == -1) {
            res = res + ".00";
        }
        res = res + "%";
        return res;
    }

    private void refresh() {
        this.validate();
        this.repaint();
    }
}

