/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import games.strategy.triplea.Properties;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.dataObjects.PlaceableUnits;
import games.strategy.triplea.delegate.remote.IAbstractPlaceDelegate;
import games.strategy.triplea.ui.AbstractMovePanel;
import games.strategy.triplea.ui.DefaultMapSelectionListener;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.MapSelectionListener;
import games.strategy.triplea.ui.MouseDetails;
import games.strategy.triplea.ui.PlaceData;
import games.strategy.triplea.ui.SimpleUnitPanel;
import games.strategy.triplea.ui.TripleAFrame;
import games.strategy.triplea.ui.UndoablePlacementsPanel;
import games.strategy.triplea.ui.UnitChooser;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitSeperator;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.Match;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlacePanel
extends AbstractMovePanel {
    private final JLabel actionLabel = new JLabel();
    private final JLabel m_leftToPlaceLabel = new JLabel();
    private PlaceData m_placeData;
    private final SimpleUnitPanel m_unitsToPlace;
    private final MapSelectionListener PLACE_MAP_SELECTION_LISTENER = new DefaultMapSelectionListener(){

        public void territorySelected(Territory territory, MouseDetails e) {
            int option;
            if (!PlacePanel.this.getActive() || e.getButton() != 1) {
                return;
            }
            int[] maxUnits = new int[1];
            Collection units = PlacePanel.this.getUnitsToPlace(territory, maxUnits);
            if (units.isEmpty()) {
                return;
            }
            UnitChooser chooser = new UnitChooser(units, Collections.<Unit, Collection<Unit>>emptyMap(), PlacePanel.this.getData(), false, PlacePanel.this.getMap().getUIContext());
            String messageText = "Place units in " + territory.getName();
            if (maxUnits[0] > 0) {
                chooser.setMaxAndShowMaxButton(maxUnits[0]);
            }
            if ((option = JOptionPane.showOptionDialog(PlacePanel.this.getTopLevelAncestor(), chooser, messageText, 2, -1, null, null, null)) == 0) {
                Collection<Unit> choosen = chooser.getSelected();
                PlacePanel.this.m_placeData = new PlaceData(choosen, territory);
                PlacePanel.this.updateUnits();
                if (choosen.containsAll(units)) {
                    PlacePanel.this.m_leftToPlaceLabel.setText("");
                }
                PlacePanel.this.release();
            }
        }
    };

    public PlacePanel(GameData data, MapPanel map, TripleAFrame frame) {
        super(data, map, frame);
        this.m_undoableMovesPanel = new UndoablePlacementsPanel(data, this);
        this.m_unitsToPlace = new SimpleUnitPanel(map.getUIContext());
        this.m_leftToPlaceLabel.setText("Units left to place:");
    }

    @Override
    public void display(PlayerID id) {
        super.display(id, " place");
    }

    private void refreshActionLabelText(final boolean bid) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PlacePanel.this.actionLabel.setText(PlacePanel.this.getCurrentPlayer().getName() + " place" + (bid ? " for bid" : ""));
            }
        });
    }

    public PlaceData waitForPlace(boolean bid, IPlayerBridge playerBridge) {
        this.setUp(playerBridge);
        this.refreshActionLabelText(bid);
        this.waitForRelease();
        this.cleanUp();
        return this.m_placeData;
    }

    private boolean canProduceFightersOnCarriers() {
        return Properties.getProduceFightersOnCarriers(this.getData());
    }

    private boolean canProduceNewFightersOnOldCarriers() {
        return Properties.getProduceNewFightersOnOldCarriers(this.getData());
    }

    private boolean isLHTR_Carrier_Production_Rules() {
        return Properties.getLHTRCarrierProductionRules(this.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Unit> getUnitsToPlace(Territory territory, int[] maxUnits) {
        this.getData().acquireReadLock();
        try {
            Object unitIsSeaOrCanLandOnCarrier;
            if (!territory.isWater() && !territory.getOwner().equals(this.getCurrentPlayer())) {
                List<Unit> list = Collections.emptyList();
                return list;
            }
            Collection<Unit> units = this.getCurrentPlayer().getUnits().getUnits();
            if (territory.isWater()) {
                if (!(this.canProduceFightersOnCarriers() || this.canProduceNewFightersOnOldCarriers() || this.isLHTR_Carrier_Production_Rules())) {
                    units = Match.getMatches(units, Matches.UnitIsSea);
                } else {
                    unitIsSeaOrCanLandOnCarrier = new CompositeMatchOr(Matches.UnitIsSea, Matches.UnitCanLandOnCarrier);
                    units = Match.getMatches(units, unitIsSeaOrCanLandOnCarrier);
                }
            } else {
                units = Match.getMatches(units, Matches.UnitIsNotSea);
            }
            if (units.isEmpty()) {
                unitIsSeaOrCanLandOnCarrier = Collections.emptyList();
                return unitIsSeaOrCanLandOnCarrier;
            }
            IAbstractPlaceDelegate placeDel = (IAbstractPlaceDelegate)this.getPlayerBridge().getRemote();
            PlaceableUnits production = placeDel.getPlaceableUnits(units, territory);
            if (production.isError()) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), production.getErrorMessage(), "No units", 1);
                List<Unit> list = Collections.emptyList();
                return list;
            }
            maxUnits[0] = production.getMaxUnits();
            Collection<Unit> collection = production.getUnits();
            return collection;
        }
        finally {
            this.getData().releaseReadLock();
        }
    }

    private void updateUnits() {
        Set<UnitCategory> unitCategories = UnitSeperator.categorize(this.getCurrentPlayer().getUnits().getUnits());
        this.m_unitsToPlace.setUnitsFromCategories(unitCategories, this.getData());
    }

    @Override
    public String toString() {
        return "PlacePanel";
    }

    @Override
    protected final void cancelMoveAction() {
        this.getMap().showMouseCursor();
        this.getMap().setMouseShadowUnits(null);
    }

    @Override
    protected final void undoMoveSpecific() {
        this.m_leftToPlaceLabel.setText("Units left to place:");
        this.updateUnits();
    }

    @Override
    protected final void cleanUpSpecific() {
        this.getMap().removeMapSelectionListener(this.PLACE_MAP_SELECTION_LISTENER);
    }

    @Override
    protected final void setUpSpecific() {
        this.getMap().addMapSelectionListener(this.PLACE_MAP_SELECTION_LISTENER);
    }

    @Override
    protected boolean doneMoveAction() {
        int option;
        if (this.getCurrentPlayer().getUnits().size() > 0 && (option = JOptionPane.showConfirmDialog(this.getTopLevelAncestor(), "You have not placed all your units yet.  Are you sure you want to end your turn?", "TripleA", 0, -1)) != 0) {
            return false;
        }
        this.m_placeData = null;
        return true;
    }

    @Override
    protected boolean setCancelButton() {
        return false;
    }

    @Override
    protected final void addAdditionalButtons() {
        this.add(this.leftBox(this.m_leftToPlaceLabel));
        this.add(this.m_unitsToPlace);
        this.updateUnits();
    }
}

