/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.PlayerList;
import games.strategy.triplea.ui.PlayerChooserRenderer;
import games.strategy.triplea.ui.UIContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PlayerChooser
extends JPanel {
    private JList m_list;
    private final PlayerList m_players;
    private final PlayerID m_defaultPlayer;
    private final UIContext m_uiContext;
    private final boolean m_allowNeutral;

    public PlayerChooser(PlayerList players, UIContext uiContext, boolean allowNeutral) {
        this(players, null, uiContext, allowNeutral);
    }

    public PlayerChooser(PlayerList players, PlayerID defaultPlayer, UIContext uiContext, boolean allowNeutral) {
        this.m_players = players;
        this.m_defaultPlayer = defaultPlayer;
        this.m_uiContext = uiContext;
        this.m_allowNeutral = allowNeutral;
        this.createComponents();
        this.layoutComponents();
    }

    private void createComponents() {
        ArrayList<PlayerID> players = new ArrayList<PlayerID>(this.m_players.getPlayers());
        if (this.m_allowNeutral) {
            players.add(PlayerID.NULL_PLAYERID);
        }
        this.m_list = new JList<Object>(players.toArray());
        this.m_list.setSelectionMode(0);
        this.m_list.setSelectedValue(this.m_defaultPlayer, true);
        this.m_list.setFocusable(false);
        this.m_list.setCellRenderer(new PlayerChooserRenderer(this.m_players, this.m_uiContext));
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.m_list), "Center");
    }

    public PlayerID getSelected() {
        return (PlayerID)this.m_list.getSelectedValue();
    }
}

