/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.ResourceCollection;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.ui.UIContext;
import games.strategy.ui.ScrollableTextField;
import games.strategy.ui.ScrollableTextFieldListener;
import games.strategy.util.IntegerMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductionPanel
extends JPanel {
    private JFrame m_owner;
    private JDialog m_dialog;
    protected final UIContext m_uiContext;
    protected List<Rule> m_rules = new ArrayList<Rule>();
    protected JLabel m_left = new JLabel();
    protected JButton m_done;
    protected PlayerID m_id;
    private boolean m_bid;
    protected GameData m_data;
    Action m_done_action = new AbstractAction("Done"){

        public void actionPerformed(ActionEvent e) {
            ProductionPanel.this.m_dialog.setVisible(false);
        }
    };

    public static IntegerMap<ProductionRule> getProduction(PlayerID id, JFrame parent, GameData data, boolean bid, IntegerMap<ProductionRule> initialPurchase, UIContext context) {
        return new ProductionPanel(context).show(id, parent, data, bid, initialPurchase);
    }

    public IntegerMap<ProductionRule> show(PlayerID id, JFrame parent, GameData data, boolean bid, IntegerMap<ProductionRule> initialPurchase) {
        if (parent != this.m_owner) {
            this.m_dialog = null;
        }
        if (this.m_dialog == null) {
            this.initDialog(parent);
        }
        this.m_bid = bid;
        this.m_data = data;
        this.initRules(id, data, initialPurchase);
        this.initLayout(id);
        this.calculateLimits();
        this.m_dialog.pack();
        this.m_dialog.setLocationRelativeTo(parent);
        this.m_done.requestFocusInWindow();
        this.m_dialog.setVisible(true);
        this.m_dialog.dispose();
        return this.getProduction();
    }

    protected List<Rule> getRules() {
        return this.m_rules;
    }

    private void initDialog(JFrame root) {
        this.m_dialog = new JDialog(root, "Produce", true);
        this.m_dialog.getContentPane().add(this);
        AbstractAction closeAction = new AbstractAction(""){

            public void actionPerformed(ActionEvent e) {
                ProductionPanel.this.m_dialog.setVisible(false);
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        String key = "production.panel.close.prod.popup";
        this.m_dialog.getRootPane().getActionMap().put("production.panel.close.prod.popup", closeAction);
        this.m_dialog.getRootPane().getInputMap(2).put(stroke, "production.panel.close.prod.popup");
    }

    protected ProductionPanel(UIContext uiContext) {
        this.m_uiContext = uiContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initRules(PlayerID player, GameData data, IntegerMap<ProductionRule> initialPurchase) {
        this.m_data.acquireReadLock();
        try {
            this.m_id = player;
            for (ProductionRule productionRule : player.getProductionFrontier()) {
                Rule rule = new Rule(productionRule, player);
                int initialQuantity = initialPurchase.getInt(productionRule);
                rule.setQuantity(initialQuantity);
                this.m_rules.add(rule);
            }
        }
        finally {
            this.m_data.releaseReadLock();
        }
    }

    protected void initLayout(PlayerID id) {
        Insets nullInsets = new Insets(0, 0, 0, 0);
        this.removeAll();
        this.setLayout(new GridBagLayout());
        ResourceCollection totalWithoutTechTokensOrVPs = new ResourceCollection(this.getResources());
        this.m_data.acquireReadLock();
        totalWithoutTechTokensOrVPs.removeAllOfResource(this.m_data.getResourceList().getResource("VPs"));
        totalWithoutTechTokensOrVPs.removeAllOfResource(this.m_data.getResourceList().getResource("techTokens"));
        this.m_data.releaseReadLock();
        JLabel legendLabel = new JLabel("<html>Attack/Defense/Movement. &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; (Total Resources: " + totalWithoutTechTokensOrVPs.toString() + ")</html>");
        this.add((Component)legendLabel, new GridBagConstraints(0, 0, 30, 1, 1.0, 1.0, 13, 2, new Insets(8, 8, 8, 0), 0, 0));
        int rows = this.m_rules.size() / 7;
        rows = Math.max(2, rows);
        for (int x = 0; x < this.m_rules.size(); ++x) {
            this.add((Component)this.m_rules.get(x).getPanelComponent(), new GridBagConstraints(x / rows, x % rows + 1, 1, 1, 1.0, 1.0, 13, 1, nullInsets, 0, 0));
        }
        int startY = this.m_rules.size() / rows;
        this.add((Component)this.m_left, new GridBagConstraints(0, startY + 1, 30, 1, 1.0, 1.0, 17, 0, new Insets(8, 8, 0, 12), 0, 0));
        this.m_done = new JButton(this.m_done_action);
        this.add((Component)this.m_done, new GridBagConstraints(0, startY + 2, 30, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 8, 0), 0, 0));
    }

    protected void setLeft(ResourceCollection left, int totalUnits) {
        ResourceCollection leftWithoutTechTokensOrVPs = new ResourceCollection(left);
        this.m_data.acquireReadLock();
        leftWithoutTechTokensOrVPs.removeAllOfResource(this.m_data.getResourceList().getResource("VPs"));
        leftWithoutTechTokensOrVPs.removeAllOfResource(this.m_data.getResourceList().getResource("techTokens"));
        this.m_data.releaseReadLock();
        this.m_left.setText(totalUnits + " total units purchased.  You have " + leftWithoutTechTokensOrVPs.toString() + " left");
    }

    private IntegerMap<ProductionRule> getProduction() {
        IntegerMap<ProductionRule> prod = new IntegerMap<ProductionRule>();
        for (Rule rule : this.m_rules) {
            int quantity = rule.getQuantity();
            if (quantity == 0) continue;
            prod.put(rule.getProductionRule(), quantity);
        }
        return prod;
    }

    protected void calculateLimits() {
        ResourceCollection resources = this.getResources();
        ResourceCollection spent = new ResourceCollection(this.m_data);
        int totalUnits = 0;
        for (Rule current : this.m_rules) {
            spent.add(current.getCost(), current.getQuantity());
            totalUnits += current.getQuantity() * current.getProductionRule().getResults().totalValues();
        }
        ResourceCollection leftToSpend = resources.difference(spent);
        this.setLeft(leftToSpend, totalUnits);
        for (Rule current : this.m_rules) {
            int max = leftToSpend.fitsHowOften(current.getCost());
            current.setMax(max += current.getQuantity());
        }
    }

    protected ResourceCollection getResources() {
        if (this.m_bid) {
            String propertyName = this.m_id.getName() + " bid";
            int bid = this.m_data.getProperties().get(propertyName, 0);
            ResourceCollection bidCollection = new ResourceCollection(this.m_data);
            this.m_data.acquireReadLock();
            bidCollection.addResource(this.m_data.getResourceList().getResource("PUs"), bid);
            this.m_data.releaseReadLock();
            return bidCollection;
        }
        return this.m_id.getResources();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Rule {
        private final IntegerMap<Resource> m_cost;
        private int m_quantity;
        private final ProductionRule m_rule;
        private final PlayerID m_id;
        private final Set<ScrollableTextField> m_textFields = new HashSet<ScrollableTextField>();
        private final ScrollableTextFieldListener m_listener = new ScrollableTextFieldListener(){

            public void changedValue(ScrollableTextField stf) {
                if (stf.getValue() != Rule.this.m_quantity) {
                    Rule.this.m_quantity = stf.getValue();
                    ProductionPanel.this.calculateLimits();
                    for (ScrollableTextField textField : Rule.this.m_textFields) {
                        if (stf.equals(textField)) continue;
                        textField.setValue(Rule.this.m_quantity);
                    }
                }
            }
        };

        protected JPanel getPanelComponent() {
            JPanel panel = new JPanel();
            ScrollableTextField i_text = new ScrollableTextField(0, Integer.MAX_VALUE);
            i_text.setValue(this.m_quantity);
            panel.setLayout(new GridBagLayout());
            UnitType type = (UnitType)this.m_rule.getResults().keySet().iterator().next();
            ImageIcon icon = ProductionPanel.this.m_uiContext.getUnitImageFactory().getIcon(type, this.m_id, ProductionPanel.this.m_data, false, false);
            UnitAttachment attach = UnitAttachment.get(type);
            int attack = attach.getAttack(this.m_id);
            int movement = attach.getMovement(this.m_id);
            int defense = attach.getDefense(this.m_id);
            int numberOfUnitsGiven = this.m_rule.getResults().totalValues();
            String text = numberOfUnitsGiven > 1 ? "<html> x " + ResourceCollection.toStringForHTML(this.m_cost) + "<br>" + "for " + numberOfUnitsGiven + "<br>" + " units</html>" : "<html> x " + ResourceCollection.toStringForHTML(this.m_cost) + "</html>";
            JLabel label = new JLabel(text, icon, 2);
            JLabel info = new JLabel(attack + "/" + defense + "/" + movement);
            String toolTipText = "<html>" + type.getName() + ": " + type.getTooltip(this.m_id, true) + "</html>";
            info.setToolTipText(toolTipText);
            label.setToolTipText(toolTipText);
            int space = 8;
            JLabel name = new JLabel(type.getName());
            if (attach.getConsumesUnits() != null && attach.getConsumesUnits().totalValues() == 1) {
                name.setForeground(Color.CYAN);
            } else if (attach.getConsumesUnits() != null && attach.getConsumesUnits().totalValues() > 1) {
                name.setForeground(Color.BLUE);
            }
            panel.add((Component)name, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 8, 8, 8), 0, 0));
            panel.add((Component)info, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 8, 8, 8), 0, 0));
            panel.add((Component)i_text, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 8, 8, 8), 0, 0));
            i_text.addChangeListener(this.m_listener);
            this.m_textFields.add(i_text);
            panel.setBorder(new EtchedBorder());
            return panel;
        }

        Rule(ProductionRule rule, PlayerID id) {
            this.m_rule = rule;
            this.m_cost = rule.getCosts();
            this.m_id = id;
        }

        IntegerMap<Resource> getCost() {
            return this.m_cost;
        }

        int getQuantity() {
            return this.m_quantity;
        }

        void setQuantity(int quantity) {
            this.m_quantity = quantity;
            for (ScrollableTextField textField : this.m_textFields) {
                if (textField.getValue() == quantity) continue;
                textField.setValue(quantity);
            }
        }

        ProductionRule getProductionRule() {
            return this.m_rule;
        }

        void setMax(int max) {
            for (ScrollableTextField textField : this.m_textFields) {
                textField.setMax(max);
            }
        }
    }
}

