/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RepairRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.ResourceCollection;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.Properties;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.TechAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.ui.UIContext;
import games.strategy.ui.ScrollableTextField;
import games.strategy.ui.ScrollableTextFieldListener;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductionRepairPanel
extends JPanel {
    private JFrame m_owner;
    private JDialog m_dialog;
    private final UIContext m_uiContext;
    private final List<Rule> m_rules = new ArrayList<Rule>();
    private final JLabel m_left = new JLabel();
    private JButton m_done;
    private PlayerID m_id;
    private boolean m_bid;
    private GameData m_data;
    private static HashMap<Unit, Integer> m_repairCount = new HashMap();
    Action m_done_action = new AbstractAction("Done"){

        public void actionPerformed(ActionEvent e) {
            ProductionRepairPanel.this.m_dialog.setVisible(false);
        }
    };
    private final ScrollableTextFieldListener m_listener = new ScrollableTextFieldListener(){

        public void changedValue(ScrollableTextField stf) {
            ProductionRepairPanel.this.calculateLimits();
        }
    };

    public static HashMap<Unit, IntegerMap<RepairRule>> getProduction(PlayerID id, JFrame parent, GameData data, boolean bid, HashMap<Unit, IntegerMap<RepairRule>> initialPurchase, UIContext context) {
        return new ProductionRepairPanel(context).show(id, parent, data, bid, initialPurchase);
    }

    public HashMap<Unit, IntegerMap<RepairRule>> show(PlayerID id, JFrame parent, GameData data, boolean bid, HashMap<Unit, IntegerMap<RepairRule>> initialPurchase) {
        if (parent != this.m_owner) {
            this.m_dialog = null;
        }
        if (this.m_dialog == null) {
            this.initDialog(parent);
        }
        this.m_bid = bid;
        this.m_data = data;
        this.initRules(id, data, initialPurchase);
        this.initLayout(id);
        this.calculateLimits();
        this.m_dialog.pack();
        this.m_dialog.setLocationRelativeTo(parent);
        this.m_done.requestFocusInWindow();
        this.m_dialog.setVisible(true);
        this.m_dialog.dispose();
        return this.getProduction();
    }

    public List<Rule> getRules() {
        return this.m_rules;
    }

    public static HashMap<Unit, Integer> getUnitRepairs() {
        return m_repairCount;
    }

    private void initDialog(JFrame root) {
        this.m_dialog = new JDialog(root, "Repair", true);
        this.m_dialog.getContentPane().add(this);
        AbstractAction closeAction = new AbstractAction(""){

            public void actionPerformed(ActionEvent e) {
                ProductionRepairPanel.this.m_dialog.setVisible(false);
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        String key = "production.panel.close.prod.popup";
        this.m_dialog.getRootPane().getActionMap().put("production.panel.close.prod.popup", closeAction);
        this.m_dialog.getRootPane().getInputMap(2).put(stroke, "production.panel.close.prod.popup");
    }

    public ProductionRepairPanel(UIContext uiContext) {
        this.m_uiContext = uiContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRules(PlayerID player, GameData data, HashMap<Unit, IntegerMap<RepairRule>> initialPurchase) {
        this.m_data.acquireReadLock();
        try {
            this.m_id = player;
            CompositeMatchAnd<Unit> myPotentiallyDamagedUnits = new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(player), Matches.UnitIsFactoryOrCanBeDamaged);
            CompositeMatchAnd myDamagedUnits = new CompositeMatchAnd(Matches.unitIsOwnedBy(player), Matches.UnitHasSomeUnitDamage());
            List<Territory> terrsWithPotentiallyDamagedUnits = Match.getMatches(data.getMap().getTerritories(), Matches.territoryHasUnitsThatMatch(myPotentiallyDamagedUnits));
            for (RepairRule repairRule : player.getRepairFrontier()) {
                for (Territory terr : terrsWithPotentiallyDamagedUnits) {
                    if (Properties.getSBRAffectsUnitProduction(data)) {
                        int PUProduction;
                        TerritoryAttachment ta = TerritoryAttachment.get(terr);
                        int unitProduction = ta.getUnitProduction();
                        if (unitProduction >= (PUProduction = ta.getProduction())) continue;
                        for (Unit u : Match.getMatches(terr.getUnits().getUnits(), myPotentiallyDamagedUnits)) {
                            if (!repairRule.getResults().keySet().iterator().next().equals(u.getType())) continue;
                            Rule rule = new Rule(repairRule, player, this.m_uiContext, u);
                            int initialQuantity = 0;
                            if (initialPurchase.get(u) != null) {
                                initialQuantity = initialPurchase.get(u).getInt(repairRule);
                            }
                            rule.setQuantity(initialQuantity);
                            rule.setMax(PUProduction - unitProduction);
                            rule.setUnit(u);
                            rule.setName(u.toString());
                            this.m_rules.add(rule);
                        }
                        continue;
                    }
                    for (Unit u : Match.getMatches(terr.getUnits().getUnits(), myDamagedUnits)) {
                        if (!repairRule.getResults().keySet().iterator().next().equals(u.getType())) continue;
                        TripleAUnit taUnit = (TripleAUnit)u;
                        Rule rule = new Rule(repairRule, player, this.m_uiContext, u);
                        int initialQuantity = 0;
                        if (initialPurchase.get(u) != null) {
                            initialQuantity = initialPurchase.get(u).getInt(repairRule);
                        }
                        rule.setQuantity(initialQuantity);
                        rule.setMax(taUnit.getHowMuchCanThisUnitBeRepaired(u, terr));
                        rule.setUnit(u);
                        rule.setName(u.toString());
                        this.m_rules.add(rule);
                    }
                }
            }
        }
        finally {
            this.m_data.releaseReadLock();
        }
    }

    private void initLayout(PlayerID id) {
        Insets nullInsets = new Insets(0, 0, 0, 0);
        this.removeAll();
        this.setLayout(new GridBagLayout());
        JLabel legendLabel = new JLabel("Repair Units");
        this.add((Component)legendLabel, new GridBagConstraints(0, 0, 30, 1, 1.0, 1.0, 13, 2, new Insets(8, 8, 8, 0), 0, 0));
        for (int x = 0; x < this.m_rules.size(); ++x) {
            boolean even = x / 2 * 2 == x;
            this.add((Component)this.m_rules.get(x), new GridBagConstraints(x / 2, even ? 1 : 2, 1, 1, 1.0, 1.0, 13, 2, nullInsets, 0, 0));
        }
        this.add((Component)this.m_left, new GridBagConstraints(0, 3, 30, 1, 1.0, 1.0, 17, 0, new Insets(8, 8, 0, 12), 0, 0));
        this.m_done = new JButton(this.m_done_action);
        this.add((Component)this.m_done, new GridBagConstraints(0, 4, 30, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 8, 0), 0, 0));
    }

    protected void setLeft(ResourceCollection left) {
        ResourceCollection total = this.getResources();
        this.m_left.setText("<html>You have " + left + " left.<br>Out of " + total + "</html>");
    }

    private boolean isIncreasedFactoryProduction(PlayerID player) {
        TechAttachment ta = (TechAttachment)player.getAttachment("techAttatchment");
        if (ta == null) {
            return false;
        }
        return ta.getIncreasedFactoryProduction();
    }

    private HashMap<Unit, IntegerMap<RepairRule>> getProduction() {
        HashMap<Unit, IntegerMap<RepairRule>> prod = new HashMap<Unit, IntegerMap<RepairRule>>();
        for (Rule rule : this.m_rules) {
            int quantity = rule.getQuantity();
            if (quantity == 0) continue;
            IntegerMap<RepairRule> repairRule = new IntegerMap<RepairRule>();
            Unit unit = rule.getUnit();
            repairRule.put(rule.getProductionRule(), quantity);
            prod.put(unit, repairRule);
        }
        return prod;
    }

    protected void calculateLimits() {
        ResourceCollection resources = this.getResources();
        ResourceCollection spent = new ResourceCollection(this.m_data);
        for (Rule current : this.m_rules) {
            spent.add(current.getCost(), current.getQuantity());
        }
        ResourceCollection leftToSpend = resources.difference(spent);
        this.setLeft(leftToSpend);
        for (Rule current : this.m_rules) {
            int max = leftToSpend.fitsHowOften(current.getCost());
            current.setMax(max += current.getQuantity());
        }
    }

    private ResourceCollection getResources() {
        if (this.m_bid) {
            String propertyName = this.m_id.getName() + " bid";
            int bid = this.m_data.getProperties().get(propertyName, 0);
            ResourceCollection bidCollection = new ResourceCollection(this.m_data);
            this.m_data.acquireReadLock();
            bidCollection.addResource(this.m_data.getResourceList().getResource("PUs"), bid);
            this.m_data.releaseReadLock();
            return bidCollection;
        }
        return this.m_id.getResources();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Rule
    extends JPanel {
        private final ScrollableTextField m_text = new ScrollableTextField(0, Integer.MAX_VALUE);
        private final IntegerMap<Resource> m_cost;
        private final RepairRule m_rule;
        private Unit m_unit;

        Rule(RepairRule rule, PlayerID id, UIContext uiContext, Unit repairUnit) {
            UnitType type;
            this.setLayout(new GridBagLayout());
            this.m_rule = rule;
            this.m_cost = rule.getCosts();
            if (ProductionRepairPanel.this.isIncreasedFactoryProduction(id)) {
                this.m_cost.multiplyAllValuesBy(0.5f, 2);
            }
            if (!(type = (UnitType)rule.getResults().keySet().iterator().next()).equals(repairUnit.getType())) {
                throw new IllegalStateException("Rule unit type " + type.getName() + " does not match " + repairUnit.toString() + ".  Please make sure your maps are up to date!");
            }
            TripleAUnit taUnit = (TripleAUnit)repairUnit;
            ImageIcon icon = Properties.getSBRAffectsUnitProduction(ProductionRepairPanel.this.m_data) ? ProductionRepairPanel.this.m_uiContext.getUnitImageFactory().getIcon(type, id, ProductionRepairPanel.this.m_data, true, false) : ProductionRepairPanel.this.m_uiContext.getUnitImageFactory().getIcon(type, id, ProductionRepairPanel.this.m_data, Matches.UnitHasSomeUnitDamage().match(repairUnit), Matches.UnitIsDisabled().match(repairUnit));
            String text = "<html> x " + ResourceCollection.toStringForHTML(this.m_cost) + "</html>";
            JLabel label = new JLabel(text, icon, 2);
            JLabel info = new JLabel(repairUnit.getTerritoryUnitIsIn().getName());
            int toRepair = taUnit.getHowMuchCanThisUnitBeRepaired(repairUnit, repairUnit.getTerritoryUnitIsIn());
            JLabel remaining = new JLabel("Production left to repair: " + toRepair);
            int space = 8;
            this.add((Component)new JLabel(type.getName()), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(2, 0, 0, 0), 0, 0));
            this.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 8, 8, 8), 0, 0));
            this.add((Component)info, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 8, 8, 8), 0, 0));
            this.add((Component)remaining, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 8, 8, 8), 0, 0));
            this.add((Component)this.m_text, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 8, 8, 8), 0, 0));
            this.m_text.addChangeListener(ProductionRepairPanel.this.m_listener);
            this.setBorder(new EtchedBorder());
        }

        IntegerMap<Resource> getCost() {
            return this.m_cost;
        }

        public int getQuantity() {
            return this.m_text.getValue();
        }

        void setQuantity(int quantity) {
            this.m_text.setValue(quantity);
        }

        RepairRule getProductionRule() {
            return this.m_rule;
        }

        void setMax(int max) {
            this.m_text.setMax(max);
        }

        public Unit getUnit() {
            return this.m_unit;
        }

        void setUnit(Unit unit) {
            this.m_unit = unit;
        }
    }
}

