/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.Route;
import java.awt.Image;
import java.awt.Point;

class RouteDescription {
    private final Route m_route;
    private final Point m_start;
    private final Point m_end;
    private final Image m_cursorImage;

    public RouteDescription(Route route, Point start, Point end) {
        this.m_route = route;
        this.m_start = start;
        this.m_end = end;
        this.m_cursorImage = null;
    }

    public RouteDescription(Route route, Point start, Point end, Image cursorImage) {
        this.m_route = route;
        this.m_start = start;
        this.m_end = end;
        this.m_cursorImage = cursorImage;
    }

    public int hashCode() {
        return this.m_route.hashCode() + this.m_cursorImage.hashCode();
    }

    public boolean equals(Object o) {
        int endDiff;
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        RouteDescription other = (RouteDescription)o;
        if (this.m_start == null && other.m_start != null || other.m_start == null && this.m_start != null || this.m_start != other.m_start && !this.m_start.equals(other.m_start)) {
            return false;
        }
        if (this.m_route == null && other.m_route != null || other.m_route == null && this.m_route != null || this.m_route != other.m_route && !this.m_route.equals(other.m_route)) {
            return false;
        }
        if (this.m_end == null && other.m_end != null || other.m_end == null && this.m_end != null) {
            return false;
        }
        if (this.m_cursorImage != other.m_cursorImage) {
            return false;
        }
        if (other.m_end == null && this.m_end != null) {
            return false;
        }
        if (other.m_end != null && this.m_end == null) {
            return false;
        }
        int xDiff = this.m_end.x - other.m_end.x;
        xDiff *= xDiff;
        int yDiff = this.m_end.y - other.m_end.y;
        return (endDiff = (int)Math.sqrt(xDiff + (yDiff *= yDiff))) < 6;
    }

    public Route getRoute() {
        return this.m_route;
    }

    public Point getStart() {
        return this.m_start;
    }

    public Point getEnd() {
        return this.m_end;
    }

    public Image getCursorImage() {
        return this.m_cursorImage;
    }
}

