/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.data.events.GameDataChangeListener;
import games.strategy.engine.stats.AbstractStat;
import games.strategy.engine.stats.IStat;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.PlayerAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TechAdvance;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.triplea.util.PlayerOrderComparator;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatPanel
extends JPanel {
    private final StatTableModel m_dataModel;
    private final TechTableModel m_techModel;
    protected IStat[] m_stats;
    protected GameData m_data;
    private JTable m_statsTable;
    private Image m_statsImage = null;

    public StatPanel(GameData data) {
        this.m_data = data;
        this.m_dataModel = new StatTableModel();
        this.m_techModel = new TechTableModel();
        this.initLayout();
    }

    protected void initLayout() {
        this.setLayout(new GridLayout(2, 1));
        JTable table = this.m_statsTable = new JTable(this.m_dataModel){

            public void print(Graphics g) {
                if (StatPanel.this.m_statsImage != null) {
                    g.drawImage(StatPanel.this.m_statsImage, 0, 0, null, null);
                }
                super.print(g);
            }
        };
        table.getTableHeader().setReorderingAllowed(false);
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(175);
        JScrollPane scroll = new JScrollPane(table);
        this.add(scroll);
        table = new JTable(this.m_techModel);
        table.getTableHeader().setReorderingAllowed(false);
        column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(500);
        scroll = new JScrollPane(table);
        this.add(scroll);
    }

    public void setGameData(GameData data) {
        this.m_data = data;
        this.m_dataModel.setGameData(data);
        this.m_techModel.setGameData(data);
        this.m_dataModel.gameDataChanged(null);
        this.m_techModel.gameDataChanged(null);
    }

    public void setStatsBgImage(Image image) {
        this.m_statsImage = image;
    }

    public JTable getStatsTable() {
        return this.m_statsTable;
    }

    public Collection<String> getAlliances() {
        TreeSet<String> rVal = new TreeSet<String>();
        for (String alliance : this.m_data.getAllianceTracker().getAlliances()) {
            if (this.m_data.getAllianceTracker().getPlayersInAlliance(alliance).size() <= 1) continue;
            rVal.add(alliance);
        }
        return rVal;
    }

    public List<PlayerID> getPlayers() {
        ArrayList<PlayerID> players = new ArrayList<PlayerID>(this.m_data.getPlayerList().getPlayers());
        Collections.sort(players, new PlayerOrderComparator(this.m_data));
        return players;
    }

    class VPStat
    extends AbstractStat {
        VPStat() {
        }

        public String getName() {
            return "VPs";
        }

        public double getValue(PlayerID player, GameData data) {
            PlayerAttachment pa = PlayerAttachment.get(player);
            if (pa != null) {
                return pa.getVps();
            }
            return 0.0;
        }
    }

    class VictoryCityStat
    extends AbstractStat {
        VictoryCityStat() {
        }

        public String getName() {
            return "VC";
        }

        public double getValue(PlayerID player, GameData data) {
            int rVal = 0;
            for (Territory place : data.getMap().getTerritories()) {
                TerritoryAttachment ta;
                if (!place.getOwner().equals(player) || (ta = TerritoryAttachment.get(place)) == null || !ta.getVictoryCity()) continue;
                ++rVal;
            }
            return rVal;
        }
    }

    class TUVStat
    extends AbstractStat {
        TUVStat() {
        }

        public String getName() {
            return "TUV";
        }

        public double getValue(PlayerID player, GameData data) {
            IntegerMap<UnitType> costs = BattleCalculator.getCostsForTUV(player, data);
            Match<Unit> unitIsOwnedBy = Matches.unitIsOwnedBy(player);
            int rVal = 0;
            for (Territory place : data.getMap().getTerritories()) {
                List<Unit> owned = place.getUnits().getMatches(unitIsOwnedBy);
                rVal += BattleCalculator.getTUV(owned, costs);
            }
            return rVal;
        }
    }

    class UnitsStat
    extends AbstractStat {
        UnitsStat() {
        }

        public String getName() {
            return "Units";
        }

        public double getValue(PlayerID player, GameData data) {
            int rVal = 0;
            Match<Unit> ownedBy = Matches.unitIsOwnedBy(player);
            for (Territory place : data.getMap().getTerritories()) {
                rVal += place.getUnits().countMatches(ownedBy);
            }
            return rVal;
        }
    }

    class ResourceStat
    extends AbstractStat {
        final Resource m_resource;

        public ResourceStat(Resource resource) {
            this.m_resource = resource;
        }

        public String getName() {
            return this.m_resource.getName();
        }

        public double getValue(PlayerID player, GameData data) {
            return player.getResources().getQuantity(this.m_resource);
        }
    }

    class PUStat
    extends ResourceStat {
        public PUStat() {
            super(StatPanel.this.m_data.getResourceList().getResource("PUs"));
        }
    }

    class ProductionStat
    extends AbstractStat {
        ProductionStat() {
        }

        public String getName() {
            return "Production";
        }

        public double getValue(PlayerID player, GameData data) {
            int rVal = 0;
            for (Territory place : data.getMap().getTerritories()) {
                TerritoryAttachment ta = TerritoryAttachment.get(place);
                if (!place.getOwner().equals(player) || !Matches.territoryCanCollectIncomeFrom(player, data).match(place)) continue;
                rVal += ta.getProduction();
            }
            return rVal *= Properties.getPU_Multiplier(data).intValue();
        }
    }

    class TechTableModel
    extends AbstractTableModel
    implements GameDataChangeListener {
        private boolean isDirty = true;
        private String[] colList;
        private String[][] data;
        private Map<String, Integer> colMap = null;
        private Map<String, Integer> rowMap = null;

        public TechTableModel() {
            StatPanel.this.m_data.addDataChangeListener(this);
            this.initColList();
            this.colMap = new HashMap<String, Integer>();
            for (int i = 0; i < this.colList.length; ++i) {
                this.colMap.put(this.colList[i], i + 1);
            }
            boolean useTech = false;
            if (StatPanel.this.m_data.getResourceList().getResource("techTokens") != null) {
                useTech = true;
                this.data = new String[TechAdvance.getTechAdvances(StatPanel.this.m_data, null).size() + 1][this.colList.length + 2];
            } else {
                this.data = new String[TechAdvance.getTechAdvances(StatPanel.this.m_data, null).size()][this.colList.length + 1];
            }
            this.rowMap = new HashMap<String, Integer>();
            Iterator<TechAdvance> iter = TechAdvance.getTechAdvances(StatPanel.this.m_data, null).iterator();
            int row = 0;
            if (useTech) {
                this.rowMap.put("Tokens", row);
                this.data[row][0] = "Tokens";
                ++row;
            }
            while (iter.hasNext()) {
                TechAdvance tech = iter.next();
                this.rowMap.put(tech.getName(), row);
                this.data[row][0] = tech.getName();
                ++row;
            }
            this.clearAdvances();
        }

        private void clearAdvances() {
            for (int i = 0; i < this.data.length; ++i) {
                for (int j = 1; j <= this.colList.length; ++j) {
                    this.data[i][j] = "";
                }
            }
        }

        private void initColList() {
            ArrayList<PlayerID> players = new ArrayList<PlayerID>(StatPanel.this.m_data.getPlayerList().getPlayers());
            this.colList = new String[players.size()];
            for (int i = 0; i < players.size(); ++i) {
                this.colList[i] = ((PlayerID)players.get(i)).getName();
            }
            Arrays.sort(this.colList, 0, players.size());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update() {
            this.clearAdvances();
            GameData gameData = StatPanel.this.m_data;
            gameData.acquireReadLock();
            try {
                for (PlayerID pid : gameData.getPlayerList().getPlayers()) {
                    if (this.colMap.get(pid.getName()) == null) {
                        throw new IllegalStateException("Unexpected player in GameData.getPlayerList()" + pid.getName());
                    }
                    int col = this.colMap.get(pid.getName());
                    int row = 0;
                    boolean useTokens = false;
                    if (StatPanel.this.m_data.getResourceList().getResource("techTokens") != null) {
                        useTokens = true;
                        Integer tokens = pid.getResources().getQuantity("techTokens");
                        this.data[row][col] = tokens.toString();
                    }
                    for (TechAdvance advance : TechTracker.getTechAdvances(pid, StatPanel.this.m_data)) {
                        row = this.rowMap.get(advance.getName());
                        this.data[row][col] = "X";
                    }
                    Iterator<TechAdvance> advances = TechAdvance.getTechAdvances(StatPanel.this.m_data, null).iterator();
                    List<TechAdvance> has = TechAdvance.getTechAdvances(StatPanel.this.m_data, pid);
                    while (advances.hasNext()) {
                        TechAdvance advance = advances.next();
                        if (has.contains(advance)) continue;
                        row = this.rowMap.get(advance.getName());
                        this.data[row][col] = "-";
                    }
                }
            }
            finally {
                gameData.releaseReadLock();
            }
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "Technology";
            }
            return this.colList[col - 1].substring(0, 1);
        }

        public Object getValueAt(int row, int col) {
            if (this.isDirty) {
                this.update();
                this.isDirty = false;
            }
            return this.data[row][col];
        }

        public int getColumnCount() {
            return this.colList.length + 1;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public void gameDataChanged(Change aChange) {
            this.isDirty = true;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StatPanel.this.repaint();
                }
            });
        }

        public void setGameData(GameData data) {
            StatPanel.this.m_data.removeDataChangeListener(this);
            StatPanel.this.m_data = data;
            StatPanel.this.m_data.addDataChangeListener(this);
            this.isDirty = true;
        }
    }

    class StatTableModel
    extends AbstractTableModel
    implements GameDataChangeListener {
        private boolean m_isDirty = true;
        private String[][] m_collectedData;

        public StatTableModel() {
            this.setStatCollums();
            StatPanel.this.m_data.addDataChangeListener(this);
            this.m_isDirty = true;
        }

        public void setStatCollums() {
            ArrayList<IStat> stats;
            StatPanel.this.m_stats = new IStat[]{new PUStat(), new ProductionStat(), new UnitsStat(), new TUVStat()};
            if (Match.someMatch(StatPanel.this.m_data.getMap().getTerritories(), Matches.TerritoryIsVictoryCity)) {
                stats = new ArrayList<IStat>(Arrays.asList(StatPanel.this.m_stats));
                stats.add(new VictoryCityStat());
                StatPanel.this.m_stats = stats.toArray(new IStat[stats.size()]);
            }
            if (StatPanel.this.m_data.getProperties().get("Pacific Theater", false)) {
                stats = new ArrayList<IStat>(Arrays.asList(StatPanel.this.m_stats));
                stats.add(new VPStat());
                StatPanel.this.m_stats = stats.toArray(new IStat[stats.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void loadData() {
            StatPanel.this.m_data.acquireReadLock();
            try {
                int i;
                List<PlayerID> players = StatPanel.this.getPlayers();
                Collection<String> alliances = StatPanel.this.getAlliances();
                this.m_collectedData = new String[players.size() + alliances.size()][StatPanel.this.m_stats.length + 1];
                int row = 0;
                for (PlayerID player : players) {
                    this.m_collectedData[row][0] = player.getName();
                    for (i = 0; i < StatPanel.this.m_stats.length; ++i) {
                        this.m_collectedData[row][i + 1] = StatPanel.this.m_stats[i].getFormatter().format(StatPanel.this.m_stats[i].getValue(player, StatPanel.this.m_data));
                    }
                    ++row;
                }
                Iterator<String> allianceIterator = alliances.iterator();
                while (allianceIterator.hasNext()) {
                    String alliance;
                    this.m_collectedData[row][0] = alliance = allianceIterator.next();
                    for (i = 0; i < StatPanel.this.m_stats.length; ++i) {
                        this.m_collectedData[row][i + 1] = StatPanel.this.m_stats[i].getFormatter().format(StatPanel.this.m_stats[i].getValue(alliance, StatPanel.this.m_data));
                    }
                    ++row;
                }
            }
            finally {
                StatPanel.this.m_data.releaseReadLock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void gameDataChanged(Change aChange) {
            StatTableModel statTableModel = this;
            synchronized (statTableModel) {
                this.m_isDirty = true;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StatPanel.this.repaint();
                }
            });
        }

        public synchronized Object getValueAt(int row, int col) {
            if (this.m_isDirty) {
                this.loadData();
                this.m_isDirty = false;
            }
            return this.m_collectedData[row][col];
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "Player";
            }
            return StatPanel.this.m_stats[col - 1].getName();
        }

        public int getColumnCount() {
            return StatPanel.this.m_stats.length + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int getRowCount() {
            if (!this.m_isDirty) {
                return this.m_collectedData.length;
            }
            StatPanel.this.m_data.acquireReadLock();
            try {
                int n = StatPanel.this.m_data.getPlayerList().size() + StatPanel.this.getAlliances().size();
                return n;
            }
            finally {
                StatPanel.this.m_data.releaseReadLock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void setGameData(GameData data) {
            StatTableModel statTableModel = this;
            synchronized (statTableModel) {
                StatPanel.this.m_data.removeDataChangeListener(this);
                StatPanel.this.m_data = data;
                StatPanel.this.m_data.addDataChangeListener(this);
                this.m_isDirty = true;
            }
            StatPanel.this.repaint();
        }
    }
}

