/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.PlayerID;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.ui.ScrollableTextField;
import games.strategy.ui.ScrollableTextFieldListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

class TechRollPanel
extends JPanel {
    int m_PUs;
    PlayerID m_player;
    JLabel m_left = new JLabel();
    ScrollableTextField m_textField;
    private final ScrollableTextFieldListener m_listener = new ScrollableTextFieldListener(){

        public void changedValue(ScrollableTextField stf) {
            TechRollPanel.this.setLabel(TechRollPanel.this.m_PUs - TechTracker.getTechCost(TechRollPanel.this.m_player) * TechRollPanel.this.m_textField.getValue());
        }
    };

    TechRollPanel(int PUs, PlayerID player) {
        this.setLayout(new GridBagLayout());
        this.m_PUs = PUs;
        this.m_player = player;
        JLabel title = new JLabel("Select the number of tech rolls:");
        title.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.m_textField = new ScrollableTextField(0, PUs / TechTracker.getTechCost(player));
        this.m_textField.addChangeListener(this.m_listener);
        JLabel costLabel = new JLabel("x5");
        this.setLabel(PUs);
        boolean space = false;
        this.add((Component)title, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.m_textField, new GridBagConstraints(0, 1, 1, 1, 0.5, 1.0, 13, 0, new Insets(8, 10, 0, 0), 0, 0));
        this.add((Component)costLabel, new GridBagConstraints(1, 1, 1, 1, 0.5, 1.0, 17, 0, new Insets(8, 5, 0, 2), 0, 0));
        this.add((Component)this.m_left, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
    }

    private void setLabel(int PUs) {
        this.m_left.setText("Left to spend:" + PUs);
    }

    public int getValue() {
        return this.m_textField.getValue();
    }
}

