/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.oddsCalculator.ta.OddsCalculatorDialog;
import games.strategy.triplea.ui.DefaultMapSelectionListener;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.TripleAFrame;
import games.strategy.triplea.ui.UIContext;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitSeperator;
import games.strategy.ui.OverlayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerritoryDetailPanel
extends JPanel {
    private GameData m_data;
    private final UIContext m_uiContext;
    private final JButton m_showOdds;
    private Territory m_currentTerritory;
    private final TripleAFrame m_frame;

    public TerritoryDetailPanel(MapPanel mapPanel, GameData data, UIContext uiContext, TripleAFrame frame) {
        this.m_data = data;
        this.m_frame = frame;
        this.m_showOdds = new JButton("Battle Calculator (Ctrl-B)");
        this.m_uiContext = uiContext;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(5, 5, 0, 0));
        mapPanel.addMapSelectionListener(new DefaultMapSelectionListener(){

            public void mouseEntered(Territory territory) {
                TerritoryDetailPanel.this.territoryChanged(territory);
            }
        });
        String show_battle_calc = "show_battle_calc";
        final AbstractAction showBattleCalc = new AbstractAction("show_battle_calc"){

            public void actionPerformed(ActionEvent e) {
                OddsCalculatorDialog.show(TerritoryDetailPanel.this.m_frame, TerritoryDetailPanel.this.m_currentTerritory);
            }
        };
        this.m_showOdds.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                showBattleCalc.actionPerformed(e);
            }
        });
        ((JComponent)this.m_frame.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(66, 4), "show_battle_calc");
        ((JComponent)this.m_frame.getContentPane()).getInputMap(2).put(KeyStroke.getKeyStroke(66, 2), "show_battle_calc");
        ((JComponent)this.m_frame.getContentPane()).getActionMap().put("show_battle_calc", showBattleCalc);
    }

    public void setGameData(GameData data) {
        this.m_data = data;
        this.territoryChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void territoryChanged(Territory territory) {
        Collection<Unit> unitsInTerritory;
        this.m_currentTerritory = territory;
        this.removeAll();
        this.refresh();
        if (territory == null) {
            return;
        }
        this.add(this.m_showOdds);
        TerritoryAttachment ta = TerritoryAttachment.get(territory);
        String labelText = ta == null ? "<html>" + territory.getName() + "<br>Water Territory" + "<br><br></html>" : "<html>" + ta.toStringForInfo(true, true) + "<br></html>";
        this.add(new JLabel(labelText));
        this.add(new JLabel("Units:"));
        this.m_data.acquireReadLock();
        try {
            unitsInTerritory = territory.getUnits().getUnits();
        }
        finally {
            this.m_data.releaseReadLock();
        }
        JScrollPane scroll = new JScrollPane(TerritoryDetailPanel.unitsInTerritoryPanel(unitsInTerritory, this.m_uiContext, this.m_data));
        scroll.setBorder(BorderFactory.createEmptyBorder());
        this.add(scroll);
        this.refresh();
    }

    private static JPanel unitsInTerritoryPanel(Collection<Unit> unitsInTerritory, UIContext uiContext, GameData data) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(2, 20, 2, 2));
        panel.setLayout(new BoxLayout(panel, 1));
        Set<UnitCategory> units = UnitSeperator.categorize(unitsInTerritory);
        Iterator<UnitCategory> iter = units.iterator();
        PlayerID currentPlayer = null;
        while (iter.hasNext()) {
            UnitCategory item = iter.next();
            if (item.getOwner() != currentPlayer) {
                currentPlayer = item.getOwner();
                panel.add(Box.createVerticalStrut(15));
            }
            ImageIcon unitIcon = uiContext.getUnitImageFactory().getIcon(item.getType(), item.getOwner(), data, item.getDamaged(), item.getDisabled());
            ImageIcon flagIcon = new ImageIcon(uiContext.getFlagImageFactory().getSmallFlag(item.getOwner()));
            OverlayIcon flaggedUnitIcon = new OverlayIcon(unitIcon, flagIcon, unitIcon.getIconWidth() - flagIcon.getIconWidth() - 3, 3);
            JLabel label = new JLabel("x" + item.getUnits().size(), flaggedUnitIcon, 2);
            String toolTipText = "<html>" + item.getType().getName() + ": " + item.getType().getTooltip(currentPlayer, true) + "</html>";
            label.setToolTipText(toolTipText);
            panel.add(label);
        }
        return panel;
    }

    private void refresh() {
        this.validate();
        this.repaint();
    }
}

