/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui.history;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.history.HistoryNode;
import games.strategy.engine.history.Renderable;
import games.strategy.engine.history.Round;
import games.strategy.engine.history.Step;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.OriginalOwnerTracker;
import games.strategy.triplea.delegate.dataObjects.MoveDescription;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.util.IntegerMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class HistoryLog
extends JFrame {
    private final JTextArea m_textArea = new JTextArea(50, 50);
    private final StringWriter m_stringWriter;
    private final PrintWriter m_printWriter;

    public HistoryLog() {
        this.m_textArea.setEditable(false);
        JScrollPane scrollingArea = new JScrollPane(this.m_textArea);
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        content.add((Component)scrollingArea, "Center");
        this.m_stringWriter = new StringWriter();
        this.m_printWriter = new PrintWriter(this.m_stringWriter);
        this.setContentPane(content);
        this.setTitle("History Log");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public PrintWriter getWriter() {
        return this.m_printWriter;
    }

    public String toString() {
        return this.m_stringWriter.toString();
    }

    public void clear() {
        this.m_stringWriter.getBuffer().delete(0, this.m_stringWriter.getBuffer().length());
        this.m_textArea.setText("");
    }

    public void printFullTurn(HistoryNode printNode, boolean verbose) {
        Step stepNode = null;
        Step turnStartNode = null;
        PlayerID curPlayer = null;
        for (HistoryNode curNode = printNode; curNode != null; curNode = (HistoryNode)curNode.getPreviousNode()) {
            if (!(curNode instanceof Step)) continue;
            stepNode = (Step)curNode;
            break;
        }
        if (stepNode != null) {
            curPlayer = stepNode.getPlayerID();
            while (stepNode != null) {
                turnStartNode = stepNode;
                if ((stepNode = (Step)stepNode.getPreviousSibling()) != null && stepNode.getPlayerID() != null && stepNode.getPlayerID().getName().equals(curPlayer.getName())) continue;
            }
            this.printRemainingTurn(turnStartNode, verbose, curPlayer.getData().getDiceSides());
        } else {
            System.err.println("No Step node found!");
        }
    }

    public void printRemainingTurn(HistoryNode printNode, boolean verbose, int diceSides) {
        PrintWriter logWriter = this.m_printWriter;
        String moreIndent = "    ";
        DefaultMutableTreeNode curNode = printNode;
        TreePath parentPath = new TreePath(printNode.getPath()).getParentPath();
        PlayerID curPlayer = null;
        if (parentPath != null) {
            Object[] pathToNode;
            for (Object pathNode : pathToNode = parentPath.getPath()) {
                HistoryNode node = (HistoryNode)pathNode;
                for (int i = 0; i < node.getLevel(); ++i) {
                    logWriter.print("    ");
                }
                logWriter.println(node.getTitle());
                if (node.getLevel() == 0) {
                    logWriter.println();
                }
                if (!(node instanceof Step)) continue;
                curPlayer = ((Step)node).getPlayerID();
            }
        }
        ArrayList<String> moveList = new ArrayList<String>();
        boolean moving = false;
        do {
            String conquerStr = "";
            Enumeration<TreeNode> nodeEnum = curNode.preorderEnumeration();
            while (nodeEnum.hasMoreElements()) {
                HistoryNode node = (HistoryNode)nodeEnum.nextElement();
                String title = node.getTitle();
                String indent = "";
                for (int i = 0; i < node.getLevel(); ++i) {
                    indent = indent + "    ";
                }
                if (moving && !(node instanceof Renderable)) {
                    Iterator moveIter = moveList.iterator();
                    while (moveIter.hasNext()) {
                        logWriter.println((String)moveIter.next());
                        moveIter.remove();
                    }
                    moving = false;
                }
                if (node instanceof Renderable) {
                    Object details = ((Renderable)((Object)node)).getRenderingData();
                    if (details instanceof DiceRoll) {
                        if (!verbose) continue;
                        String diceMsg1 = title.substring(0, title.indexOf(58) + 1);
                        if (diceMsg1.equals("")) {
                            logWriter.println(indent + "    " + title);
                            continue;
                        }
                        logWriter.print(indent + "    " + diceMsg1);
                        DiceRoll diceRoll = (DiceRoll)details;
                        int hits = diceRoll.getHits();
                        int rolls = 0;
                        for (int i = 1; i <= diceSides; ++i) {
                            rolls += diceRoll.getRolls(i).size();
                        }
                        logWriter.println("  " + hits + "/" + rolls + " hits");
                        continue;
                    }
                    if (details instanceof MoveDescription) {
                        Pattern p = Pattern.compile("\\w+ undo move (\\d+).");
                        Matcher m = p.matcher(title);
                        if (m.matches()) {
                            moveList.remove(Integer.valueOf(m.group(1)) - 1);
                            continue;
                        }
                        moveList.add(indent + title);
                        moving = true;
                        continue;
                    }
                    if (details instanceof Collection) {
                        Collection objects = (Collection)details;
                        Iterator objIter = objects.iterator();
                        if (objIter.hasNext()) {
                            Object obj = objIter.next();
                            if (obj instanceof Unit) {
                                Unit unit = (Unit)obj;
                                if (title.matches("\\w+ buy .*")) {
                                    logWriter.println(indent + title);
                                    continue;
                                }
                                if (title.matches("\\w+ attack with .*")) {
                                    logWriter.println(indent + title);
                                    continue;
                                }
                                if (title.matches("\\w+ defend with .*")) {
                                    logWriter.println(indent + title);
                                    continue;
                                }
                                if (title.matches("\\d+ \\w+ owned by the .*? lost .*")) {
                                    if (!verbose) continue;
                                    logWriter.println(indent + "    " + title);
                                    continue;
                                }
                                if (title.matches("\\d+ \\w+ owned by the .*? lost")) {
                                    if (!verbose) continue;
                                    logWriter.println(indent + "    " + title);
                                    continue;
                                }
                                if (title.startsWith("Battle casualty summary:")) {
                                    logWriter.println(indent + conquerStr + ". Battle score " + title.substring(title.indexOf("for attacker is")));
                                    conquerStr = "";
                                    IntegerMap<PlayerID> unitCount = new IntegerMap<PlayerID>();
                                    unitCount.add(unit.getOwner(), 1);
                                    while (objIter.hasNext()) {
                                        unit = (Unit)objIter.next();
                                        unitCount.add(unit.getOwner(), 1);
                                    }
                                    for (PlayerID player : unitCount.keySet()) {
                                        logWriter.println(indent + "Casualties for " + player.getName() + ": " + MyFormatter.unitsToTextNoOwner(objects, player));
                                    }
                                    continue;
                                }
                                if (title.matches(".*? placed in .*")) {
                                    logWriter.println(indent + title);
                                    continue;
                                }
                                if (title.matches(".* owned by the \\w+ retreated to .*")) {
                                    logWriter.println(indent + title);
                                    continue;
                                }
                                if (title.matches("\\w+ win")) {
                                    conquerStr = title + conquerStr + " with " + MyFormatter.unitsToTextNoOwner(objects) + " remaining";
                                    continue;
                                }
                                logWriter.println(indent + title);
                                continue;
                            }
                            logWriter.println(indent + title);
                            continue;
                        }
                        if (title.matches("\\w+ win")) {
                            conquerStr = title + conquerStr + " with no units remaining";
                            continue;
                        }
                        logWriter.println(indent + title);
                        continue;
                    }
                    if (details instanceof Territory) {
                        logWriter.println(indent + title);
                        continue;
                    }
                    if (details == null) {
                        if (title.equals("Adding original owners") || title.equals("Cleaning up after movement phases")) continue;
                        if (title.matches("\\w+ collect \\d+ PUs?.*")) {
                            logWriter.println(indent + title);
                            continue;
                        }
                        if (title.matches("\\w+ takes? .*? from \\w+")) {
                            if (moving) {
                                String str = (String)moveList.remove(moveList.size() - 1);
                                moveList.add(str + "\n  " + indent + title.replaceAll(" takes ", " take "));
                                continue;
                            }
                            conquerStr = conquerStr + title.replaceAll("^\\w+ takes ", ", taking ");
                            continue;
                        }
                        if (title.matches("\\w+ spend \\d+ on tech rolls")) {
                            logWriter.println(indent + title);
                            continue;
                        }
                        if (title.startsWith("Rolls to resolve tech hits:")) continue;
                        if (title.matches("\\w+ discover .*")) {
                            logWriter.println(indent + title);
                            continue;
                        }
                        if (title.matches("AA raid costs .*")) {
                            logWriter.println(indent + title);
                            continue;
                        }
                        logWriter.println(indent + title);
                        continue;
                    }
                    logWriter.println(indent + title);
                    continue;
                }
                if (node instanceof Step) {
                    PlayerID playerId = ((Step)node).getPlayerID();
                    if (title.equals("Initializing Delegates")) continue;
                    logWriter.println();
                    logWriter.print(indent + title);
                    if (playerId != null) {
                        curPlayer = playerId;
                        logWriter.print(" - " + playerId.getName());
                    }
                    logWriter.println();
                    continue;
                }
                if (node instanceof Round) {
                    logWriter.println();
                    logWriter.println(indent + title);
                    continue;
                }
                if (title.equals("Game History")) {
                    logWriter.println(indent + title);
                    continue;
                }
                logWriter.println(indent + title);
            }
        } while ((curNode = curNode.getNextSibling()) instanceof Step && ((Step)curNode).getPlayerID().equals(curPlayer));
        logWriter.println();
        this.m_textArea.setText(this.m_stringWriter.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTerritorySummary(GameData data) {
        Collection<Territory> territories;
        PlayerID player;
        PrintWriter logWriter = this.m_printWriter;
        data.acquireReadLock();
        try {
            player = data.getSequence().getStep().getPlayerID();
            territories = data.getMap().getTerritories();
        }
        finally {
            data.releaseReadLock();
        }
        logWriter.println("Territory Summary for " + player.getName() + " : \n");
        for (Territory t : territories) {
            List<Unit> ownedUnits = t.getUnits().getMatches(Matches.unitIsOwnedBy(player));
            TerritoryAttachment ta = TerritoryAttachment.get(t);
            boolean hasFlag = false;
            if (t == null || ta == null) {
                hasFlag = false;
            } else {
                boolean bl = hasFlag = t.getOwner().equals(player) && !ta.getOriginalOwner().equals(player);
            }
            if (!hasFlag && ownedUnits.isEmpty()) continue;
            logWriter.print("    " + t.getName() + " : ");
            if (hasFlag) {
                logWriter.print("1 flag, ");
            }
            if (ownedUnits.isEmpty()) continue;
            logWriter.println(MyFormatter.unitsToTextNoOwner(ownedUnits));
        }
        logWriter.println();
        this.m_textArea.setText(this.m_stringWriter.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printProductionSummary(GameData data) {
        Collection<PlayerID> players;
        PrintWriter logWriter = this.m_printWriter;
        logWriter.println("Production/PUs Summary :\n");
        data.acquireReadLock();
        try {
            players = data.getPlayerList().getPlayers();
        }
        finally {
            data.releaseReadLock();
        }
        for (PlayerID player : players) {
            int PUs = player.getResources().getQuantity("PUs");
            int production = this.getProduction(player, data);
            logWriter.println("    " + player.getName() + " : " + production + " / " + PUs);
        }
        logWriter.println();
        this.m_textArea.setText(this.m_stringWriter.toString());
    }

    private int getProduction(PlayerID player, GameData data) {
        int rVal = 0;
        Iterator<Territory> iter = data.getMap().getTerritories().iterator();
        while (iter.hasNext()) {
            boolean isConvoyOrLand = false;
            Territory place = iter.next();
            OriginalOwnerTracker origOwnerTracker = new OriginalOwnerTracker();
            TerritoryAttachment ta = TerritoryAttachment.get(place);
            if (!place.isWater()) {
                isConvoyOrLand = true;
            } else if (place.isWater() && ta != null && origOwnerTracker.getOriginalOwner(place) != PlayerID.NULL_PLAYERID && origOwnerTracker.getOriginalOwner(place) == player && place.getOwner().equals(player)) {
                isConvoyOrLand = true;
            }
            if (!place.getOwner().equals(player) || !isConvoyOrLand || ta == null) continue;
            rVal += ta.getProduction();
        }
        return rVal;
    }
}

