/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui.screen;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Territory;
import games.strategy.triplea.ui.MapData;
import games.strategy.triplea.ui.screen.LandTerritoryDrawable;
import games.strategy.triplea.ui.screen.TileManager;
import games.strategy.triplea.ui.screen.UnitsDrawer;
import games.strategy.triplea.util.Stopwatch;
import games.strategy.ui.ImageScrollerSmallView;
import games.strategy.ui.Util;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SmallMapImageManager {
    private static final Logger s_logger = Logger.getLogger(SmallMapImageManager.class.getName());
    private final int UNIT_BOX_SIZE = 4;
    private final ImageScrollerSmallView m_view;
    private final Image m_offscreen;
    private final TileManager m_tileManager;

    public SmallMapImageManager(ImageScrollerSmallView view, BufferedImage offscreen, TileManager tileManager) {
        this.m_view = view;
        this.m_offscreen = Util.copyImage(offscreen, false);
        this.m_tileManager = tileManager;
    }

    public void update(GameData data, MapData mapData) {
        Stopwatch stopwatch = new Stopwatch(s_logger, Level.FINEST, "Small map updating took");
        Graphics onScreenGraphics = this.m_view.getOffScreenImage().getGraphics();
        onScreenGraphics.drawImage(this.m_offscreen, 0, 0, null);
        for (UnitsDrawer drawer : new ArrayList<UnitsDrawer>(this.m_tileManager.getUnitDrawables())) {
            int x = (int)((double)drawer.getPlacementPoint().x * this.m_view.getRatioX());
            int y = (int)((double)drawer.getPlacementPoint().y * this.m_view.getRatioY());
            onScreenGraphics.setColor(mapData.getPlayerColor(drawer.getPlayer()).darker());
            onScreenGraphics.fillRect(x, y, 4, 4);
        }
        onScreenGraphics.dispose();
        stopwatch.done();
    }

    public void updateTerritoryOwner(Territory t, GameData data, MapData mapData) {
        if (t.isWater()) {
            return;
        }
        Rectangle bounds = new Rectangle(mapData.getBoundingRect(t.getName()));
        BufferedImage largeImage = Util.createImage(bounds.width, bounds.height, true);
        Graphics g = (Graphics2D)((Image)largeImage).getGraphics();
        ((Graphics2D)g).setComposite(AlphaComposite.getInstance(1, 0.0f));
        g.setColor(new Color(0));
        g.fillRect(0, 0, bounds.width, bounds.height);
        g.dispose();
        g = ((Image)largeImage).getGraphics();
        LandTerritoryDrawable drawable = new LandTerritoryDrawable(t.getName());
        drawable.draw(bounds, data, (Graphics2D)g, mapData, null, null);
        g.dispose();
        int thumbWidth = (int)((double)bounds.width * this.m_view.getRatioX());
        int thumbHeight = (int)((double)bounds.height * this.m_view.getRatioY());
        int thumbsX = (int)((double)bounds.x * this.m_view.getRatioX()) - 1;
        int thumbsY = (int)((double)bounds.y * this.m_view.getRatioY()) - 1;
        BufferedImage thumbImage = Util.createImage(thumbWidth += 3, thumbHeight += 3, true);
        Graphics g2 = ((Image)thumbImage).getGraphics();
        g2.drawImage(largeImage, 0, 0, ((Image)thumbImage).getWidth(null), ((Image)thumbImage).getHeight(null), null);
        g2.dispose();
        g2 = this.m_offscreen.getGraphics();
        g2.drawImage(thumbImage, thumbsX, thumbsY, ((Image)thumbImage).getWidth(null), ((Image)thumbImage).getHeight(null), null);
        g2.dispose();
    }
}

