/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui.screen;

import games.strategy.engine.data.Territory;
import games.strategy.triplea.ui.MapData;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.List;

abstract class TerritoryDrawable {
    TerritoryDrawable() {
    }

    protected final void draw(Rectangle bounds, Graphics2D graphics, MapData mapData, AffineTransform unscaled, AffineTransform scaled, Territory territory, Paint territoryPaint) {
        List<Polygon> polys = mapData.getPolygons(territory);
        Object oldAAValue = graphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (scaled != unscaled) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        for (Polygon polygon : polys) {
            if (!polygon.intersects(bounds) && !polygon.contains(bounds)) continue;
            polygon = new Polygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
            polygon.translate(-bounds.x, -bounds.y);
            graphics.setPaint(territoryPaint);
            graphics.fillPolygon(polygon);
            graphics.setColor(Color.BLACK);
            graphics.drawPolygon(polygon);
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAAValue);
    }
}

