/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui.screen;

import games.strategy.engine.data.GameData;
import games.strategy.thread.LockUtil;
import games.strategy.triplea.ui.MapData;
import games.strategy.triplea.ui.screen.DrawableComparator;
import games.strategy.triplea.ui.screen.IDrawable;
import games.strategy.triplea.util.Stopwatch;
import games.strategy.ui.Util;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tile {
    private static final boolean DRAW_DEBUG = false;
    private static final Logger s_logger = Logger.getLogger(Tile.class.getName());
    private SoftReference<Image> m_imageRef;
    private boolean m_isDirty = true;
    private final Rectangle m_bounds;
    private final int m_x;
    private final int m_y;
    private final double m_scale;
    private final Lock m_lock = new ReentrantLock();
    private final List<IDrawable> m_contents = new ArrayList<IDrawable>();

    public Tile(Rectangle bounds, int x, int y, double scale) {
        this.m_bounds = bounds;
        this.m_x = x;
        this.m_y = y;
        this.m_scale = scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        LockUtil.acquireLock(this.m_lock);
        try {
            boolean bl = this.m_isDirty || this.m_imageRef == null || this.m_imageRef.get() == null;
            return bl;
        }
        finally {
            LockUtil.releaseLock(this.m_lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(GameData data, MapData mapData) {
        LockUtil.acquireLock(this.m_lock);
        try {
            Image image;
            if (this.m_imageRef == null) {
                this.m_imageRef = new SoftReference<BufferedImage>(this.createBlankImage());
                this.m_isDirty = true;
            }
            if ((image = this.m_imageRef.get()) == null) {
                image = this.createBlankImage();
                this.m_imageRef = new SoftReference<Image>(image);
                this.m_isDirty = true;
            }
            if (this.m_isDirty) {
                Graphics2D g = (Graphics2D)image.getGraphics();
                this.draw(g, data, mapData);
                g.dispose();
            }
            Image image2 = image;
            return image2;
        }
        finally {
            LockUtil.releaseLock(this.m_lock);
        }
    }

    private BufferedImage createBlankImage() {
        return Util.createImage((int)(this.m_bounds.getWidth() * this.m_scale), (int)(this.m_bounds.getHeight() * this.m_scale), false);
    }

    public Image getRawImage() {
        if (this.m_imageRef == null) {
            return null;
        }
        return this.m_imageRef.get();
    }

    private void draw(Graphics2D g, GameData data, MapData mapData) {
        AffineTransform scaled;
        AffineTransform unscaled = g.getTransform();
        if (this.m_scale != 1.0) {
            scaled = new AffineTransform();
            scaled.scale(this.m_scale, this.m_scale);
            g.setTransform(scaled);
        } else {
            scaled = unscaled;
        }
        Stopwatch stopWatch = new Stopwatch(s_logger, Level.FINEST, "Drawing Tile at" + this.m_bounds);
        g.setColor(Color.BLACK);
        g.fill(new Rectangle(0, 0, 256, 256));
        Collections.sort(this.m_contents, new DrawableComparator());
        for (IDrawable drawable : this.m_contents) {
            drawable.draw(this.m_bounds, data, g, mapData, unscaled, scaled);
        }
        this.m_isDirty = false;
        stopWatch.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDrawables(Collection<IDrawable> drawables) {
        LockUtil.acquireLock(this.m_lock);
        try {
            this.m_contents.addAll(drawables);
            this.m_isDirty = true;
        }
        finally {
            LockUtil.releaseLock(this.m_lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDrawable(IDrawable d) {
        LockUtil.acquireLock(this.m_lock);
        try {
            this.m_contents.add(d);
            this.m_isDirty = true;
        }
        finally {
            LockUtil.releaseLock(this.m_lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDrawable(IDrawable d) {
        LockUtil.acquireLock(this.m_lock);
        try {
            this.m_contents.remove(d);
            this.m_isDirty = true;
        }
        finally {
            LockUtil.releaseLock(this.m_lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDrawables(Collection<IDrawable> c) {
        LockUtil.acquireLock(this.m_lock);
        try {
            this.m_contents.removeAll(c);
            this.m_isDirty = true;
        }
        finally {
            LockUtil.releaseLock(this.m_lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LockUtil.acquireLock(this.m_lock);
        try {
            this.m_contents.clear();
            this.m_isDirty = true;
        }
        finally {
            LockUtil.releaseLock(this.m_lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IDrawable> getDrawables() {
        LockUtil.acquireLock(this.m_lock);
        try {
            ArrayList<IDrawable> arrayList = new ArrayList<IDrawable>(this.m_contents);
            return arrayList;
        }
        finally {
            LockUtil.releaseLock(this.m_lock);
        }
    }

    public Rectangle getBounds() {
        return this.m_bounds;
    }

    public int getX() {
        return this.m_x;
    }

    public int getY() {
        return this.m_y;
    }

    public Lock getLock() {
        return this.m_lock;
    }
}

