/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.util;

import games.strategy.engine.data.Unit;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitOwner;
import games.strategy.triplea.util.UnitSeperator;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnitAutoChooser {
    private final Collection<Unit> m_allUnits;
    private final Collection<Unit> m_chosenUnits;
    private final Set<Unit> m_candidateUnits;
    private final boolean m_bCategorizeMovement;
    private final boolean m_bCategorizeTrnMovement;
    private final boolean m_bAllowImplicitDependents;
    private final Map<Unit, Collection<Unit>> m_dependentsMap;
    private boolean m_bFoundCompleteSolution = false;
    private final List<Set<Unit>> m_selectedUnitSolutions;
    private int m_exactSolutionCount = 0;
    private final IntegerMap<UnitCategory> m_chosenCategoryCounts;
    private final IntegerMap<UnitCategory> m_candidateCategoryCounts;
    private final LinkedHashSet<List<UnitCategory>> m_candidateCompositeCategories;
    private final LinkedHashSet<UnitCategory> m_candidateCategories;
    private final Set<UnitCategory> m_candidateCategoriesWithoutDependents;
    private final Map<UnitCategory, UnitCategory> m_candidateToChosenCategories;

    public UnitAutoChooser(Collection<Unit> allUnits, Collection<Unit> chosenUnits, Map<Unit, Collection<Unit>> dependentsMap, boolean bAllowImplicitDependents, boolean bCategorizeMovement) {
        this(allUnits, chosenUnits, dependentsMap, bAllowImplicitDependents, bCategorizeMovement, false);
    }

    public UnitAutoChooser(Collection<Unit> allUnits, Collection<Unit> chosenUnits, Map<Unit, Collection<Unit>> dependentsMap, boolean bAllowImplicitDependents, boolean bCategorizeMovement, boolean bCategorizeTrnMovement) {
        this.m_allUnits = allUnits == null ? Collections.emptyList() : allUnits;
        this.m_chosenUnits = chosenUnits == null ? Collections.emptyList() : chosenUnits;
        this.m_bCategorizeMovement = bCategorizeMovement;
        this.m_bCategorizeTrnMovement = bCategorizeTrnMovement;
        this.m_bAllowImplicitDependents = bAllowImplicitDependents;
        this.m_dependentsMap = dependentsMap == null ? Collections.emptyMap() : dependentsMap;
        this.m_candidateUnits = new LinkedHashSet<Unit>(allUnits.size() + 1, 1.0f);
        this.m_selectedUnitSolutions = new ArrayList<Set<Unit>>(allUnits.size());
        Set<UnitCategory> allCategories = UnitSeperator.categorize(this.m_allUnits, this.m_dependentsMap, false, false);
        Set<UnitCategory> chosenCategories = UnitSeperator.categorize(this.m_chosenUnits, null, false, false);
        this.m_chosenCategoryCounts = new IntegerMap(chosenCategories.size() + 1, 1.0f);
        this.m_candidateCategoryCounts = new IntegerMap(allCategories.size() + 1, 1.0f);
        this.m_candidateToChosenCategories = new HashMap<UnitCategory, UnitCategory>(allCategories.size() + 1, 1.0f);
        this.m_candidateCompositeCategories = new LinkedHashSet(allCategories.size() + 1, 1.0f);
        this.m_candidateCategories = new LinkedHashSet(allCategories.size() + 1, 1.0f);
        this.m_candidateCategoriesWithoutDependents = new LinkedHashSet<UnitCategory>(allCategories.size() + 1, 1.0f);
        if (this.m_bCategorizeMovement) {
            Set<UnitCategory> allCategoriesWithMovement = UnitSeperator.categorize(this.m_allUnits, this.m_dependentsMap, true, false);
            this.solveCandidateCompositeCategories(allCategories, allCategoriesWithMovement, chosenCategories);
        } else if (this.m_bCategorizeTrnMovement) {
            Set<UnitCategory> allCategoriesWithMovement = UnitSeperator.categorize(this.m_allUnits, this.m_dependentsMap, false, true, false);
            this.solveCandidateCompositeCategories(allCategories, allCategoriesWithMovement, chosenCategories);
        } else {
            this.solveCandidateCompositeCategories(allCategories, allCategories, chosenCategories);
        }
        this.chooseUnits();
    }

    public List<Unit> getCandidateUnits(boolean selectDependents) {
        ArrayList<Unit> candidateUnits = new ArrayList<Unit>(this.m_allUnits.size());
        for (Unit unit : this.m_candidateUnits) {
            candidateUnits.add(unit);
            if (!selectDependents) continue;
            Collection<Unit> dependents = this.m_dependentsMap.get(unit);
            if (dependents == null) {
                dependents = Collections.emptyList();
            }
            for (Unit dependent : dependents) {
                candidateUnits.add(dependent);
            }
        }
        return candidateUnits;
    }

    public Collection<Unit> getChosenUnits() {
        return this.m_chosenUnits;
    }

    public Iterator<Set<Unit>> solutionIterator() {
        return this.m_selectedUnitSolutions.iterator();
    }

    public int solutionCount() {
        return this.m_selectedUnitSolutions.size();
    }

    public int exactSolutionCount() {
        return this.m_exactSolutionCount;
    }

    public boolean foundCompleteSolution() {
        return this.m_bFoundCompleteSolution;
    }

    public List<Set<Unit>> getAllSolutions(boolean selectImplicitDependents) {
        ArrayList<Set<Unit>> allSolutions = new ArrayList<Set<Unit>>(this.solutionCount());
        for (int i = 0; i < this.solutionCount(); ++i) {
            allSolutions.add(this.getSolution(i, selectImplicitDependents));
        }
        return allSolutions;
    }

    public Set<Unit> getSolution(int solutionIndex) {
        return this.getSolution(solutionIndex, false);
    }

    public Set<Unit> getSolution(int solutionIndex, boolean selectImplicitDependents) {
        LinkedHashSet<Unit> selectedUnits = new LinkedHashSet<Unit>(this.m_allUnits.size() + 1, 1.0f);
        ArrayList<Unit> dependentUnits = new ArrayList<Unit>(this.m_allUnits.size());
        selectedUnits.addAll((Collection)this.m_selectedUnitSolutions.get(solutionIndex));
        for (Unit unit : selectedUnits) {
            Collection<Unit> dependents = this.m_dependentsMap.get(unit);
            if (dependents == null) {
                dependents = Collections.emptyList();
            }
            for (Unit dependent : dependents) {
                dependentUnits.add(dependent);
            }
        }
        if (!selectImplicitDependents) {
            Set<UnitCategory> dependentCategories = UnitSeperator.categorize(dependentUnits, this.m_dependentsMap, false, false);
            IntegerMap<UnitCategory> usedCategoryCounts = new IntegerMap<UnitCategory>(this.m_chosenCategoryCounts.size() + 1, 1.0f);
            for (UnitCategory chosenCategory : this.m_chosenCategoryCounts.keySet()) {
                for (UnitCategory dependentCategory : dependentCategories) {
                    for (int i = 0; i < dependentCategory.getUnits().size(); ++i) {
                        if (!chosenCategory.equals(dependentCategory) || this.m_chosenCategoryCounts.getInt(chosenCategory) - usedCategoryCounts.getInt(chosenCategory) <= 0) continue;
                        usedCategoryCounts.add(chosenCategory, 1);
                        selectedUnits.add(dependentCategory.getUnits().get(i));
                    }
                }
            }
        } else {
            selectedUnits.addAll(dependentUnits);
        }
        return selectedUnits;
    }

    public boolean isMovementCategorized() {
        return this.m_bCategorizeMovement;
    }

    public Match<Collection<Unit>> getChooserBoundaryMatch() {
        Match<Collection<Unit>> unitCategoryCountMatch = new Match<Collection<Unit>>(){

            @Override
            public boolean match(Collection<Unit> units) {
                IntegerMap<UnitCategory> currentMap = new IntegerMap<UnitCategory>(units.size() + 1, 1.0f);
                for (Unit unit : units) {
                    currentMap.add(new UnitCategory(unit, false, false, false, false), 1);
                }
                return UnitAutoChooser.this.m_chosenCategoryCounts.greaterThanOrEqualTo(currentMap);
            }
        };
        return unitCategoryCountMatch;
    }

    private void chooseUnits() {
        for (List list : this.m_candidateCompositeCategories) {
            UnitCategory chosenCategory;
            LinkedHashSet<Unit> compositeCategoryUnits = new LinkedHashSet<Unit>(list.size() + 1, 1.0f);
            IntegerMap<UnitCategory> usedCategoryCounts2 = new IntegerMap<UnitCategory>(this.m_chosenCategoryCounts.size() + 1, 1.0f);
            boolean bUnitsCanAllBeMapped = true;
            block1: for (UnitCategory category : list) {
                chosenCategory = this.m_candidateToChosenCategories.get(category);
                boolean bDoneCategory = false;
                for (Unit unit : category.getUnits()) {
                    if (!compositeCategoryUnits.contains(unit) && !bDoneCategory) {
                        if (this.m_chosenCategoryCounts.getInt(chosenCategory) - usedCategoryCounts2.getInt(chosenCategory) > 0) {
                            usedCategoryCounts2.add(chosenCategory, 1);
                            compositeCategoryUnits.add(unit);
                            Collection<Unit> dependents = this.m_dependentsMap.get(unit);
                            if (dependents == null) {
                                dependents = Collections.emptyList();
                            }
                            for (Unit dependent : dependents) {
                                UnitCategory dependentCategory = new UnitCategory(dependent.getType(), dependent.getOwner());
                                usedCategoryCounts2.add(dependentCategory, 1);
                            }
                            bDoneCategory = true;
                        } else {
                            bUnitsCanAllBeMapped = false;
                            continue block1;
                        }
                    }
                    this.m_candidateUnits.add(unit);
                }
            }
            if (!bUnitsCanAllBeMapped) continue;
            for (UnitCategory category : this.m_candidateCategoriesWithoutDependents) {
                chosenCategory = this.m_candidateToChosenCategories.get(category);
                for (Unit unit : category.getUnits()) {
                    if (compositeCategoryUnits.contains(unit)) continue;
                    this.m_candidateUnits.add(unit);
                    if (this.m_chosenCategoryCounts.getInt(chosenCategory) - usedCategoryCounts2.getInt(chosenCategory) <= 0) continue;
                    usedCategoryCounts2.add(chosenCategory, 1);
                    compositeCategoryUnits.add(unit);
                    Collection<Unit> dependents = this.m_dependentsMap.get(unit);
                    if (dependents == null) {
                        dependents = Collections.emptyList();
                    }
                    for (Unit dependent : dependents) {
                        UnitCategory dependentCategory = new UnitCategory(dependent.getType(), dependent.getOwner());
                        usedCategoryCounts2.add(dependentCategory, 1);
                    }
                }
            }
            this.m_selectedUnitSolutions.add(compositeCategoryUnits);
            if (usedCategoryCounts2.equals(this.m_chosenCategoryCounts)) {
                ++this.m_exactSolutionCount;
                this.m_bFoundCompleteSolution = true;
                continue;
            }
            if (!usedCategoryCounts2.greaterThanOrEqualTo(this.m_chosenCategoryCounts)) continue;
            this.m_bFoundCompleteSolution = true;
        }
        if (this.m_candidateCompositeCategories.isEmpty() && !this.m_candidateCategoriesWithoutDependents.isEmpty()) {
            HashSet<Unit> independentCategoryUnits = new HashSet<Unit>(this.m_chosenUnits.size());
            IntegerMap<UnitCategory> integerMap = new IntegerMap<UnitCategory>(this.m_chosenCategoryCounts.size() + 1, 1.0f);
            for (UnitCategory category : this.m_candidateCategoriesWithoutDependents) {
                UnitCategory chosenCategory = this.m_candidateToChosenCategories.get(category);
                for (Unit unit : category.getUnits()) {
                    this.m_candidateUnits.add(unit);
                    if (this.m_chosenCategoryCounts.getInt(chosenCategory) - integerMap.getInt(chosenCategory) <= 0) continue;
                    integerMap.add(chosenCategory, 1);
                    independentCategoryUnits.add(unit);
                }
            }
            this.m_selectedUnitSolutions.add(independentCategoryUnits);
            if (this.m_chosenCategoryCounts.equals(integerMap)) {
                ++this.m_exactSolutionCount;
                this.m_bFoundCompleteSolution = true;
            }
        } else if (this.m_selectedUnitSolutions.isEmpty()) {
            HashSet<Unit> simpleSolutionUnits = new HashSet<Unit>(this.m_chosenUnits.size());
            IntegerMap<UnitCategory> integerMap = new IntegerMap<UnitCategory>(this.m_chosenCategoryCounts.size() + 1, 1.0f);
            for (UnitCategory category : this.m_candidateCategories) {
                for (Unit unit : category.getUnits()) {
                    this.m_candidateUnits.add(unit);
                    UnitCategory chosenCategory = this.m_candidateToChosenCategories.get(category);
                    int chosenCategoryCount = this.m_chosenCategoryCounts.getInt(chosenCategory);
                    if (chosenCategoryCount - integerMap.getInt(chosenCategory) <= 0) continue;
                    integerMap.add(chosenCategory, 1);
                    simpleSolutionUnits.add(unit);
                }
            }
            this.m_selectedUnitSolutions.add(simpleSolutionUnits);
            if (this.m_chosenCategoryCounts.equals(integerMap)) {
                this.m_bFoundCompleteSolution = true;
            }
        }
    }

    private void solveCandidateCompositeCategories(Collection<UnitCategory> allCategoriesNoMovement, Collection<UnitCategory> allCategories, Collection<UnitCategory> chosenCategories) {
        HashSet<UnitCategory> candidateCategoriesWithDependents = new HashSet<UnitCategory>(allCategories.size() + 1, 1.0f);
        int candidateCategoryCountWithDependents = 0;
        HashSet<UnitCategory> chosenDependentCategories = new HashSet<UnitCategory>(allCategories.size() + 1, 1.0f);
        HashMap<UnitCategory, UnitCategory> allCategoriesToCategoriesWithoutMovement = new HashMap<UnitCategory, UnitCategory>(allCategories.size() + 1, 1.0f);
        block0: for (UnitCategory categoryWithMovement : allCategories) {
            if (this.m_bCategorizeMovement || this.m_bCategorizeTrnMovement && Match.someMatch(categoryWithMovement.getUnits(), Matches.UnitIsTransport)) {
                for (UnitCategory categoryNoMovement : allCategoriesNoMovement) {
                    if (!categoryWithMovement.equalsIgnoreMovement(categoryNoMovement)) continue;
                    allCategoriesToCategoriesWithoutMovement.put(categoryWithMovement, categoryNoMovement);
                    continue block0;
                }
                continue;
            }
            allCategoriesToCategoriesWithoutMovement.put(categoryWithMovement, categoryWithMovement);
        }
        for (UnitCategory chosenCategory : chosenCategories) {
            this.m_chosenCategoryCounts.add(chosenCategory, chosenCategory.getUnits().size());
            for (UnitCategory candidateCategory : allCategories) {
                UnitCategory candidateCategoryNoMovement = (UnitCategory)allCategoriesToCategoriesWithoutMovement.get(candidateCategory);
                if (!chosenCategory.equalsIgnoreDependents(candidateCategoryNoMovement)) continue;
                this.m_candidateCategories.add(candidateCategory);
                this.m_candidateCategoryCounts.add(candidateCategory, candidateCategory.getUnits().size());
                this.m_candidateToChosenCategories.put(candidateCategory, chosenCategory);
                for (int i = 0; i < candidateCategory.getUnits().size(); ++i) {
                    if (!candidateCategory.getDependents().isEmpty()) {
                        boolean bAllDependentsAreCategorized = true;
                        for (UnitOwner unitOwner : candidateCategory.getDependents()) {
                            UnitCategory dependentCategory = new UnitCategory(unitOwner.getType(), unitOwner.getOwner());
                            if (!chosenCategories.contains(dependentCategory)) {
                                bAllDependentsAreCategorized = false;
                                continue;
                            }
                            chosenDependentCategories.add(dependentCategory);
                        }
                        if (bAllDependentsAreCategorized || this.m_bAllowImplicitDependents) {
                            candidateCategoriesWithDependents.add(candidateCategory);
                            ++candidateCategoryCountWithDependents;
                        }
                        if (!this.m_bAllowImplicitDependents) continue;
                        this.m_candidateCategoriesWithoutDependents.add(candidateCategory);
                        continue;
                    }
                    this.m_candidateCategoriesWithoutDependents.add(candidateCategory);
                }
            }
        }
        Iterator<UnitCategory> categoryIter = this.m_candidateCategoriesWithoutDependents.iterator();
        block6: while (categoryIter.hasNext()) {
            UnitCategory candidateCategory = categoryIter.next();
            UnitCategory chosenCategory = this.m_candidateToChosenCategories.get(candidateCategory);
            for (UnitCategory chosenDependentCategory : chosenDependentCategories) {
                if (!chosenCategory.equalsIgnoreMovement(chosenDependentCategory)) continue;
                categoryIter.remove();
                continue block6;
            }
        }
        HashSet<UnitCategory> categoriesToCopy = new HashSet<UnitCategory>(this.m_candidateCategoriesWithoutDependents.size() + 1, 1.0f);
        for (UnitCategory category : candidateCategoriesWithDependents) {
            UnitCategory chosenCategory = this.m_candidateToChosenCategories.get(category);
            for (UnitCategory candidateCategory : this.m_candidateCategoriesWithoutDependents) {
                UnitCategory candidateCategoryNoMovement = (UnitCategory)allCategoriesToCategoriesWithoutMovement.get(candidateCategory);
                if (!chosenCategory.equalsIgnoreDependents(candidateCategoryNoMovement)) continue;
                categoriesToCopy.add(candidateCategory);
            }
        }
        candidateCategoriesWithDependents.addAll(categoriesToCopy);
        IntegerMap<UnitCategory> chosenCategoryCountsNoDependents = new IntegerMap<UnitCategory>(chosenCategories.size() + 1, 1.0f);
        for (UnitCategory candidateCategory : candidateCategoriesWithDependents) {
            UnitCategory chosenCategory = this.m_candidateToChosenCategories.get(candidateCategory);
            if (chosenDependentCategories.contains(chosenCategory)) continue;
            chosenCategoryCountsNoDependents.put(chosenCategory, chosenCategory.getUnits().size());
        }
        ArrayList<UnitCategory> candidateCategoriesWithDependentsList = new ArrayList<UnitCategory>(candidateCategoryCountWithDependents);
        for (UnitCategory category : this.m_candidateCategories) {
            if (!candidateCategoriesWithDependents.contains(category)) continue;
            for (int i = 0; i < this.m_candidateCategoryCounts.getInt(category); ++i) {
                candidateCategoriesWithDependentsList.add(category);
            }
        }
        IntegerMap<UnitCategory> chosenCategoryCountsWithDependents = new IntegerMap<UnitCategory>(this.m_chosenCategoryCounts.size() + 1, 1.0f);
        for (UnitCategory category : candidateCategoriesWithDependents) {
            UnitCategory chosenCategory = this.m_candidateToChosenCategories.get(category);
            chosenCategoryCountsWithDependents.put(chosenCategory, this.m_chosenCategoryCounts.getInt(chosenCategory));
            if (category.getDependents().isEmpty()) continue;
            for (UnitOwner dependent : category.getDependents()) {
                UnitCategory dependentCategory = new UnitCategory(dependent.getType(), dependent.getOwner());
                int dependentCount = this.m_chosenCategoryCounts.getInt(dependentCategory);
                if (dependentCount <= 0) continue;
                chosenCategoryCountsWithDependents.put(dependentCategory, dependentCount);
            }
        }
        ArrayList<UnitCategory> currentCandidateCategories = new ArrayList<UnitCategory>(candidateCategoriesWithDependents.size());
        IntegerMap<UnitCategory> currentCandidateCategoryCounts = new IntegerMap<UnitCategory>(candidateCategoriesWithDependents.size() + 1, 1.0f);
        IntegerMap<UnitCategory> currentChosenCategoryCounts = new IntegerMap<UnitCategory>(candidateCategoriesWithDependents.size() + 1, 1.0f);
        IntegerMap<UnitCategory> currentChosenCategoryCountsWithDependents = new IntegerMap<UnitCategory>(candidateCategoriesWithDependents.size() + 1, 1.0f);
        IntegerMap<UnitCategory> currentChosenCategoryCountsNoDependents = new IntegerMap<UnitCategory>(candidateCategoriesWithDependents.size() + 1, 1.0f);
        LinkedHashSet greedyCandidateCompositeCategories = new LinkedHashSet(candidateCategoriesWithDependents.size() + 1, 1.0f);
        ArrayList bestCandidateSolution = null;
        int bestUnitCount = 0;
        Stack<Integer> indexStack = new Stack<Integer>();
        Integer curIndex = 0;
        while (true) {
            if (curIndex.intValue() == candidateCategoriesWithDependentsList.size()) {
                if (indexStack.empty()) break;
                curIndex = (Integer)indexStack.pop();
            } else {
                indexStack.push(curIndex);
                currentCandidateCategories.clear();
                currentCandidateCategoryCounts.clear();
                currentChosenCategoryCounts.clear();
                currentChosenCategoryCountsWithDependents.clear();
                currentChosenCategoryCountsNoDependents.clear();
                int currentUnitCount = 0;
                for (Integer i : indexStack) {
                    UnitCategory category = (UnitCategory)candidateCategoriesWithDependentsList.get(i);
                    UnitCategory chosenCategory = this.m_candidateToChosenCategories.get(category);
                    currentCandidateCategories.add(category);
                    currentCandidateCategoryCounts.add(category, 1);
                    currentChosenCategoryCountsWithDependents.add(chosenCategory, 1);
                    currentChosenCategoryCounts.add(chosenCategory, 1);
                    if (!chosenDependentCategories.contains(chosenCategory)) {
                        currentChosenCategoryCountsNoDependents.add(chosenCategory, 1);
                    }
                    ++currentUnitCount;
                    if (category.getDependents().isEmpty()) continue;
                    for (UnitOwner unitOwner : category.getDependents()) {
                        UnitCategory dependentCategory = new UnitCategory(unitOwner.getType(), unitOwner.getOwner());
                        currentChosenCategoryCountsWithDependents.add(dependentCategory, 1);
                        if (this.m_chosenCategoryCounts.getInt(dependentCategory) > 0) {
                            currentChosenCategoryCounts.add(dependentCategory, 1);
                        }
                        currentCandidateCategoryCounts.add(dependentCategory, 1);
                        ++currentUnitCount;
                    }
                }
                if (this.m_bAllowImplicitDependents && chosenCategoryCountsNoDependents.equals(currentChosenCategoryCountsNoDependents) && currentChosenCategoryCounts.greaterThanOrEqualTo(chosenCategoryCountsWithDependents) || !this.m_bAllowImplicitDependents && chosenCategoryCountsWithDependents.equals(currentChosenCategoryCounts)) {
                    if (!this.m_bAllowImplicitDependents || chosenCategoryCountsWithDependents.equals(currentChosenCategoryCountsWithDependents)) {
                        ArrayList newCandidateCompositeCategory = new ArrayList(currentCandidateCategories);
                        if (!this.m_candidateCompositeCategories.contains(newCandidateCompositeCategory)) {
                            this.m_candidateCompositeCategories.add(newCandidateCompositeCategory);
                        }
                    } else {
                        greedyCandidateCompositeCategories.add(new ArrayList(currentCandidateCategories));
                    }
                    curIndex = (Integer)indexStack.pop();
                } else if (this.m_bAllowImplicitDependents && !chosenCategoryCountsNoDependents.greaterThanOrEqualTo(currentChosenCategoryCountsNoDependents) && currentChosenCategoryCounts.greaterThanOrEqualTo(chosenCategoryCountsWithDependents) || !this.m_bAllowImplicitDependents && !chosenCategoryCountsWithDependents.greaterThanOrEqualTo(currentChosenCategoryCounts)) {
                    curIndex = (Integer)indexStack.pop();
                } else if (currentUnitCount > bestUnitCount) {
                    bestUnitCount = currentUnitCount;
                    bestCandidateSolution = new ArrayList(currentCandidateCategories);
                }
            }
            curIndex = curIndex + 1;
        }
        this.m_candidateCompositeCategories.addAll(greedyCandidateCompositeCategories);
        if (this.m_candidateCompositeCategories.isEmpty() && bestCandidateSolution != null) {
            this.m_candidateCompositeCategories.add(bestCandidateSolution);
        }
    }
}

