/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.ui;

import games.strategy.util.EventThreadJOptionPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final Component c = new Component(){};

    private Util() {
    }

    public static void runInSwingEventThread(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static <T> T runInSwingEventThread(final Task<T> task) {
        if (SwingUtilities.isEventDispatchThread()) {
            return task.run();
        }
        final AtomicReference results = new AtomicReference();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    results.set(task.run());
                }
            });
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        return (T)results.get();
    }

    public static void ensureImageLoaded(Image anImage) throws InterruptedException {
        MediaTracker tracker = new MediaTracker(c);
        tracker.addImage(anImage, 1);
        tracker.waitForAll();
        tracker.removeImage(anImage);
    }

    public static Image copyImage(BufferedImage img, boolean needAlpha) {
        BufferedImage copy = Util.createImage(img.getWidth(), img.getHeight(), needAlpha);
        Graphics2D g = (Graphics2D)copy.getGraphics();
        g.drawImage((Image)img, 0, 0, null);
        g.dispose();
        return copy;
    }

    public static void notifyError(Component parent, String message) {
        EventThreadJOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(parent), message, "Error", 0);
    }

    public static BufferedImage createImage(int width, int height, boolean needAlpha) {
        if (needAlpha) {
            return new BufferedImage(width, height, 6);
        }
        return new BufferedImage(width, height, 5);
    }

    public static Dimension getDimension(Image anImage, ImageObserver obs) {
        return new Dimension(anImage.getWidth(obs), anImage.getHeight(obs));
    }

    public static void center(Window w) {
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int windowWidth = w.getWidth();
        int windowHeight = w.getHeight();
        if (windowHeight > screenHeight) {
            return;
        }
        if (windowWidth > screenWidth) {
            return;
        }
        int x = (screenWidth - windowWidth) / 2;
        int y = (screenHeight - windowHeight) / 2;
        w.setLocation(x, y);
    }

    public static Image getBanner(String text) {
        int w = 400;
        int h = 60;
        float loginStringX = 20.0f;
        float loginStringY = 45.0f;
        BufferedImage img = new BufferedImage(400, 60, 1);
        Graphics2D g2 = img.createGraphics();
        Font font = new Font("Arial Bold", 0, 36);
        g2.setFont(font);
        Graphics2D originalGraphics = g2;
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setColor(Color.GRAY);
        g2.fillRect(0, 0, 400, 60);
        GeneralPath curveShape = new GeneralPath(1);
        curveShape.moveTo(0.0f, 36.0f);
        curveShape.curveTo(66.799995f, 72.0f, 266.8f, -30.0f, 400.0f, 45.0f);
        curveShape.lineTo(400.0f, 60.0f);
        curveShape.lineTo(0.0f, 60.0f);
        curveShape.lineTo(0.0f, 48.0f);
        curveShape.closePath();
        GradientPaint gp = new GradientPaint(0.0f, 60.0f, Color.GRAY, 0.0f, 0.0f, Color.LIGHT_GRAY);
        g2.setPaint(gp);
        g2.fill(curveShape);
        originalGraphics.setColor(Color.WHITE);
        originalGraphics.drawString(text, 20.0f, 45.0f);
        return img;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Task<T> {
        public T run();
    }
}

