/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.util;

import games.strategy.util.AlwaysMatch;
import games.strategy.util.InverseMatch;
import games.strategy.util.NeverMatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Match<T> {
    public static final Match ALWAYS_MATCH = new AlwaysMatch();
    public static final Match NEVER_MATCH = new NeverMatch();

    public static final <T> List<T> getMatches(Collection<T> collection, Match<T> aMatch) {
        ArrayList<T> matches = new ArrayList<T>();
        for (T current : collection) {
            if (!aMatch.match(current)) continue;
            matches.add(current);
        }
        return matches;
    }

    public static final <T> List<T> getNMatches(Collection<T> collection, int max, Match<T> aMatch) {
        if (max == 0 || collection.isEmpty()) {
            return Collections.emptyList();
        }
        if (max < 0) {
            throw new IllegalArgumentException("max must be positive, instead its:" + max);
        }
        ArrayList<T> matches = new ArrayList<T>(Math.min(max, collection.size()));
        for (T current : collection) {
            if (aMatch.match(current)) {
                matches.add(current);
            }
            if (matches.size() != max) continue;
            return matches;
        }
        return matches;
    }

    public static final <T> boolean allMatch(Collection<T> collection, Match<T> aMatch) {
        if (collection.isEmpty()) {
            return false;
        }
        for (T current : collection) {
            if (aMatch.match(current)) continue;
            return false;
        }
        return true;
    }

    public static final <T> boolean someMatch(Collection<T> collection, Match<T> aMatch) {
        if (collection.isEmpty()) {
            return false;
        }
        for (T current : collection) {
            if (!aMatch.match(current)) continue;
            return true;
        }
        return false;
    }

    public static final <T> boolean noneMatch(Collection<T> collection, Match<T> aMatch) {
        return !Match.someMatch(collection, aMatch);
    }

    public static final <T> int countMatches(Collection<T> collection, Match<T> aMatch) {
        int count = 0;
        for (T current : collection) {
            if (!aMatch.match(current)) continue;
            ++count;
        }
        return count;
    }

    public static <K, V> Set<K> getKeysWhereValueMatch(Map<K, V> aMap, Match<V> valueMatch) {
        HashSet<K> rVal = new HashSet<K>();
        for (K key : aMap.keySet()) {
            V value = aMap.get(key);
            if (!valueMatch.match(value)) continue;
            rVal.add(key);
        }
        return rVal;
    }

    public abstract boolean match(T var1);

    public final Match<T> invert() {
        return new InverseMatch(this);
    }
}

