/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class PropertyUtil {
    private static final Class<?>[] STRING_ARGS = new Class[]{String.class};
    private static final Class<?>[] INT_ARGS = new Class[]{Integer.TYPE};

    public static void set(String propertyName, Object value, Object subject) {
        Method m = PropertyUtil.getSetter(propertyName, subject, value);
        try {
            m.setAccessible(true);
            m.invoke(subject, value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not set property:" + propertyName + " subject:" + subject + " new value:" + value, e);
        }
    }

    public static void set(String propertyName, Object value, Object subject, boolean clearFirst) {
        if (clearFirst) {
            Method c = PropertyUtil.getClearer(propertyName, subject);
            try {
                c.setAccessible(true);
                c.invoke(subject, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not clear property:" + propertyName + " subject:" + subject + " new value:" + value, e);
            }
        }
        PropertyUtil.set(propertyName, value, subject);
    }

    public static void clear(String propertyName, Object subject) {
        try {
            Method c = PropertyUtil.getClearer(propertyName, subject);
            c.setAccessible(true);
            c.invoke(subject, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not clear property:" + propertyName + " subject:" + subject, e);
        }
    }

    public static Field getFieldIncludingFromSuperClasses(Class c, String name, boolean justFromSuper) {
        Field rVal = null;
        if (!justFromSuper) {
            try {
                rVal = c.getDeclaredField(name);
                return rVal;
            }
            catch (NoSuchFieldException e) {
                return PropertyUtil.getFieldIncludingFromSuperClasses(c, name, true);
            }
        }
        if (c.getSuperclass() == null) {
            throw new IllegalStateException("No such Property Field: " + name);
        }
        try {
            rVal = c.getSuperclass().getDeclaredField(name);
            return rVal;
        }
        catch (NoSuchFieldException e) {
            return PropertyUtil.getFieldIncludingFromSuperClasses(c.getSuperclass(), name, true);
        }
    }

    public static Object getPropertyFieldObject(String propertyName, Object subject) {
        Object rVal = null;
        Field field = null;
        try {
            field = PropertyUtil.getFieldIncludingFromSuperClasses(subject.getClass(), "m_" + propertyName, false);
        }
        catch (Exception e) {
            throw new IllegalStateException("No such Property Field: m_" + propertyName + " for Subject: " + subject.toString(), e);
        }
        try {
            field.setAccessible(true);
            rVal = field.get(subject);
        }
        catch (Exception e) {
            throw new IllegalStateException("No such Property Field: m_" + propertyName + " for Subject: " + subject.toString(), e);
        }
        return rVal;
    }

    private static String capitalizeFirstLetter(String aString) {
        char first = aString.charAt(0);
        first = Character.toUpperCase(first);
        return first + aString.substring(1);
    }

    private static Method getSetter(String propertyName, Object subject, Object value) {
        String setterName = "set" + PropertyUtil.capitalizeFirstLetter(propertyName);
        for (Method m : subject.getClass().getMethods()) {
            if (!m.getName().equals(setterName)) continue;
            try {
                Class<?> argType = value.getClass();
                return subject.getClass().getMethod(setterName, argType);
            }
            catch (NoSuchMethodException nsmf) {
                return m;
            }
            catch (NullPointerException n) {
                return m;
            }
        }
        throw new IllegalStateException("No method called:" + setterName + " on:" + subject);
    }

    private static Method getClearer(String propertyName, Object subject) {
        String clearerName = "clear" + PropertyUtil.capitalizeFirstLetter(propertyName);
        for (Method c : subject.getClass().getMethods()) {
            if (!c.getName().equals(clearerName)) continue;
            try {
                return subject.getClass().getMethod(clearerName, new Class[0]);
            }
            catch (NoSuchMethodException nsmf) {
                return c;
            }
            catch (NullPointerException n) {
                return c;
            }
        }
        throw new IllegalStateException("No method called:" + clearerName + " on:" + subject);
    }
}

