/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.text;

import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.jvnet.lafwidget.LafWidgetAdapter;
import org.jvnet.lafwidget.LafWidgetUtilities;

public class SelectOnEscapeWidget
extends LafWidgetAdapter<JTextComponent> {
    protected KeyListener keyListener;

    @Override
    public boolean requiresCustomLafSupport() {
        return false;
    }

    @Override
    public void installUI() {
        super.installUI();
        InputMap currMap = SwingUtilities.getUIInputMap(this.jcomp, 0);
        InputMap newMap = new InputMap();
        if (currMap != null) {
            KeyStroke[] kss = currMap.allKeys();
            for (int i = 0; i < kss.length; ++i) {
                KeyStroke stroke = kss[i];
                Object val = currMap.get(stroke);
                newMap.put(stroke, val);
            }
        }
        newMap.put(KeyStroke.getKeyStroke(27, 0), "flipTextSelection");
        ((JTextComponent)this.jcomp).getActionMap().put("flipTextSelection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LafWidgetUtilities.hasTextFlipSelectOnEscapeProperty((JTextComponent)SelectOnEscapeWidget.this.jcomp)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int selectionLength = ((JTextComponent)SelectOnEscapeWidget.this.jcomp).getSelectionEnd() - ((JTextComponent)SelectOnEscapeWidget.this.jcomp).getSelectionStart();
                            if (selectionLength == 0) {
                                ((JTextComponent)SelectOnEscapeWidget.this.jcomp).selectAll();
                            } else {
                                int lastPos = ((JTextComponent)SelectOnEscapeWidget.this.jcomp).getSelectionEnd();
                                ((JTextComponent)SelectOnEscapeWidget.this.jcomp).setSelectionStart(0);
                                ((JTextComponent)SelectOnEscapeWidget.this.jcomp).setSelectionEnd(0);
                                ((JTextComponent)SelectOnEscapeWidget.this.jcomp).setCaretPosition(lastPos);
                            }
                        }
                    });
                }
            }
        });
        SwingUtilities.replaceUIInputMap(this.jcomp, 0, newMap);
    }

    @Override
    public void installListeners() {
        this.keyListener = new KeyAdapter(){

            @Override
            public void keyTyped(final KeyEvent e) {
                if (LafWidgetUtilities.hasTextFlipSelectOnEscapeProperty((JTextComponent)SelectOnEscapeWidget.this.jcomp) && e.getKeyChar() == '\u001b') {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int selectionLength = ((JTextComponent)SelectOnEscapeWidget.this.jcomp).getSelectionEnd() - ((JTextComponent)SelectOnEscapeWidget.this.jcomp).getSelectionStart();
                            if (selectionLength == 0) {
                                ((JTextComponent)SelectOnEscapeWidget.this.jcomp).selectAll();
                            } else {
                                int lastPos = ((JTextComponent)SelectOnEscapeWidget.this.jcomp).getSelectionEnd();
                                ((JTextComponent)SelectOnEscapeWidget.this.jcomp).setSelectionStart(0);
                                ((JTextComponent)SelectOnEscapeWidget.this.jcomp).setSelectionEnd(0);
                                ((JTextComponent)SelectOnEscapeWidget.this.jcomp).setCaretPosition(lastPos);
                            }
                            ((JTextComponent)SelectOnEscapeWidget.this.jcomp).getParent().dispatchEvent(e);
                        }
                    });
                }
            }
        };
    }

    @Override
    public void uninstallListeners() {
        this.keyListener = null;
        ((JTextComponent)this.jcomp).removeKeyListener(this.keyListener);
    }
}

