/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import games.strategy.engine.framework.GameRunner;
import games.strategy.triplea.ui.MapData;
import games.strategy.util.PointFileReaderWriter;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import util.image.FileSave;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoPlacementFinder {
    private static int PLACEWIDTH = 46;
    private static int PLACEHEIGHT = 46;
    private static MapData s_mapData;
    private static double percent;

    public static void main(String[] args) {
        if (args.length == 1) {
            percent = Double.parseDouble(args[0]);
            PLACEHEIGHT = (int)(percent * (double)PLACEHEIGHT);
            PLACEWIDTH = (int)(percent * (double)PLACEWIDTH);
        }
        AutoPlacementFinder.calculate();
    }

    static void calculate() {
        String mapDir;
        HashMap<String, List<Point>> m_placements;
        block20: {
            m_placements = new HashMap<String, List<Point>>();
            mapDir = AutoPlacementFinder.getMapDirectory();
            if (percent == 0.0) {
                try {
                    File file = new File(GameRunner.getRootFolder() + File.separator + "maps" + File.separator + mapDir + File.separator + "map.properties");
                    if (!file.exists()) break block20;
                    FileReader reader = new FileReader(file);
                    LineNumberReader reader2 = new LineNumberReader(reader);
                    int i = 0;
                    while (true) {
                        reader2.setLineNumber(i);
                        String line = reader2.readLine();
                        if (line == null) break;
                        if (line.contains("units.scale=")) {
                            int result = JOptionPane.showConfirmDialog(new JPanel(), "A map.properties file was found in the map's folder, do you want to use the file to supply the unit's scale?", "File Suggestion", 1);
                            if (result == 2) {
                                return;
                            }
                            if (result == 0) {
                                percent = Double.parseDouble(line.substring(line.indexOf("units.scale=") + 12).trim());
                                PLACEHEIGHT = (int)(percent * (double)PLACEHEIGHT);
                                PLACEWIDTH = (int)(percent * (double)PLACEWIDTH);
                                break;
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (percent == 0.0) {
            try {
                String result = AutoPlacementFinder.getUnitsScale();
                percent = Double.parseDouble(result.toLowerCase());
                PLACEHEIGHT = (int)(percent * (double)PLACEHEIGHT);
                PLACEWIDTH = (int)(percent * (double)PLACEWIDTH);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (mapDir == null) {
            System.out.println("You need to specify a map name for this to work");
            System.out.println("Shutting down");
            System.exit(0);
        }
        try {
            s_mapData = new MapData(mapDir);
        }
        catch (NullPointerException npe) {
            System.out.println("Caught Null Pointer Exception.");
            System.out.println("Could be due to some missing text files");
            npe.printStackTrace();
            System.exit(0);
        }
        Iterator<String> terrIter = s_mapData.getTerritories().iterator();
        System.out.println("Calculating, this may take a while...");
        while (terrIter.hasNext()) {
            List<Point> points;
            String name = terrIter.next();
            if (s_mapData.hasContainedTerritory(name)) {
                HashSet<Polygon> containedPolygons = new HashSet<Polygon>();
                for (String containedName : s_mapData.getContainedTerritory(name)) {
                    containedPolygons.addAll(s_mapData.getPolygons(containedName));
                }
                points = AutoPlacementFinder.getPlacementsStartingAtTopLeft(s_mapData.getPolygons(name), s_mapData.getBoundingRect(name), s_mapData.getCenter(name), containedPolygons);
                m_placements.put(name, points);
            } else {
                points = AutoPlacementFinder.getPlacementsStartingAtMiddle(s_mapData.getPolygons(name), s_mapData.getBoundingRect(name), s_mapData.getCenter(name));
                m_placements.put(name, points);
            }
            System.out.println(name + ": " + points.size());
        }
        try {
            String fileName = new FileSave("Where To Save place.txt ?", "place.txt").getPathString();
            if (fileName == null) {
                System.out.println("You chose not to save, Shutting down");
                System.exit(0);
            }
            PointFileReaderWriter.writeOneToMany(new FileOutputStream(fileName), m_placements);
            System.out.println("Data written to :" + new File(fileName).getCanonicalPath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
        System.exit(0);
    }

    private static String getMapDirectory() {
        String mapDir = JOptionPane.showInputDialog(null, (Object)"Enter the map name (ie. folder name)");
        if (mapDir != null) {
            return mapDir;
        }
        return null;
    }

    private static String getUnitsScale() {
        String unitsScale = JOptionPane.showInputDialog(null, (Object)"Enter the unit's scale (e.g. 0.5625)");
        if (unitsScale != null) {
            return unitsScale;
        }
        return null;
    }

    static List<Point> getPlacementsStartingAtMiddle(Collection<Polygon> countryPolygons, Rectangle bounding, Point center) {
        ArrayList<Rectangle2D> placementRects = new ArrayList<Rectangle2D>();
        ArrayList<Point> placementPoints = new ArrayList<Point>();
        Rectangle2D.Double place = new Rectangle2D.Double(center.x, center.y, PLACEHEIGHT, PLACEWIDTH);
        int x = center.x - PLACEHEIGHT / 2;
        int y = center.y - PLACEWIDTH / 2;
        int step = 1;
        for (int i = 0; i < 2 * Math.max(bounding.width, bounding.height); ++i) {
            int j;
            for (j = 0; j < Math.abs(step); ++j) {
                x = step > 0 ? ++x : --x;
                AutoPlacementFinder.isPlacement(countryPolygons, Collections.<Polygon>emptySet(), placementRects, placementPoints, place, x, y);
            }
            for (j = 0; j < Math.abs(step); ++j) {
                y = step > 0 ? ++y : --y;
                AutoPlacementFinder.isPlacement(countryPolygons, Collections.<Polygon>emptySet(), placementRects, placementPoints, place, x, y);
            }
            if ((step = -step) > 0) {
                ++step;
                continue;
            }
            --step;
        }
        if (placementPoints.isEmpty()) {
            int defaultx = center.x - PLACEHEIGHT / 2;
            int defaulty = center.y - PLACEWIDTH / 2;
            placementPoints.add(new Point(defaultx, defaulty));
        }
        return placementPoints;
    }

    static List<Point> getPlacementsStartingAtTopLeft(Collection<Polygon> countryPolygons, Rectangle bounding, Point center, Collection<Polygon> containedCountryPolygons) {
        ArrayList<Rectangle2D> placementRects = new ArrayList<Rectangle2D>();
        ArrayList<Point> placementPoints = new ArrayList<Point>();
        Rectangle2D.Double place = new Rectangle2D.Double(center.x, center.y, PLACEHEIGHT, PLACEWIDTH);
        for (int x = bounding.x; x < bounding.width + bounding.x; ++x) {
            for (int y = bounding.y; y < bounding.height + bounding.y; ++y) {
                AutoPlacementFinder.isPlacement(countryPolygons, containedCountryPolygons, placementRects, placementPoints, place, x, y);
            }
        }
        if (placementPoints.isEmpty()) {
            int defaultx = center.x - PLACEHEIGHT / 2;
            int defaulty = center.y - PLACEWIDTH / 2;
            placementPoints.add(new Point(defaultx, defaulty));
        }
        return placementPoints;
    }

    private static void isPlacement(Collection<Polygon> countryPolygons, Collection<Polygon> containedCountryPolygons, List<Rectangle2D> placementRects, List<Point> placementPoints, Rectangle2D place, int x, int y) {
        place.setFrame(x, y, PLACEWIDTH, PLACEHEIGHT);
        if (AutoPlacementFinder.containedIn(place, countryPolygons) && !AutoPlacementFinder.intersectsOneOf(place, placementRects) && !AutoPlacementFinder.containedIn(place, containedCountryPolygons) && !AutoPlacementFinder.intersectsOneOf(place, containedCountryPolygons)) {
            placementPoints.add(new Point((int)place.getX(), (int)place.getY()));
            Rectangle2D.Double newRect = new Rectangle2D.Double();
            newRect.setFrame(place);
            placementRects.add(newRect);
        }
    }

    public static boolean containedIn(Rectangle2D r, Collection<Polygon> shapes) {
        for (Polygon item : shapes) {
            if (!item.contains(r)) continue;
            return true;
        }
        return false;
    }

    public static boolean intersectsOneOf(Rectangle2D r, Collection<? extends Shape> shapes) {
        if (shapes.isEmpty()) {
            return false;
        }
        for (Shape shape : shapes) {
            if (!shape.intersects(r)) continue;
            return true;
        }
        return false;
    }
}

