/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import games.strategy.ui.Util;
import games.strategy.util.PointFileReaderWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import util.image.FileOpen;
import util.image.FileSave;

public class CenterPicker
extends JFrame {
    private Image m_image;
    private Map<String, Point> m_centers = new HashMap<String, Point>();
    private Map<String, List<Polygon>> m_polygons = new HashMap<String, List<Polygon>>();
    private final JLabel m_location = new JLabel();

    public static void main(String[] args) {
        System.out.println("Select the map");
        String mapName = new FileOpen("Select The Map").getPathString();
        if (mapName != null) {
            System.out.println("Map : " + mapName);
            CenterPicker picker = new CenterPicker(mapName);
            picker.setSize(600, 550);
            picker.setVisible(true);
        } else {
            System.out.println("No Image Map Selected. Shutting down.");
            System.exit(0);
        }
    }

    public CenterPicker(String mapName) {
        super("Center Picker");
        this.setDefaultCloseOperation(3);
        File file = new File(new File(mapName).getParent() + File.pathSeparator + "polygons.txt");
        if (file.exists() && JOptionPane.showConfirmDialog(new JPanel(), "A polygons.txt file was found in the map's folder, do you want to use the file to supply the territories names?", "File Suggestion", 1) == 0) {
            try {
                System.out.println("Polygons : " + file.getPath());
                this.m_polygons = PointFileReaderWriter.readOneToManyPolygons(new FileInputStream(file.getPath()));
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        } else {
            try {
                System.out.println("Select the Polygons file");
                String polyPath = new FileOpen("Select A Polygon File").getPathString();
                if (polyPath != null) {
                    System.out.println("Polygons : " + polyPath);
                    this.m_polygons = PointFileReaderWriter.readOneToManyPolygons(new FileInputStream(polyPath));
                } else {
                    System.out.println("Polygons file not given. Will run regardless");
                }
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }
        this.createImage(mapName);
        JPanel imagePanel = this.createMainPanel();
        imagePanel.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                CenterPicker.this.m_location.setText("x:" + e.getX() + " y:" + e.getY());
            }
        });
        imagePanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                CenterPicker.this.mouseEvent(e.getPoint(), e.isControlDown(), SwingUtilities.isRightMouseButton(e));
            }
        });
        imagePanel.setMinimumSize(new Dimension(this.m_image.getWidth(this), this.m_image.getHeight(this)));
        imagePanel.setPreferredSize(new Dimension(this.m_image.getWidth(this), this.m_image.getHeight(this)));
        imagePanel.setMaximumSize(new Dimension(this.m_image.getWidth(this), this.m_image.getHeight(this)));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(imagePanel), "Center");
        this.getContentPane().add((Component)this.m_location, "South");
        AbstractAction openAction = new AbstractAction("Load Centers"){

            public void actionPerformed(ActionEvent event) {
                CenterPicker.this.loadCenters();
            }
        };
        openAction.putValue("ShortDescription", "Load An Existing Center Points File");
        AbstractAction saveAction = new AbstractAction("Save Centers"){

            public void actionPerformed(ActionEvent event) {
                CenterPicker.this.saveCenters();
            }
        };
        saveAction.putValue("ShortDescription", "Save The Center Points To File");
        AbstractAction exitAction = new AbstractAction("Exit"){

            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        };
        exitAction.putValue("ShortDescription", "Exit The Program");
        JMenuItem openItem = new JMenuItem(openAction);
        openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        JMenuItem saveItem = new JMenuItem(saveAction);
        saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        JMenuItem exitItem = new JMenuItem(exitAction);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        fileMenu.add(openItem);
        fileMenu.add(saveItem);
        fileMenu.addSeparator();
        fileMenu.add(exitItem);
        menuBar.add(fileMenu);
    }

    private void createImage(String mapName) {
        this.m_image = Toolkit.getDefaultToolkit().createImage(mapName);
        try {
            Util.ensureImageLoaded(this.m_image);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    private JPanel createMainPanel() {
        JPanel imagePanel = new JPanel(){

            public void paint(Graphics g) {
                g.drawImage(CenterPicker.this.m_image, 0, 0, this);
                g.setColor(Color.red);
                for (String centerName : CenterPicker.this.m_centers.keySet()) {
                    Point item = (Point)CenterPicker.this.m_centers.get(centerName);
                    g.fillOval(item.x, item.y, 15, 15);
                    g.drawString(centerName, item.x + 17, item.y + 13);
                }
            }
        };
        return imagePanel;
    }

    private void saveCenters() {
        try {
            String fileName = new FileSave("Where To Save centers.txt ?", "centers.txt").getPathString();
            if (fileName == null) {
                return;
            }
            FileOutputStream out = new FileOutputStream(fileName);
            PointFileReaderWriter.writeOneToOne(out, this.m_centers);
            out.flush();
            out.close();
            System.out.println("Data written to :" + new File(fileName).getCanonicalPath());
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (HeadlessException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadCenters() {
        try {
            System.out.println("Load a center file");
            String centerName = new FileOpen("Load A Center File").getPathString();
            if (centerName == null) {
                return;
            }
            FileInputStream in = new FileInputStream(centerName);
            this.m_centers = PointFileReaderWriter.readOneToOne(in);
            this.repaint();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (HeadlessException ex) {
            ex.printStackTrace();
        }
    }

    private String findTerritoryName(Point p) {
        String seaName = "unknown";
        for (String name : this.m_polygons.keySet()) {
            Collection polygons = this.m_polygons.get(name);
            for (Polygon poly : polygons) {
                if (!poly.contains(p)) continue;
                if (name.endsWith("Sea Zone") || name.startsWith("Sea Zone")) {
                    seaName = name;
                    continue;
                }
                return name;
            }
        }
        return seaName;
    }

    private void mouseEvent(Point point, boolean ctrlDown, boolean rightMouse) {
        if (!rightMouse) {
            String name = this.findTerritoryName(point);
            if ((name = JOptionPane.showInputDialog(this, "Enter the territory name:", name)).trim().length() == 0) {
                return;
            }
            if (this.m_centers.containsKey(name) && JOptionPane.showConfirmDialog(this, "Another center exists with the same name. Are you sure you want to replace it with this one?") != 0) {
                return;
            }
            this.m_centers.put(name, point);
        } else {
            String centerClicked = null;
            for (Map.Entry<String, Point> cur : this.m_centers.entrySet()) {
                if (!new Rectangle(cur.getValue(), new Dimension(15, 15)).intersects(new Rectangle(point, new Dimension(1, 1)))) continue;
                centerClicked = cur.getKey();
            }
            if (centerClicked != null && JOptionPane.showConfirmDialog(this, "Are you sure you want to remove this center?") == 0) {
                this.m_centers.remove(centerClicked);
            }
        }
        this.repaint();
    }
}

