/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import games.strategy.ui.Util;
import games.strategy.util.PointFileReaderWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import util.image.FileOpen;
import util.image.FileSave;

public class PlacementPicker
extends JFrame {
    private Point m_currentSquare;
    private Image m_image;
    private final JLabel m_location = new JLabel();
    private Map<String, List<Polygon>> m_polygons = new HashMap<String, List<Polygon>>();
    private Map<String, List<Point>> m_placements;
    private List<Point> m_currentPlacements;
    private String m_currentCountry;
    private static final int PLACE_SIZE = 48;

    public static void main(String[] args) {
        System.out.println("Select the map");
        String mapName = new FileOpen("Select The Map").getPathString();
        if (mapName != null) {
            PlacementPicker picker = new PlacementPicker(mapName);
            picker.setSize(600, 550);
            picker.setVisible(true);
        } else {
            System.out.println("No Image Map Selected. Shutting down.");
            System.exit(0);
        }
    }

    public PlacementPicker(String mapName) {
        super("Placement Picker");
        this.setDefaultCloseOperation(3);
        File file = new File(new File(mapName).getParent() + File.pathSeparator + "polygons.txt");
        if (file.exists() && JOptionPane.showConfirmDialog(new JPanel(), "A polygons.txt file was found in the map's folder, do you want to use the file to supply the territories?", "File Suggestion", 1) == 0) {
            try {
                System.out.println("Polygons : " + file.getPath());
                this.m_polygons = PointFileReaderWriter.readOneToManyPolygons(new FileInputStream(file.getPath()));
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        } else {
            try {
                System.out.println("Select the Polygons file");
                String polyPath = new FileOpen("Select A Polygon File").getPathString();
                if (polyPath != null) {
                    System.out.println("Polygons : " + polyPath);
                    this.m_polygons = PointFileReaderWriter.readOneToManyPolygons(new FileInputStream(polyPath));
                } else {
                    System.out.println("Polygons file not given. Will run regardless");
                }
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }
        this.createImage(mapName);
        JPanel imagePanel = this.createMainPanel();
        imagePanel.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                PlacementPicker.this.m_location.setText("x:" + e.getX() + " y:" + e.getY());
                PlacementPicker.this.m_currentSquare = new Point(e.getPoint());
                PlacementPicker.this.repaint();
            }
        });
        imagePanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                PlacementPicker.this.mouseEvent(e.getPoint(), e.isControlDown(), SwingUtilities.isRightMouseButton(e));
            }
        });
        imagePanel.setMinimumSize(new Dimension(this.m_image.getWidth(this), this.m_image.getHeight(this)));
        imagePanel.setPreferredSize(new Dimension(this.m_image.getWidth(this), this.m_image.getHeight(this)));
        imagePanel.setMaximumSize(new Dimension(this.m_image.getWidth(this), this.m_image.getHeight(this)));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(imagePanel), "Center");
        this.getContentPane().add((Component)this.m_location, "South");
        AbstractAction openAction = new AbstractAction("Load Placements"){

            public void actionPerformed(ActionEvent event) {
                PlacementPicker.this.loadPlacements();
            }
        };
        openAction.putValue("ShortDescription", "Load An Existing Placement File");
        AbstractAction saveAction = new AbstractAction("Save Placements"){

            public void actionPerformed(ActionEvent event) {
                PlacementPicker.this.savePlacements();
            }
        };
        saveAction.putValue("ShortDescription", "Save The Placements To File");
        AbstractAction exitAction = new AbstractAction("Exit"){

            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        };
        exitAction.putValue("ShortDescription", "Exit The Program");
        JMenuItem openItem = new JMenuItem(openAction);
        openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        JMenuItem saveItem = new JMenuItem(saveAction);
        saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        JMenuItem exitItem = new JMenuItem(exitAction);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        fileMenu.add(openItem);
        fileMenu.add(saveItem);
        fileMenu.addSeparator();
        fileMenu.add(exitItem);
        menuBar.add(fileMenu);
    }

    private void createImage(String mapName) {
        this.m_image = Toolkit.getDefaultToolkit().createImage(mapName);
        try {
            Util.ensureImageLoaded(this.m_image);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    private JPanel createMainPanel() {
        JPanel imagePanel = new JPanel(){

            public void paint(Graphics g) {
                g.drawImage(PlacementPicker.this.m_image, 0, 0, this);
                g.setColor(Color.red);
                if (PlacementPicker.this.m_currentSquare != null) {
                    g.drawRect(((PlacementPicker)PlacementPicker.this).m_currentSquare.x, ((PlacementPicker)PlacementPicker.this).m_currentSquare.y, 48, 48);
                }
                if (PlacementPicker.this.m_currentPlacements == null) {
                    return;
                }
                for (Point item : PlacementPicker.this.m_currentPlacements) {
                    g.fillRect(item.x, item.y, 48, 48);
                }
            }
        };
        return imagePanel;
    }

    private void savePlacements() {
        try {
            String fileName = new FileSave("Where To Save place.txt ?", "place.txt").getPathString();
            if (fileName == null) {
                return;
            }
            FileOutputStream out = new FileOutputStream(fileName);
            PointFileReaderWriter.writeOneToMany(out, this.m_placements);
            out.flush();
            out.close();
            System.out.println("Data written to :" + new File(fileName).getCanonicalPath());
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (HeadlessException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadPlacements() {
        try {
            System.out.println("Load a placement file");
            String placeName = new FileOpen("Load A Placement File").getPathString();
            if (placeName == null) {
                return;
            }
            FileInputStream in = new FileInputStream(placeName);
            this.m_placements = PointFileReaderWriter.readOneToMany(in);
            this.repaint();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (HeadlessException ex) {
            ex.printStackTrace();
        }
    }

    private String findTerritoryName(Point p) {
        String seaName = "there be dragons";
        for (String name : this.m_polygons.keySet()) {
            Collection polygons = this.m_polygons.get(name);
            for (Polygon poly : polygons) {
                if (!poly.contains(p)) continue;
                if (name.endsWith("Sea Zone") || name.startsWith("Sea Zone")) {
                    seaName = name;
                    continue;
                }
                return name;
            }
        }
        return seaName;
    }

    private void mouseEvent(Point point, boolean ctrlDown, boolean rightMouse) {
        if (!rightMouse && !ctrlDown) {
            this.m_currentCountry = this.findTerritoryName(point);
            this.m_currentPlacements = this.m_placements == null || this.m_placements.get(this.m_currentCountry) == null ? new ArrayList<Point>() : new ArrayList<Point>((Collection)this.m_placements.get(this.m_currentCountry));
            JOptionPane.showMessageDialog(this, this.m_currentCountry);
        } else if (!rightMouse && ctrlDown) {
            this.m_currentPlacements.add(point);
        } else if (rightMouse && ctrlDown) {
            if (this.m_placements == null) {
                this.m_placements = new HashMap<String, List<Point>>();
            } else {
                this.m_placements.put(this.m_currentCountry, this.m_currentPlacements);
            }
            this.m_currentPlacements = new ArrayList<Point>();
            System.out.println("done:" + this.m_currentCountry);
        } else if (rightMouse && !this.m_currentPlacements.isEmpty()) {
            this.m_currentPlacements.remove(this.m_currentPlacements.size() - 1);
        }
        this.repaint();
    }
}

