/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import games.strategy.ui.Util;
import games.strategy.util.PointFileReaderWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import util.image.FileOpen;
import util.image.FileSave;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolygonGrabber
extends JFrame {
    private static boolean s_islandMode;
    private final JCheckBoxMenuItem modeItem;
    private List<Polygon> m_current;
    private Image m_image;
    private BufferedImage m_bufferedImage;
    private Map<String, List<Polygon>> m_polygons = new HashMap<String, List<Polygon>>();
    private Map<String, Point> m_centers;
    private final JLabel location = new JLabel();
    private final Point m_testPoint = new Point();

    public static void main(String[] args) {
        System.out.println("Select the map");
        String mapName = new FileOpen("Select The Map").getPathString();
        if (mapName != null) {
            System.out.println("Map : " + mapName);
            PolygonGrabber grabber = new PolygonGrabber(mapName);
            grabber.setSize(600, 550);
            grabber.setVisible(true);
        } else {
            System.out.println("No Image Map Selected. Shutting down.");
            System.exit(0);
        }
    }

    public PolygonGrabber(String mapName) {
        super("Polygon grabber");
        this.setDefaultCloseOperation(3);
        File file = new File(new File(mapName).getParent() + File.pathSeparator + "centers.txt");
        if (file.exists() && JOptionPane.showConfirmDialog(new JPanel(), "A centers.txt file was found in the map's folder, do you want to use the file to supply the territories names?", "File Suggestion", 1) == 0) {
            try {
                System.out.println("Centers : " + file.getPath());
                this.m_polygons = PointFileReaderWriter.readOneToManyPolygons(new FileInputStream(file.getPath()));
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        } else {
            try {
                System.out.println("Select the Centers file");
                String centerPath = new FileOpen("Select A Center File").getPathString();
                if (centerPath != null) {
                    System.out.println("Centers : " + centerPath);
                    this.m_centers = PointFileReaderWriter.readOneToOne(new FileInputStream(centerPath));
                } else {
                    System.out.println("You must specify a centers file.");
                    System.out.println("Shutting down.");
                    System.exit(0);
                }
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
                System.exit(0);
            }
        }
        this.createImage(mapName);
        JPanel imagePanel = this.createMainPanel();
        imagePanel.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                PolygonGrabber.this.location.setText("x:" + e.getX() + " y:" + e.getY());
            }
        });
        imagePanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                PolygonGrabber.this.mouseEvent(e.getPoint(), e.isControlDown(), SwingUtilities.isRightMouseButton(e));
            }
        });
        imagePanel.setMinimumSize(new Dimension(this.m_image.getWidth(this), this.m_image.getHeight(this)));
        imagePanel.setPreferredSize(new Dimension(this.m_image.getWidth(this), this.m_image.getHeight(this)));
        imagePanel.setMaximumSize(new Dimension(this.m_image.getWidth(this), this.m_image.getHeight(this)));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(imagePanel), "Center");
        this.getContentPane().add((Component)this.location, "South");
        AbstractAction openAction = new AbstractAction("Load Polygons"){

            public void actionPerformed(ActionEvent event) {
                PolygonGrabber.this.loadPolygons();
            }
        };
        openAction.putValue("ShortDescription", "Load An Existing Polygon Points FIle");
        AbstractAction saveAction = new AbstractAction("Save Polygons"){

            public void actionPerformed(ActionEvent event) {
                PolygonGrabber.this.savePolygons();
            }
        };
        saveAction.putValue("ShortDescription", "Save The Polygon Points To File");
        AbstractAction exitAction = new AbstractAction("Exit"){

            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        };
        exitAction.putValue("ShortDescription", "Exit The Program");
        JMenuItem openItem = new JMenuItem(openAction);
        openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        JMenuItem saveItem = new JMenuItem(saveAction);
        saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        JMenuItem exitItem = new JMenuItem(exitAction);
        s_islandMode = false;
        this.modeItem = new JCheckBoxMenuItem("Island Mode", false);
        this.modeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                s_islandMode = PolygonGrabber.this.modeItem.getState();
                PolygonGrabber.this.repaint();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        fileMenu.add(openItem);
        fileMenu.add(saveItem);
        fileMenu.addSeparator();
        fileMenu.add(exitItem);
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        editMenu.add(this.modeItem);
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
    }

    private void createImage(String mapName) {
        this.m_image = Toolkit.getDefaultToolkit().createImage(mapName);
        try {
            Util.ensureImageLoaded(this.m_image);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.m_bufferedImage = new BufferedImage(this.m_image.getWidth(null), this.m_image.getHeight(null), 2);
        Graphics g = this.m_bufferedImage.getGraphics();
        g.drawImage(this.m_image, 0, 0, this);
        g.dispose();
    }

    private JPanel createMainPanel() {
        JPanel imagePanel = new JPanel(){

            public void paint(Graphics g) {
                g.drawImage(PolygonGrabber.this.m_image, 0, 0, this);
                Iterator iter = PolygonGrabber.this.m_polygons.entrySet().iterator();
                g.setColor(Color.red);
                while (iter.hasNext()) {
                    Polygon item;
                    Collection polygons = (Collection)iter.next().getValue();
                    Iterator iter2 = polygons.iterator();
                    if (s_islandMode) {
                        while (iter2.hasNext()) {
                            item = (Polygon)iter2.next();
                            g.drawPolygon(item.xpoints, item.ypoints, item.npoints);
                        }
                        continue;
                    }
                    while (iter2.hasNext()) {
                        item = (Polygon)iter2.next();
                        g.setColor(Color.yellow);
                        g.fillPolygon(item.xpoints, item.ypoints, item.npoints);
                        g.setColor(Color.black);
                        g.drawPolygon(item.xpoints, item.ypoints, item.npoints);
                    }
                }
                g.setColor(Color.red);
                if (PolygonGrabber.this.m_current != null) {
                    for (Polygon item : PolygonGrabber.this.m_current) {
                        g.fillPolygon(item.xpoints, item.ypoints, item.npoints);
                    }
                }
            }
        };
        return imagePanel;
    }

    private void savePolygons() {
        try {
            String polyName = new FileSave("Where To Save Polygons.txt ?", "polygons.txt").getPathString();
            if (polyName == null) {
                return;
            }
            FileOutputStream out = new FileOutputStream(polyName);
            PointFileReaderWriter.writeOneToManyPolygons(out, this.m_polygons);
            out.flush();
            out.close();
            System.out.println("Data written to :" + new File(polyName).getCanonicalPath());
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (HeadlessException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadPolygons() {
        try {
            System.out.println("Load a polygon file");
            String polyName = new FileOpen("Load A Polygon File").getPathString();
            if (polyName == null) {
                return;
            }
            FileInputStream in = new FileInputStream(polyName);
            this.m_polygons = PointFileReaderWriter.readOneToManyPolygons(in);
            this.repaint();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (HeadlessException ex) {
            ex.printStackTrace();
        }
    }

    private void mouseEvent(Point point, boolean ctrlDown, boolean rightMouse) {
        Polygon p = this.findPolygon(point.x, point.y);
        if (p == null) {
            return;
        }
        if (rightMouse && this.m_current != null) {
            this.doneCurrentGroup();
        } else {
            if (this.pointInCurrentPolygon(point)) {
                System.out.println("rejecting");
                return;
            }
            if (ctrlDown) {
                if (this.m_current == null) {
                    this.m_current = new ArrayList<Polygon>();
                }
                this.m_current.add(p);
            } else {
                this.m_current = new ArrayList<Polygon>();
                this.m_current.add(p);
            }
        }
        this.repaint();
    }

    private boolean pointInCurrentPolygon(Point p) {
        if (this.m_current == null) {
            return false;
        }
        for (Polygon item : this.m_current) {
            if (!item.contains(p)) continue;
            return true;
        }
        return false;
    }

    private void doneCurrentGroup() throws HeadlessException {
        JTextField text = new JTextField();
        Iterator<Map.Entry<String, Point>> centersiter = this.m_centers.entrySet().iterator();
        this.guessCountryName(text, centersiter);
        int option = JOptionPane.showConfirmDialog(this, text);
        if (option == 0) {
            if (!this.m_centers.keySet().contains(text.getText())) {
                JOptionPane.showMessageDialog(this, "not a valid name");
                this.m_current = null;
                return;
            }
            this.m_polygons.put(text.getText(), this.m_current);
            this.m_current = null;
        } else if (option > 0) {
            this.m_current = null;
        } else {
            System.out.println("something very invalid");
        }
    }

    private void guessCountryName(JTextField text, Iterator<Map.Entry<String, Point>> centersiter) {
        block0: while (centersiter.hasNext()) {
            Map.Entry<String, Point> item = centersiter.next();
            Point p = new Point(item.getValue());
            for (Polygon polygon : this.m_current) {
                if (!polygon.contains(p)) continue;
                text.setText(item.getKey().toString());
                continue block0;
            }
        }
    }

    private final boolean isBlack(Point p) {
        return this.isBlack(p.x, p.y);
    }

    private final boolean isBlack(int x, int y) {
        if (!this.inBounds(x, y)) {
            return false;
        }
        return (this.m_bufferedImage.getRGB(x, y) & 0xFFFFFF) == 0;
    }

    private final boolean inBounds(int x, int y) {
        return x >= 0 && x < this.m_image.getWidth(null) && y >= 0 && y < this.m_image.getHeight(null);
    }

    private final void move(Point p, int direction) {
        if (direction < 0 || direction > 7) {
            throw new IllegalArgumentException("Not a direction :" + direction);
        }
        if (direction == 1 || direction == 2 || direction == 3) {
            ++p.x;
        } else if (direction == 5 || direction == 6 || direction == 7) {
            --p.x;
        }
        if (direction == 5 || direction == 4 || direction == 3) {
            ++p.y;
        } else if (direction == 7 || direction == 0 || direction == 1) {
            --p.y;
        }
    }

    private boolean isOnEdge(int direction, Point currentPoint) {
        this.m_testPoint.setLocation(currentPoint);
        this.move(this.m_testPoint, direction);
        return this.m_testPoint.x == 0 || this.m_testPoint.y == 0 || this.m_testPoint.y == this.m_image.getHeight(this) || this.m_testPoint.x == this.m_image.getWidth(this) || this.isBlack(this.m_testPoint);
    }

    private final Polygon findPolygon(int x, int y) {
        Point startPoint = new Point(x, y);
        while (this.inBounds(startPoint.x, startPoint.y - 1) && !this.isBlack(startPoint.x, startPoint.y)) {
            --startPoint.y;
        }
        ArrayList<Point> points = new ArrayList<Point>(100);
        points.add(new Point(startPoint));
        int currentDirection = 2;
        Point currentPoint = new Point(startPoint);
        int iterCount = 0;
        block1: while (!currentPoint.equals(startPoint) || points.size() == 1) {
            if (++iterCount > 100000) {
                JOptionPane.showMessageDialog(this, "Failed to grab the polygon. Failed at point: " + currentPoint.getX() + "," + currentPoint.getY() + "\r\n" + "Note that this is a common error and can usually be fixed by 'smoothing out' the territory border.");
                return null;
            }
            for (int i = 2; i >= -3; --i) {
                int tempDirection = (currentDirection + i) % 8;
                if (tempDirection < 0) {
                    tempDirection += 8;
                }
                if (!this.isOnEdge(tempDirection, currentPoint)) continue;
                if (i != 0) {
                    points.add(currentPoint);
                    currentPoint = new Point(currentPoint);
                    this.move(currentPoint, tempDirection);
                    currentDirection = tempDirection;
                    continue block1;
                }
                this.move(currentPoint, currentDirection);
                continue block1;
            }
        }
        int[] xpoints = new int[points.size()];
        int[] ypoints = new int[points.size()];
        int i = 0;
        for (Point item : points) {
            xpoints[i] = item.x;
            ypoints[i] = item.y;
            ++i;
        }
        System.out.println("Done finding polygon. total points;" + xpoints.length);
        return new Polygon(xpoints, ypoints, xpoints.length);
    }
}

