/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import games.strategy.triplea.ui.MapData;
import games.strategy.ui.ImageIoCompletionWatcher;
import games.strategy.ui.Util;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import util.image.FileOpen;
import util.image.FileSave;

public class ReliefImageBreaker {
    private static final String SMALL_MAPS_LOCATION = new FileSave("Where to save Reliefe Images?", null).getPathString();
    private static JFrame observer = new JFrame();
    private boolean m_seaZoneOnly;
    private MapData m_mapData;

    public static void main(String[] args) throws Exception {
        new ReliefImageBreaker().createMaps();
    }

    public void createMaps() throws IOException {
        Image map = ReliefImageBreaker.loadImage();
        if (map == null) {
            System.out.println("You need to select a map image for this to work");
            System.out.println("Shutting down");
            System.exit(0);
        }
        this.m_seaZoneOnly = ReliefImageBreaker.doSeaZone();
        String mapDir = ReliefImageBreaker.getMapDirectory();
        if (mapDir == null || mapDir.equals("")) {
            System.out.println("You need to specify a map name for this to work");
            System.out.println("Shutting down");
            System.exit(0);
        }
        try {
            this.m_mapData = new MapData(mapDir);
        }
        catch (NullPointerException npe) {
            System.out.println("Bad data given or missing text files, shutting down");
            System.exit(0);
        }
        for (String territoryName : this.m_mapData.getTerritories()) {
            boolean seaZone;
            boolean bl = seaZone = territoryName.endsWith("Sea Zone") || territoryName.startsWith("Sea Zone");
            if (!seaZone && this.m_seaZoneOnly || seaZone && !this.m_seaZoneOnly) continue;
            this.processImage(territoryName, map);
        }
        System.out.println("All Finished!");
        System.exit(0);
    }

    private static boolean doSeaZone() {
        String ans = "";
        while (true) {
            if ((ans = JOptionPane.showInputDialog(null, (Object)"Only Do Sea Zones? Enter [Y/N]")) == null) {
                System.out.println("Cannot leave this blank!");
                System.out.println("Retry");
                continue;
            }
            if (ans.equalsIgnoreCase("Y")) {
                return true;
            }
            if (ans.equalsIgnoreCase("N")) {
                return false;
            }
            System.out.println("You must enter Y or N");
        }
    }

    private static String getMapDirectory() {
        String mapDir = JOptionPane.showInputDialog(null, (Object)"Enter the name of the map (ie. revised)");
        if (mapDir != null) {
            return mapDir;
        }
        return null;
    }

    private static Image loadImage() {
        System.out.println("Select the map");
        String mapName = new FileOpen("Select The Map").getPathString();
        if (mapName != null) {
            Image img = Toolkit.getDefaultToolkit().createImage(mapName);
            MediaTracker tracker = new MediaTracker(new Panel());
            tracker.addImage(img, 1);
            try {
                tracker.waitForAll();
                return img;
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                return ReliefImageBreaker.loadImage();
            }
        }
        return null;
    }

    private void processImage(String territory, Image map) throws IOException {
        Rectangle bounds = this.m_mapData.getBoundingRect(territory);
        int width = bounds.width;
        int height = bounds.height;
        BufferedImage alphaChannelImage = Util.createImage(bounds.width, bounds.height, true);
        for (Polygon item : this.m_mapData.getPolygons(territory)) {
            item = new Polygon(item.xpoints, item.ypoints, item.npoints);
            item.translate(-bounds.x, -bounds.y);
            alphaChannelImage.getGraphics().fillPolygon(item);
        }
        GraphicsConfiguration m_localGraphicSystem = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage relief = m_localGraphicSystem.createCompatibleImage(width, height, this.m_seaZoneOnly ? 2 : 3);
        relief.getGraphics().drawImage(map, 0, 0, width, height, bounds.x, bounds.y, bounds.x + width, bounds.y + height, observer);
        this.blankOutline(alphaChannelImage, relief);
        String outFileName = SMALL_MAPS_LOCATION + "/" + territory;
        outFileName = !this.m_seaZoneOnly ? outFileName + "_relief.png" : outFileName + ".png";
        outFileName = outFileName.replace(' ', '_');
        ImageIO.write((RenderedImage)relief, "png", new File(outFileName));
        System.out.println("wrote " + outFileName);
    }

    private void blankOutline(Image alphaChannelImage, BufferedImage relief) {
        Graphics2D gc = (Graphics2D)relief.getGraphics();
        Composite prevComposite = gc.getComposite();
        gc.setComposite(AlphaComposite.getInstance(6));
        ImageIoCompletionWatcher watcher = new ImageIoCompletionWatcher();
        boolean drawComplete = gc.drawImage(alphaChannelImage, 0, 0, watcher);
        if (!drawComplete) {
            watcher.waitForCompletion();
        }
        gc.setComposite(prevComposite);
    }
}

