/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.slidingtiles;

import games.puzzle.slidingtiles.player.BetterAI;
import games.puzzle.slidingtiles.player.RandomAI;
import games.puzzle.slidingtiles.ui.NPuzzleMapData;
import games.puzzle.slidingtiles.ui.NPuzzleMapPanel;
import games.puzzle.slidingtiles.ui.NPuzzleMenu;
import games.strategy.engine.framework.IGameLoader;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.grid.GridGame;
import games.strategy.grid.player.GridAbstractAI;
import games.strategy.grid.player.GridGamePlayer;
import games.strategy.grid.ui.GridGameFrame;
import games.strategy.grid.ui.GridGameMenu;
import games.strategy.grid.ui.GridMapData;
import games.strategy.grid.ui.GridMapPanel;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NPuzzle
extends GridGame
implements IGameLoader {
    private static final long serialVersionUID = 6359686118939451301L;
    private static final String HUMAN_PLAYER_TYPE = "Human";
    private static final String RANDOM_COMPUTER_PLAYER_TYPE = "Random AI";
    private static final String DFS_COMPUTER_PLAYER_TYPE = "Depth First Search AI";

    @Override
    public Set<IGamePlayer> createPlayers(Map<String, String> playerNames) {
        HashSet<IGamePlayer> players = new HashSet<IGamePlayer>();
        for (String name : playerNames.keySet()) {
            GridAbstractAI ai;
            String type = playerNames.get(name);
            if (type.equals(HUMAN_PLAYER_TYPE) || type.equals("Client")) {
                GridGamePlayer player = new GridGamePlayer(name, type);
                players.add(player);
                continue;
            }
            if (type.equals(RANDOM_COMPUTER_PLAYER_TYPE)) {
                ai = new RandomAI(name, type);
                players.add(ai);
                continue;
            }
            if (type.equals(DFS_COMPUTER_PLAYER_TYPE)) {
                ai = new BetterAI(name, type, BetterAI.Algorithm.DFS, BetterAI.Heuristic.NUMBER_OF_MISPLACED_TILES);
                players.add(ai);
                continue;
            }
            throw new IllegalStateException("Player type not recognized:" + type);
        }
        return players;
    }

    @Override
    protected void initializeGame() {
        NPuzzleMapPanel panel = (NPuzzleMapPanel)this.m_display.getGridGameFrame().getMainPanel();
        panel.setBackgroundImage((File)this.m_game.getData().getProperties().get("Background"));
    }

    @Override
    protected Class<? extends GridMapPanel> getGridMapPanelClass() {
        return NPuzzleMapPanel.class;
    }

    @Override
    protected Class<? extends GridMapData> getGridMapDataClass() {
        return NPuzzleMapData.class;
    }

    @Override
    protected Class<? extends GridGameMenu<GridGameFrame>> getGridTableMenuClass() {
        return NPuzzleMenu.class;
    }

    @Override
    public String[] getServerPlayerTypes() {
        return new String[]{HUMAN_PLAYER_TYPE, DFS_COMPUTER_PLAYER_TYPE, RANDOM_COMPUTER_PLAYER_TYPE};
    }

    @Override
    public int getSquareWidth() {
        return 100;
    }

    @Override
    public int getSquareHeight() {
        return 100;
    }

    @Override
    public int getBevelSize() {
        return 25;
    }
}

