/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.slidingtiles.delegate;

import games.puzzle.slidingtiles.attachments.Tile;
import games.puzzle.slidingtiles.delegate.SlidingTilesEndTurnExtendedDelegateState;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.Territory;
import games.strategy.grid.delegate.AbstractPlayByEmailOrForumDelegate;
import games.strategy.grid.ui.display.IGridGameDisplay;
import java.io.Serializable;

public class EndTurnDelegate
extends AbstractPlayByEmailOrForumDelegate {
    public void start() {
        super.start();
        if (this.gameOver(this.getData().getMap())) {
            this.signalGameOver("Board solved!");
        }
    }

    public void end() {
        super.end();
    }

    public Serializable saveState() {
        SlidingTilesEndTurnExtendedDelegateState state = new SlidingTilesEndTurnExtendedDelegateState();
        state.superState = super.saveState();
        return state;
    }

    public void loadState(Serializable state) {
        SlidingTilesEndTurnExtendedDelegateState s = (SlidingTilesEndTurnExtendedDelegateState)state;
        super.loadState(s.superState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean gameOver(GameMap map) {
        int width = map.getXDimension();
        int height = map.getYDimension();
        int previous = -2147483647;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                Territory t;
                if ((t = map.getTerritoryFromCoordinates(x++, y)) == null) return false;
                Tile tile = (Tile)t.getAttachment("tile");
                if (tile == null) return false;
                int current = tile.getValue();
                if (current <= previous) {
                    return false;
                }
                previous = current;
            }
        }
        return true;
    }

    private void signalGameOver(String status) {
        this.m_bridge.getHistoryWriter().startEvent(status);
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.setStatus(status);
        display.setGameOver();
        this.m_bridge.stopGameSequence();
    }
}

