/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.slidingtiles.delegate;

import games.puzzle.slidingtiles.attachments.Tile;
import games.puzzle.slidingtiles.delegate.SlidingTilesPlayExtendedDelegateState;
import games.strategy.common.delegate.AbstractDelegate;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.message.IRemote;
import games.strategy.grid.delegate.remote.IGridPlayDelegate;
import games.strategy.grid.ui.IGridPlayData;
import games.strategy.grid.ui.display.IGridGameDisplay;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayDelegate
extends AbstractDelegate
implements IGridPlayDelegate {
    private GameMap map;

    @Override
    public void start() {
        super.start();
        this.map = this.getData().getMap();
    }

    @Override
    public void end() {
        super.end();
    }

    @Override
    public Serializable saveState() {
        SlidingTilesPlayExtendedDelegateState state = new SlidingTilesPlayExtendedDelegateState();
        state.superState = super.saveState();
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        SlidingTilesPlayExtendedDelegateState s = (SlidingTilesPlayExtendedDelegateState)state;
        super.loadState(s.superState);
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        return true;
    }

    @Override
    public String play(IGridPlayData play) {
        Territory to;
        Territory from = play.getStart();
        if (from.equals(to = play.getEnd())) {
            Tile fromTile = (Tile)from.getAttachment("tile");
            if (fromTile != null && fromTile.getValue() != 0) {
                Territory blank = PlayDelegate.getBlankNeighbor(this.map, from);
                if (blank == null) {
                    return "Invalid move";
                }
                to = blank;
            }
        } else {
            String error = this.isValidPlay(from, to);
            if (error != null) {
                return error;
            }
        }
        this.performPlay(from, to, this.m_player);
        return null;
    }

    @Override
    public void signalStatus(String status) {
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.setStatus(status);
    }

    public static Territory getBlankNeighbor(GameMap map, Territory t) {
        for (Territory neighbor : map.getNeighbors(t)) {
            Tile neighborTile = (Tile)neighbor.getAttachment("tile");
            if (neighborTile == null || neighborTile.getValue() != 0) continue;
            return neighbor;
        }
        return null;
    }

    private String isValidPlay(Territory from, Territory to) {
        int startValue = ((Tile)from.getAttachment("tile")).getValue();
        int destValue = ((Tile)to.getAttachment("tile")).getValue();
        if (startValue != 0 && destValue == 0) {
            return null;
        }
        return "Move does not swap a tile with the blank square";
    }

    private void performPlay(Territory from, Territory to, PlayerID player) {
        String transcriptText = player.getName() + " moved tile from " + from.getName() + " to " + to.getName();
        this.m_bridge.getHistoryWriter().startEvent(transcriptText);
        PlayDelegate.swap(this.m_bridge, from, to);
    }

    static void swap(IDelegateBridge bridge, Territory from, Territory to) {
        Tile fromAttachment = (Tile)from.getAttachment("tile");
        Tile toAttachment = (Tile)to.getAttachment("tile");
        int fromValue = fromAttachment.getValue();
        int toValue = toAttachment.getValue();
        Change fromChange = ChangeFactory.attachmentPropertyChange(fromAttachment, Integer.toString(toValue), "value");
        Change toChange = ChangeFactory.attachmentPropertyChange(toAttachment, Integer.toString(fromValue), "value");
        CompositeChange change = new CompositeChange();
        change.add(fromChange);
        change.add(toChange);
        bridge.addChange(change);
        IGridGameDisplay display = (IGridGameDisplay)bridge.getDisplayChannelBroadcaster();
        display.refreshTerritories(null);
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return IGridPlayDelegate.class;
    }
}

