/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.slidingtiles.player;

import games.puzzle.slidingtiles.attachments.Tile;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.grid.delegate.remote.IGridPlayDelegate;
import games.strategy.grid.player.GridAbstractAI;
import games.strategy.grid.ui.GridPlayData;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RandomAI
extends GridAbstractAI {
    public RandomAI(String name, String type) {
        super(name, type);
    }

    protected void play() {
        this.pause();
        GameMap map = this.getGameData().getMap();
        List<Territory> territories = map.getTerritories();
        IGridPlayDelegate playDel = (IGridPlayDelegate)this.getPlayerBridge().getRemoteDelegate();
        PlayerID me = this.getPlayerID();
        Territory blank = null;
        for (Territory t : territories) {
            int value;
            Tile tile = (Tile)t.getAttachment("tile");
            if (tile == null || (value = tile.getValue()) != 0) continue;
            blank = t;
            break;
        }
        if (blank == null) {
            throw new RuntimeException("No blank tile");
        }
        Random random = new Random();
        ArrayList<Territory> neighbors = new ArrayList<Territory>(map.getNeighbors(blank));
        Territory swap = (Territory)neighbors.get(random.nextInt(neighbors.size()));
        GridPlayData play = new GridPlayData(swap, blank, me);
        playDel.play(play);
    }
}

