/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.slidingtiles.ui;

import games.puzzle.slidingtiles.attachments.Tile;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.Territory;
import games.strategy.grid.ui.GridMapData;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;

public class NPuzzleMapData
extends GridMapData {
    protected Map<Integer, Rectangle> m_rects;

    public NPuzzleMapData(GameMap map, int x_dim, int y_dim, int squareWidth, int squareHeight, int topLeftOffsetWidth, int topLeftOffsetHeight) {
        super(map, x_dim, y_dim, squareWidth, squareHeight, topLeftOffsetWidth, topLeftOffsetHeight);
    }

    public synchronized void initializeGridMapData(GameMap map) {
        this.m_rects = new HashMap<Integer, Rectangle>();
        for (Territory territory : map.getTerritories()) {
            int value;
            Tile tile = (Tile)territory.getAttachment("tile");
            if (tile == null || (value = tile.getValue()) == 0) continue;
            int tileX = value % this.m_gridWidth;
            int tileY = value / this.m_gridWidth;
            Rectangle rectangle = new Rectangle(tileX * this.m_squareWidth, tileY * this.m_squareHeight, this.m_squareWidth, this.m_squareHeight);
            this.m_rects.put(value, rectangle);
        }
    }

    public synchronized Rectangle getLocation(int value) {
        return this.m_rects.get(value);
    }
}

