/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.slidingtiles.ui;

import games.puzzle.slidingtiles.attachments.Tile;
import games.puzzle.slidingtiles.ui.NPuzzleMapData;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import games.strategy.grid.ui.GridGameFrame;
import games.strategy.grid.ui.GridMapData;
import games.strategy.grid.ui.GridMapPanel;
import games.strategy.grid.ui.GridPlayData;
import games.strategy.grid.ui.IGridPlayData;
import games.strategy.ui.ImageScrollModel;
import games.strategy.util.Tuple;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NPuzzleMapPanel
extends GridMapPanel {
    private static final long serialVersionUID = 981372652838512191L;
    private BufferedImage m_backgroundImage = null;

    public NPuzzleMapPanel(GameData data, GridMapData mapData, GridGameFrame parentGridGameFrame, ImageScrollModel imageScrollModel) {
        super(data, mapData, parentGridGameFrame, imageScrollModel);
    }

    @Override
    protected void mapDataAndDimensionsChanged() {
        this.setBackgroundImage((File)this.m_gameData.getProperties().get("Background"));
    }

    public void setBackgroundImage(File file) {
        if (file != null) {
            try {
                BufferedImage bigimage = ImageIO.read(file);
                AffineTransform trans = new AffineTransform();
                double scalex = this.m_mapData.getMapDimensions().getWidth() / (double)bigimage.getWidth();
                double scaley = this.m_mapData.getMapDimensions().getHeight() / (double)bigimage.getHeight();
                trans.scale(scalex, scaley);
                AffineTransformOp scale = new AffineTransformOp(trans, 3);
                this.m_backgroundImage = new BufferedImage((int)this.m_mapData.getMapDimensions().getWidth(), (int)this.m_mapData.getMapDimensions().getHeight(), bigimage.getType());
                scale.filter(bigimage, this.m_backgroundImage);
            }
            catch (IOException e) {
                this.m_backgroundImage = null;
            }
        } else {
            this.m_backgroundImage = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NPuzzleMapPanel.this.repaint();
            }
        });
    }

    @Override
    protected void paintComponentMiddleLayer(Graphics2D g2d, int topLeftX, int topLeftY) {
        NPuzzleMapData nPuzzleMapData = (NPuzzleMapData)this.m_mapData;
        g2d.setColor(Color.lightGray);
        g2d.fillRect(0, 0, this.m_model.getMaxWidth(), this.m_model.getMaxHeight());
        g2d.setColor(Color.white);
        g2d.fillRect(this.m_mapData.getBevelWidth(), this.m_mapData.getBevelHeight(), this.m_model.getMaxWidth() - this.m_mapData.getBevelWidth() * 2, this.m_model.getMaxHeight() - this.m_mapData.getBevelHeight() * 2);
        for (Map.Entry<Territory, Polygon> entry : nPuzzleMapData.getTerritoryPolygons(this.m_gameData.getMap()).entrySet()) {
            int value;
            Polygon p = entry.getValue();
            Territory at = entry.getKey();
            Tile tile = (Tile)at.getAttachment("tile");
            if (tile != null && (value = tile.getValue()) != 0) {
                Rectangle square = p.getBounds();
                Rectangle tileData = nPuzzleMapData.getLocation(value);
                if (this.m_backgroundImage == null) {
                    g2d.setColor(Color.black);
                    g2d.drawString(Integer.toString(value), square.x + square.width * 5 / 12, square.y + square.height * 7 / 12);
                } else if (tileData != null) {
                    g2d.drawImage(this.m_backgroundImage, square.x, square.y, square.x + square.width, square.y + square.height, tileData.x, tileData.y, tileData.x + tileData.width, tileData.y + tileData.height, this);
                } else {
                    g2d.setColor(Color.white);
                    g2d.fillRect(square.x, square.y, square.width, square.height);
                }
            }
            g2d.setColor(Color.black);
            g2d.drawPolygon(p);
        }
    }

    @Override
    protected MouseMotionListener getMouseMotionListener() {
        return new MouseMotionAdapter(){};
    }

    @Override
    public GridPlayData waitForPlay(PlayerID player, IPlayerBridge bridge, CountDownLatch waiting) throws InterruptedException {
        if (waiting == null || waiting.getCount() != 1L) {
            throw new IllegalArgumentException("CountDownLatch must be non-null and have getCount()==1");
        }
        this.m_waiting = waiting;
        this.m_waiting.await();
        if (this.m_clickedAt == null || this.m_releasedAt == null) {
            this.m_clickedAt = null;
            this.m_releasedAt = null;
            throw new InterruptedException("Interrupted while waiting for play.");
        }
        GridPlayData play = new GridPlayData(this.m_clickedAt, this.m_releasedAt, player);
        this.m_clickedAt = null;
        this.m_releasedAt = null;
        return play;
    }

    @Override
    public void setMouseShadowUnits(Collection<Unit> units) {
    }

    @Override
    protected String isValidPlay(IGridPlayData play) {
        return null;
    }

    @Override
    protected Collection<Territory> getCapturesForPlay(IGridPlayData play) {
        return null;
    }

    @Override
    protected Tuple<Collection<IGridPlayData>, Collection<Territory>> getValidMovesList(Territory clickedOn, PlayerID player) {
        return null;
    }
}

