/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.tictactoe;

import games.puzzle.tictactoe.player.BetterAI;
import games.puzzle.tictactoe.ui.TicTacToeMapPanel;
import games.puzzle.tictactoe.ui.TicTacToeMenu;
import games.strategy.engine.framework.IGameLoader;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.grid.GridGame;
import games.strategy.grid.player.GridAbstractAI;
import games.strategy.grid.player.GridGamePlayer;
import games.strategy.grid.player.RandomAI;
import games.strategy.grid.ui.GridGameFrame;
import games.strategy.grid.ui.GridGameMenu;
import games.strategy.grid.ui.GridMapData;
import games.strategy.grid.ui.GridMapPanel;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TicTacToe
extends GridGame
implements IGameLoader {
    private static final long serialVersionUID = 6817825634310618978L;
    private static final String HUMAN_PLAYER_TYPE = "Human";
    private static final String RANDOM_COMPUTER_PLAYER_TYPE = "Random AI";
    private static final String MINIMAX_COMPUTER_PLAYER_TYPE = "Minimax AI";
    private static final String ALPHABETA_COMPUTER_PLAYER_TYPE = "\u03b1\u03b2 AI";

    @Override
    public String[] getServerPlayerTypes() {
        return new String[]{HUMAN_PLAYER_TYPE, ALPHABETA_COMPUTER_PLAYER_TYPE, MINIMAX_COMPUTER_PLAYER_TYPE, RANDOM_COMPUTER_PLAYER_TYPE};
    }

    @Override
    public Set<IGamePlayer> createPlayers(Map<String, String> playerNames) {
        HashSet<IGamePlayer> players = new HashSet<IGamePlayer>();
        for (String name : playerNames.keySet()) {
            GridAbstractAI ai;
            String type = playerNames.get(name);
            if (type.equals(HUMAN_PLAYER_TYPE) || type.equals("Client")) {
                GridGamePlayer player = new GridGamePlayer(name, type);
                players.add(player);
                continue;
            }
            if (type.equals(RANDOM_COMPUTER_PLAYER_TYPE)) {
                ai = new RandomAI(name, type);
                players.add(ai);
                continue;
            }
            if (type.equals(MINIMAX_COMPUTER_PLAYER_TYPE)) {
                ai = new BetterAI(name, type, BetterAI.Algorithm.MINIMAX);
                players.add(ai);
                continue;
            }
            if (type.equals(ALPHABETA_COMPUTER_PLAYER_TYPE)) {
                ai = new BetterAI(name, type, BetterAI.Algorithm.ALPHABETA);
                players.add(ai);
                continue;
            }
            throw new IllegalStateException("Player type not recognized:" + type);
        }
        return players;
    }

    @Override
    protected Class<? extends GridMapPanel> getGridMapPanelClass() {
        return TicTacToeMapPanel.class;
    }

    @Override
    protected Class<? extends GridMapData> getGridMapDataClass() {
        return GridMapData.class;
    }

    @Override
    protected Class<? extends GridGameMenu<GridGameFrame>> getGridTableMenuClass() {
        return TicTacToeMenu.class;
    }
}

