/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.tictactoe.delegate;

import games.puzzle.tictactoe.delegate.TicTacToePlayExtendedDelegateState;
import games.strategy.common.delegate.AbstractDelegate;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.message.IRemote;
import games.strategy.grid.delegate.remote.IGridPlayDelegate;
import games.strategy.grid.ui.IGridPlayData;
import games.strategy.grid.ui.display.IGridGameDisplay;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayDelegate
extends AbstractDelegate
implements IGridPlayDelegate {
    @Override
    public void start() {
        super.start();
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.setStatus(this.m_player.getName() + "'s turn");
    }

    @Override
    public void end() {
        super.end();
    }

    @Override
    public Serializable saveState() {
        TicTacToePlayExtendedDelegateState state = new TicTacToePlayExtendedDelegateState();
        state.superState = super.saveState();
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        TicTacToePlayExtendedDelegateState s = (TicTacToePlayExtendedDelegateState)state;
        super.loadState(s.superState);
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        return true;
    }

    @Override
    public void signalStatus(String status) {
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        display.setStatus(status);
    }

    @Override
    public String play(IGridPlayData play) {
        Territory from = play.getStart();
        String error = this.isValidPlay(from);
        if (error != null) {
            return error;
        }
        this.performPlay(from, this.m_player);
        return null;
    }

    private String isValidPlay(Territory territory) {
        if (territory.getOwner().equals(PlayerID.NULL_PLAYERID)) {
            return null;
        }
        return "Square is not empty";
    }

    private void performPlay(Territory at, PlayerID player) {
        ArrayList<Unit> units = new ArrayList<Unit>(1);
        units.add(this.getData().getUnitTypeList().getUnitType("ticmark").create(player));
        String transcriptText = player.getName() + " played in " + at.getName();
        this.m_bridge.getHistoryWriter().startEvent(transcriptText, units);
        Change place = ChangeFactory.addUnits(at, units);
        Change owner = ChangeFactory.changeOwner(at, player);
        CompositeChange change = new CompositeChange();
        change.add(place);
        change.add(owner);
        this.m_bridge.addChange(change);
        IGridGameDisplay display = (IGridGameDisplay)this.m_bridge.getDisplayChannelBroadcaster();
        ArrayList<Territory> refresh = new ArrayList<Territory>();
        refresh.add(at);
        display.refreshTerritories(refresh);
    }

    @Override
    public Class<? extends IRemote> getRemoteType() {
        return IGridPlayDelegate.class;
    }
}

