/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.tictactoe.player;

import games.strategy.common.player.ai.AIAlgorithm;
import games.strategy.common.player.ai.GameState;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import games.strategy.grid.delegate.remote.IGridPlayDelegate;
import games.strategy.grid.player.GridAbstractAI;
import games.strategy.grid.ui.GridPlayData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class BetterAI
extends GridAbstractAI {
    private int m_xDimension;
    private int m_yDimension;
    private PlayerID m_opponent;
    private final Algorithm algorithm;

    public BetterAI(String name, String type, Algorithm algorithm) {
        super(name, type);
        this.algorithm = algorithm;
    }

    public void initialize(IPlayerBridge bridge, PlayerID id) {
        super.initialize(bridge, id);
        this.m_xDimension = this.getGameData().getMap().getXDimension();
        this.m_yDimension = this.getGameData().getMap().getYDimension();
        this.m_opponent = null;
        for (PlayerID p : this.getGameData().getPlayerList().getPlayers()) {
            if (p.equals(id) || p.equals(PlayerID.NULL_PLAYERID)) continue;
            this.m_opponent = p;
            break;
        }
    }

    protected void play() {
        State initial_state = this.getInitialState();
        Play move = this.algorithm == Algorithm.MINIMAX ? AIAlgorithm.minimaxSearch(initial_state) : AIAlgorithm.alphaBetaSearch(initial_state);
        IGridPlayDelegate playDel = (IGridPlayDelegate)this.getPlayerBridge().getRemoteDelegate();
        PlayerID me = this.getPlayerID();
        Territory start = this.getGameData().getMap().getTerritoryFromCoordinates(move.getX(), move.getY());
        GridPlayData play = new GridPlayData(start, null, me);
        playDel.play(play);
    }

    private State getInitialState() {
        return new State(this.getGameData().getMap().getTerritories());
    }

    class Play {
        private final int m_x;
        private final int m_y;

        public Play(int x, int y) {
            this.m_x = x;
            this.m_y = y;
        }

        public int getX() {
            return this.m_x;
        }

        public int getY() {
            return this.m_y;
        }

        public String toString() {
            return "(" + this.m_x + "," + this.m_y + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class State
    extends GameState<Play> {
        private final HashMap<Integer, PlayerID> squareOwner;
        private final int depth;
        private Play m_move;

        public State(Collection<Territory> territories) {
            this.depth = 0;
            this.squareOwner = new HashMap(BetterAI.this.m_xDimension * BetterAI.this.m_yDimension);
            for (Territory t : territories) {
                this.squareOwner.put(t.getX() * BetterAI.this.m_xDimension + t.getY(), t.getOwner());
            }
        }

        private State(Play move, State parentState) {
            this.depth = parentState.depth + 1;
            this.m_move = move;
            PlayerID playerPerformingMove = parentState.depth % 2 == 0 ? BetterAI.this.getPlayerID() : BetterAI.this.m_opponent;
            this.squareOwner = new HashMap(parentState.squareOwner.size());
            for (Map.Entry<Integer, PlayerID> s : parentState.squareOwner.entrySet()) {
                this.squareOwner.put(s.getKey(), s.getValue());
            }
            this.squareOwner.put(move.getX() * BetterAI.this.m_xDimension + move.getY(), playerPerformingMove);
        }

        public State getSuccessor(Play move) {
            return new State(move, this);
        }

        @Override
        public Play getMove() {
            return this.m_move;
        }

        @Override
        public Collection<GameState<Play>> successors() {
            ArrayList<GameState<Play>> successors = new ArrayList<GameState<Play>>();
            for (int x = 0; x < BetterAI.this.m_xDimension; ++x) {
                for (int y = 0; y < BetterAI.this.m_yDimension; ++y) {
                    if (!this.get(x, y).equals(PlayerID.NULL_PLAYERID)) continue;
                    Play play = new Play(x, y);
                    successors.add(new State(play, this));
                }
            }
            return successors;
        }

        private PlayerID get(int x, int y) {
            return this.squareOwner.get(BetterAI.this.m_xDimension * x + y);
        }

        @Override
        public float getUtility() {
            int y;
            int x;
            PlayerID player;
            PlayerID id = BetterAI.this.getPlayerID();
            for (int y2 = 0; y2 < BetterAI.this.m_yDimension; ++y2) {
                player = this.get(0, y2);
                if (player.equals(PlayerID.NULL_PLAYERID)) continue;
                for (x = 0; x < BetterAI.this.m_xDimension; ++x) {
                    if (player.equals(this.get(x, y2))) continue;
                    player = null;
                    break;
                }
                if (player == null) continue;
                if (player.equals(id)) {
                    return 1.0f;
                }
                if (!player.equals(BetterAI.this.m_opponent)) continue;
                return -1.0f;
            }
            for (int x2 = 0; x2 < BetterAI.this.m_xDimension; ++x2) {
                player = this.get(x2, 0);
                if (player.equals(PlayerID.NULL_PLAYERID)) continue;
                for (y = 0; y < BetterAI.this.m_yDimension; ++y) {
                    if (player.equals(this.get(x2, y))) continue;
                    player = null;
                    break;
                }
                if (player == null) continue;
                if (player.equals(id)) {
                    return 1.0f;
                }
                if (!player.equals(BetterAI.this.m_opponent)) continue;
                return -1.0f;
            }
            PlayerID player2 = this.get(0, 0);
            if (!player2.equals(PlayerID.NULL_PLAYERID)) {
                for (int x3 = 0; x3 < BetterAI.this.m_xDimension; ++x3) {
                    y = x3;
                    if (player2.equals(this.get(x3, y))) continue;
                    player2 = null;
                    break;
                }
                if (player2 != null) {
                    if (player2.equals(id)) {
                        return 1.0f;
                    }
                    if (player2.equals(BetterAI.this.m_opponent)) {
                        return -1.0f;
                    }
                }
            }
            if (!(player2 = this.get(BetterAI.this.m_xDimension - 1, 0)).equals(PlayerID.NULL_PLAYERID)) {
                int y3 = -1;
                for (x = BetterAI.this.m_xDimension - 1; x >= 0 && ++y3 < BetterAI.this.m_yDimension; --x) {
                    if (player2.equals(this.get(x, y3))) continue;
                    player2 = null;
                    break;
                }
                if (player2 != null) {
                    if (player2.equals(id)) {
                        return 1.0f;
                    }
                    if (player2.equals(BetterAI.this.m_opponent)) {
                        return -1.0f;
                    }
                }
            }
            return 0.0f;
        }

        @Override
        public boolean gameIsOver() {
            if (this.getUtility() != 0.0f) {
                return true;
            }
            for (PlayerID player : this.squareOwner.values()) {
                if (!player.equals(PlayerID.NULL_PLAYERID)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean cutoffTest() {
            return this.gameIsOver();
        }

        public String toString() {
            String string = "";
            for (int y = 0; y < BetterAI.this.m_yDimension; ++y) {
                for (int x = 0; x < BetterAI.this.m_xDimension; ++x) {
                    String player = this.get(x, y).getName();
                    string = player.equals("X") ? string + "X " : (player.equals("O") ? string + "O " : string + "_ ");
                }
                string = string + "\n";
            }
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Algorithm {
        MINIMAX,
        ALPHABETA;

    }
}

