/*
 * Decompiled with CFR 0.152.
 */
package games.puzzle.tictactoe.ui;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.events.GameDataChangeListener;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import games.strategy.grid.ui.GridGameFrame;
import games.strategy.grid.ui.GridMapData;
import games.strategy.grid.ui.GridMapPanel;
import games.strategy.grid.ui.GridPlayData;
import games.strategy.grid.ui.IGridPlayData;
import games.strategy.ui.ImageScrollModel;
import games.strategy.util.Tuple;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TicTacToeMapPanel
extends GridMapPanel
implements MouseListener {
    private static final long serialVersionUID = 96734493518077373L;

    public TicTacToeMapPanel(GameData data, GridMapData mapData, GridGameFrame parentGridGameFrame, ImageScrollModel imageScrollModel) {
        super(data, mapData, parentGridGameFrame, imageScrollModel);
        this.updateAllImages();
        this.m_gameData.addDataChangeListener(new GameDataChangeListener(){

            public void gameDataChanged(Change change) {
                TicTacToeMapPanel.this.updateAllImages();
            }
        });
    }

    @Override
    protected void paintComponentMiddleLayer(Graphics2D g2d, int topLeftX, int topLeftY) {
        g2d.setColor(Color.lightGray);
        g2d.fillRect(0, 0, this.m_model.getMaxWidth(), this.m_model.getMaxHeight());
        g2d.setColor(Color.white);
        g2d.fillRect(this.m_mapData.getBevelWidth(), this.m_mapData.getBevelHeight(), this.m_model.getMaxWidth() - this.m_mapData.getBevelWidth() * 2, this.m_model.getMaxHeight() - this.m_mapData.getBevelHeight() * 2);
        for (Map.Entry<Territory, Polygon> entry : this.m_mapData.getTerritoryPolygons(this.m_gameData.getMap()).entrySet()) {
            Polygon p = entry.getValue();
            Territory at = entry.getKey();
            Color backgroundColor = Color.WHITE;
            g2d.setColor(Color.black);
            Image image = (Image)this.m_images.get(at);
            if (image != null) {
                Rectangle square = p.getBounds();
                g2d.drawImage(image, square.x, square.y, square.width, square.height, backgroundColor, null);
            }
            g2d.drawPolygon(p);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.m_clickedAt = this.m_mapData.getTerritoryAt(e.getX() + this.m_model.getX(), e.getY() + this.m_model.getY(), this.m_gameData.getMap());
        if (this.m_waiting != null && this.m_clickedAt != null) {
            this.m_waiting.countDown();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    protected MouseMotionListener getMouseMotionListener() {
        return new MouseMotionAdapter(){};
    }

    @Override
    public GridPlayData waitForPlay(PlayerID player, IPlayerBridge bridge, CountDownLatch waiting) throws InterruptedException {
        if (waiting == null || waiting.getCount() != 1L) {
            throw new IllegalArgumentException("CountDownLatch must be non-null and have getCount()==1");
        }
        this.m_waiting = waiting;
        this.m_waiting.await();
        if (this.m_clickedAt == null) {
            this.m_clickedAt = null;
            throw new InterruptedException("Interrupted while waiting for play.");
        }
        Territory play = this.m_clickedAt;
        this.m_clickedAt = null;
        return new GridPlayData(play, null, player);
    }

    @Override
    protected String isValidPlay(IGridPlayData play) {
        return null;
    }

    @Override
    protected Collection<Territory> getCapturesForPlay(IGridPlayData play) {
        return null;
    }

    @Override
    protected Tuple<Collection<IGridPlayData>, Collection<Territory>> getValidMovesList(Territory clickedOn, PlayerID player) {
        return null;
    }
}

