/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.common.delegate;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.delegate.IDelegate;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.display.IDisplay;
import games.strategy.engine.gamePlayer.IRemotePlayer;
import games.strategy.engine.message.IRemote;
import games.strategy.sound.ISound;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDelegate
implements IDelegate {
    protected String m_name;
    protected String m_displayName;
    protected PlayerID m_player;
    protected IDelegateBridge m_bridge;

    @Override
    public void initialize(String name, String displayName) {
        this.m_name = name;
        this.m_displayName = displayName;
    }

    @Override
    public void setDelegateBridgeAndPlayer(IDelegateBridge iDelegateBridge) {
        this.m_bridge = iDelegateBridge;
        this.m_player = iDelegateBridge.getPlayerID();
    }

    @Override
    public void start() {
    }

    @Override
    public void end() {
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getDisplayName() {
        return this.m_displayName;
    }

    @Override
    public Serializable saveState() {
        return null;
    }

    @Override
    public void loadState(Serializable state) {
    }

    @Override
    public abstract Class<? extends IRemote> getRemoteType();

    @Override
    public IDelegateBridge getBridge() {
        return this.m_bridge;
    }

    protected GameData getData() {
        return this.m_bridge.getData();
    }

    protected IDisplay getDisplay() {
        return AbstractDelegate.getDisplay(this.m_bridge);
    }

    protected static IDisplay getDisplay(IDelegateBridge bridge) {
        return bridge.getDisplayChannelBroadcaster();
    }

    protected ISound getSoundChannel() {
        return AbstractDelegate.getSoundChannel(this.m_bridge);
    }

    protected static ISound getSoundChannel(IDelegateBridge bridge) {
        return bridge.getSoundChannelBroadcaster();
    }

    protected IRemotePlayer getRemotePlayer() {
        return AbstractDelegate.getRemotePlayer(this.m_bridge);
    }

    protected static IRemotePlayer getRemotePlayer(IDelegateBridge bridge) {
        return bridge.getRemotePlayer();
    }

    protected IRemotePlayer getRemotePlayer(PlayerID player) {
        return this.m_bridge.getRemotePlayer(player);
    }
}

