/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.common.image;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.ResourceLoader;
import games.strategy.ui.Util;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class UnitImageFactory {
    private static final String FILE_NAME_BASE = "units/";
    private final Map<String, Image> m_images = new HashMap<String, Image>();
    private ResourceLoader m_resourceLoader = ResourceLoader.getMapResourceLoader(null, true);

    public void setResourceLoader(ResourceLoader loader) {
        this.m_resourceLoader = loader;
        this.clearImageCache();
    }

    private void clearImageCache() {
        this.m_images.clear();
    }

    public Image getImage(UnitType type, PlayerID player, GameData data) {
        String baseName = this.getBaseImageName(type, player, data);
        String fullName = baseName + player.getName();
        if (this.m_images.containsKey(fullName)) {
            return this.m_images.get(fullName);
        }
        Image baseImage = this.getBaseImage(baseName, player);
        this.m_images.put(fullName, baseImage);
        return baseImage;
    }

    private Image getBaseImage(String baseImageName, PlayerID id) {
        String fileName = FILE_NAME_BASE + id.getName() + "/" + baseImageName + ".png";
        URL url = this.m_resourceLoader.getResource(fileName);
        if (url == null) {
            throw new IllegalStateException("Cant load: " + baseImageName + "  looking in: " + fileName);
        }
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        try {
            Util.ensureImageLoaded(image);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        return image;
    }

    private String getBaseImageName(UnitType type, PlayerID id, GameData data) {
        StringBuilder name = new StringBuilder(32);
        name.append(type.getName());
        return name.toString();
    }
}

