/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.common.player;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.gamePlayer.IGamePlayer;
import games.strategy.engine.gamePlayer.IPlayerBridge;

public abstract class AbstractBasePlayer
implements IGamePlayer {
    private final String m_name;
    private final String m_type;
    private PlayerID m_playerID;
    private IPlayerBridge m_iPlayerBridge;

    public AbstractBasePlayer(String name, String type) {
        this.m_name = name;
        this.m_type = type;
    }

    public void initialize(IPlayerBridge iPlayerBridge, PlayerID playerID) {
        this.m_iPlayerBridge = iPlayerBridge;
        this.m_playerID = playerID;
    }

    protected final GameData getGameData() {
        return this.m_iPlayerBridge.getGameData();
    }

    protected final IPlayerBridge getPlayerBridge() {
        return this.m_iPlayerBridge;
    }

    public final String getName() {
        return this.m_name;
    }

    public final String getType() {
        return this.m_type;
    }

    public final PlayerID getPlayerID() {
        return this.m_playerID;
    }

    public String toString() {
        return this.m_playerID == null || this.m_playerID.getName() == null || !this.m_playerID.getName().equals(this.m_name) ? this.m_type + ":" + this.m_name + ":" + (this.m_playerID == null ? "NullID" : this.m_playerID.getName()) : this.m_type + ":" + this.m_name;
    }

    public void start(String stepName) {
        if (stepName != null) {
            String bridgeStep = this.getPlayerBridge().getStepName();
            int i = 0;
            boolean shownErrorMessage = false;
            while (!stepName.equals(bridgeStep)) {
                try {
                    Thread.sleep(100L);
                    if (++i > 30 && !shownErrorMessage) {
                        System.out.println("Start step: " + stepName + " does not match player bridge step: " + bridgeStep + ". Player Bridge GameOver=" + this.getPlayerBridge().isGameOver() + ", PlayerID: " + this.getPlayerID().getName() + ", Game: " + this.getGameData().getGameName() + ". Something wrong or very laggy. Will keep trying for 30 more seconds. ");
                        shownErrorMessage = true;
                    }
                    if (i > 310) {
                        System.err.println("Start step: " + stepName + " still does not match player bridge step: " + bridgeStep + " even after waiting more than 30 seconds. This will probably result in a ClassCastException very soon. Player Bridge GameOver=" + this.getPlayerBridge().isGameOver() + ", PlayerID: " + this.getPlayerID().getName() + ", Game: " + this.getGameData().getGameName());
                        break;
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                bridgeStep = this.getPlayerBridge().getStepName();
            }
        }
    }
}

