/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.debug;

import games.strategy.debug.SynchedByteArrayOutputStream;
import games.strategy.debug.ThreadReader;
import games.strategy.engine.EngineVersion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;

public class Console
extends JFrame {
    private static final long serialVersionUID = -3489030525309243438L;
    private static Console s_console;
    private static final ThreadMXBean threadMxBean;
    private final JTextArea m_text = new JTextArea(20, 50);
    private final JToolBar m_actions = new JToolBar(0);
    private final Action m_copyAction = new AbstractAction("Copy to clipboard"){
        private static final long serialVersionUID = 1573097546768015070L;

        public void actionPerformed(ActionEvent e) {
            String text = Console.this.m_text.getText();
            StringSelection select = new StringSelection(text);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(select, select);
        }
    };
    private final AbstractAction m_threadDiagnoseAction = new AbstractAction("Enumerate Threads"){
        private static final long serialVersionUID = 4414139104815149199L;

        public void actionPerformed(ActionEvent e) {
            System.out.println(Console.getThreadDumps());
        }
    };
    private final AbstractAction m_memoryAction = new AbstractAction("Memory"){
        private static final long serialVersionUID = 1053036985791697566L;

        public void actionPerformed(ActionEvent e) {
            System.gc();
            System.runFinalization();
            System.gc();
            Console.this.append(Console.getMemory());
        }
    };
    private final AbstractAction m_propertiesAction = new AbstractAction("Properties"){
        private static final long serialVersionUID = -8186358504886470902L;

        public void actionPerformed(ActionEvent e) {
            String s = Console.getProperties();
            Console.this.append(s);
        }
    };

    public static Console getConsole() {
        if (s_console == null) {
            s_console = new Console();
        }
        return s_console;
    }

    public static void main(String[] args) {
        Console c = Console.getConsole();
        c.displayStandardError();
        c.displayStandardOutput();
        c.setVisible(true);
    }

    public Console() {
        super("An error has occured!");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        this.m_text.setLineWrap(true);
        this.m_text.setWrapStyleWord(true);
        JScrollPane scroll = new JScrollPane(this.m_text);
        this.getContentPane().add((Component)scroll, "Center");
        this.getContentPane().add((Component)this.m_actions, "South");
        this.m_actions.setFloatable(false);
        this.m_actions.add(this.m_threadDiagnoseAction);
        this.m_actions.add(this.m_memoryAction);
        this.m_actions.add(this.m_propertiesAction);
        this.m_actions.add(this.m_copyAction);
        this.pack();
    }

    public void append(String s) {
        this.m_text.append(s);
    }

    public void dumpStacks() {
        this.m_threadDiagnoseAction.actionPerformed(null);
    }

    public String getText() {
        return this.m_text.getText();
    }

    public void displayStandardError() {
        SynchedByteArrayOutputStream out = new SynchedByteArrayOutputStream(System.err);
        ThreadReader reader = new ThreadReader(out, this.m_text, true);
        Thread thread = new Thread((Runnable)reader, "Console std err reader");
        thread.setDaemon(true);
        thread.start();
        PrintStream print = new PrintStream(out);
        System.setErr(print);
    }

    public void displayStandardOutput() {
        SynchedByteArrayOutputStream out = new SynchedByteArrayOutputStream(System.out);
        ThreadReader reader = new ThreadReader(out, this.m_text, false);
        Thread thread = new Thread((Runnable)reader, "Console std out reader");
        thread.setDaemon(true);
        thread.start();
        PrintStream print = new PrintStream(out);
        System.setOut(print);
    }

    public static String getThreadDumps() {
        long[] deadlocks;
        ThreadInfo[] threadInfo;
        StringBuilder result = new StringBuilder();
        result.append("THREAD DUMP\n");
        for (ThreadInfo info : threadInfo = threadMxBean.getThreadInfo(threadMxBean.getAllThreadIds(), Integer.MAX_VALUE)) {
            if (info == null) continue;
            result.append("thread<" + info.getThreadId() + "," + info.getThreadName() + ">\n").append("state:" + (Object)((Object)info.getThreadState())).append("\n");
            if (info.getLockName() != null) {
                result.append("locked on:" + info.getLockName()).append(" locked owned by:<" + info.getLockOwnerId() + "," + info.getLockOwnerName() + ">\n");
            }
            StackTraceElement[] stackTrace = info.getStackTrace();
            for (int i = 0; i < stackTrace.length; ++i) {
                result.append("  ");
                result.append(stackTrace[i]);
                result.append("\n");
            }
            result.append("\n");
        }
        try {
            Method m = threadMxBean.getClass().getMethod("findDeadlockedThreads", new Class[0]);
            Object o = m.invoke((Object)threadMxBean, new Object[0]);
            deadlocks = (long[])o;
        }
        catch (Throwable t) {
            deadlocks = threadMxBean.findMonitorDeadlockedThreads();
        }
        if (deadlocks != null) {
            result.append("DEADLOCKS!!");
            for (long l : deadlocks) {
                result.append(l).append("\n");
            }
        }
        return result.toString();
    }

    public static String getMemory() {
        System.gc();
        StringBuilder buf = new StringBuilder("MEMORY\n");
        Runtime runtime = Runtime.getRuntime();
        buf.append("****\n");
        buf.append("Used Memory: " + (runtime.totalMemory() - runtime.freeMemory()));
        buf.append("\n");
        buf.append("Free memory: " + runtime.freeMemory());
        buf.append("\n");
        buf.append("Total memory: " + runtime.totalMemory());
        buf.append("\n");
        buf.append("Max memory: " + runtime.maxMemory());
        buf.append("\n");
        return buf.toString();
    }

    public static String getProperties() {
        StringBuilder buf = new StringBuilder("SYSTEM PROPERTIES\n");
        Properties props = System.getProperties();
        ArrayList<Object> keys = new ArrayList<Object>(props.keySet());
        Collections.sort(keys);
        for (String string : keys) {
            String value = props.getProperty(string);
            buf.append(string).append(" ").append(value).append("\n");
        }
        return buf.toString();
    }

    public static String getDebugReport() {
        StringBuilder result = new StringBuilder(500);
        result.append("CONSOLE_OUTPUT");
        result.append(Console.getConsole().getText());
        result.append("\n");
        result.append(Console.getThreadDumps());
        result.append(Console.getProperties());
        result.append(Console.getMemory());
        result.append(Console.getOpenAppWindows());
        result.append("ENGINE VERSION").append(EngineVersion.VERSION).append("\n");
        return result.toString();
    }

    public static String getOpenAppWindows() {
        StringBuilder builder = new StringBuilder("WINDOWS\n");
        for (Frame f : Frame.getFrames()) {
            if (!f.isVisible()) continue;
            builder.append("window:").append("class " + f.getClass()).append(" size " + f.getSize()).append(" title " + f.getTitle()).append("\n");
        }
        return builder.toString();
    }

    static {
        threadMxBean = ManagementFactory.getThreadMXBean();
    }
}

