/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.chat;

import java.awt.Component;
import java.awt.Graphics;
import java.util.List;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeIcon
implements Icon {
    private static final int GAP = 2;
    private final List<Icon> m_incons;

    CompositeIcon(List<Icon> icons) {
        this.m_incons = icons;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int dx = 0;
        for (Icon icon : this.m_incons) {
            icon.paintIcon(c, g, x + dx, y);
            dx += 2;
            dx += icon.getIconWidth();
        }
    }

    @Override
    public int getIconWidth() {
        int sum = 0;
        for (Icon icon : this.m_incons) {
            sum += icon.getIconWidth();
            sum += 2;
        }
        return sum;
    }

    @Override
    public int getIconHeight() {
        int max = 0;
        for (Icon icon : this.m_incons) {
            max = Math.max(icon.getIconHeight(), max);
        }
        return max;
    }
}

