/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.chat;

import games.strategy.engine.chat.Chat;
import games.strategy.engine.chat.ChatFloodControl;
import games.strategy.engine.chat.ChatMessage;
import games.strategy.engine.chat.IChatListener;
import games.strategy.engine.chat.IChatPanel;
import games.strategy.engine.chat.IStatusListener;
import games.strategy.engine.message.IChannelMessenger;
import games.strategy.engine.message.IRemoteMessenger;
import games.strategy.net.IMessenger;
import games.strategy.net.INode;
import games.strategy.sound.DefaultSoundChannel;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadlessChat
implements IChatListener,
IChatPanel {
    private static final int MAX_LENGTH = 200000;
    private Chat m_chat;
    private boolean m_showTime = false;
    private StringBuffer m_allText = new StringBuffer();
    private String m_lastText = "";
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("'('HH:mm:ss')'");
    private final ChatFloodControl floodControl = new ChatFloodControl();
    public Set<String> m_hiddenPlayers = new HashSet<String>();
    private final Set<INode> m_players = new HashSet<INode>();
    private PrintStream m_out = null;
    private final IStatusListener m_statusListener = new IStatusListener(){

        public void statusChanged(INode node, String newStatus) {
        }
    };

    public HeadlessChat(IMessenger messenger, IChannelMessenger channelMessenger, IRemoteMessenger remoteMessenger, String chatName, Chat.CHAT_SOUND_PROFILE chatSoundProfile) {
        Chat chat = new Chat(messenger, chatName, channelMessenger, remoteMessenger, chatSoundProfile);
        this.setChat(chat);
    }

    public HeadlessChat(Chat chat) {
        this.setChat(chat);
    }

    public Set<INode> getAllChatters() {
        return new HashSet<INode>(this.m_players);
    }

    public void setPrintStream(PrintStream out) {
        this.m_out = out;
    }

    public String toString() {
        return this.m_allText.toString();
    }

    @Override
    public String getAllText() {
        return this.m_allText.toString();
    }

    public String getLastText() {
        return this.m_lastText;
    }

    @Override
    public Chat getChat() {
        return this.m_chat;
    }

    @Override
    public void setShowChatTime(boolean showTime) {
        this.m_showTime = showTime;
    }

    @Override
    public void setPlayerRenderer(DefaultListCellRenderer renderer) {
    }

    @Override
    public synchronized void updatePlayerList(Collection<INode> players) {
        this.m_players.clear();
        for (INode name : players) {
            if (this.m_hiddenPlayers.contains(name.getName())) continue;
            this.m_players.add(name);
        }
    }

    public void addHiddenPlayerName(String name) {
        this.m_hiddenPlayers.add(name);
    }

    @Override
    public void shutDown() {
        if (this.m_chat != null) {
            this.m_chat.removeChatListener(this);
            this.m_chat.getStatusManager().removeStatusListener(this.m_statusListener);
            this.m_chat.shutdown();
        }
        this.m_chat = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setChat(Chat chat) {
        if (this.m_chat != null) {
            this.m_chat.removeChatListener(this);
            this.m_chat.getStatusManager().removeStatusListener(this.m_statusListener);
        }
        this.m_chat = chat;
        if (this.m_chat != null) {
            this.m_chat.addChatListener(this);
            this.m_chat.getStatusManager().addStatusListener(this.m_statusListener);
            Object object = this.m_chat.getMutex();
            synchronized (object) {
                this.m_allText = new StringBuffer();
                this.m_lastText = "";
                try {
                    if (this.m_out != null) {
                        this.m_out.println();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                for (ChatMessage message : this.m_chat.getChatHistory()) {
                    if (message.getFrom().equals(this.m_chat.getServerNode().getName())) {
                        if (message.getMessage().equals("?YOUR LOBBY CHATTING HAS BEEN TEMPORARILY 'MUTED' BY THE ADMINS, TRY AGAIN LATER")) {
                            this.addChatMessage("YOUR LOBBY CHATTING HAS BEEN TEMPORARILY 'MUTED' BY THE ADMINS, TRY AGAIN LATER", "ADMIN_CHAT_CONTROL", false);
                            continue;
                        }
                        if (message.getMessage().equals("?YOUR CHATTING IN THIS GAME HAS BEEN 'MUTED' BY THE HOST")) {
                            this.addChatMessage("YOUR CHATTING IN THIS GAME HAS BEEN 'MUTED' BY THE HOST", "HOST_CHAT_CONTROL", false);
                            continue;
                        }
                    }
                    this.addChatMessage(message.getMessage(), message.getFrom(), message.isMeMessage());
                }
            }
        }
        this.updatePlayerList(Collections.<INode>emptyList());
    }

    @Override
    public void addMessage(String message, String from, boolean thirdperson) {
        this.addMessageWithSound(message, from, thirdperson, "chat_message");
    }

    @Override
    public void addMessageWithSound(final String message, final String from, final boolean thirdperson, final String sound) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                if (from.equals(HeadlessChat.this.m_chat.getServerNode().getName())) {
                    if (message.equals("?YOUR LOBBY CHATTING HAS BEEN TEMPORARILY 'MUTED' BY THE ADMINS, TRY AGAIN LATER")) {
                        HeadlessChat.this.addChatMessage("YOUR LOBBY CHATTING HAS BEEN TEMPORARILY 'MUTED' BY THE ADMINS, TRY AGAIN LATER", "ADMIN_CHAT_CONTROL", false);
                        return;
                    }
                    if (message.equals("?YOUR CHATTING IN THIS GAME HAS BEEN 'MUTED' BY THE HOST")) {
                        HeadlessChat.this.addChatMessage("YOUR CHATTING IN THIS GAME HAS BEEN 'MUTED' BY THE HOST", "HOST_CHAT_CONTROL", false);
                        return;
                    }
                }
                if (!HeadlessChat.this.floodControl.allow(from, System.currentTimeMillis())) {
                    if (from.equals(HeadlessChat.this.m_chat.getLocalNode().getName())) {
                        HeadlessChat.this.addChatMessage("MESSAGE LIMIT EXCEEDED, TRY AGAIN LATER", "ADMIN_FLOOD_CONTROL", false);
                    }
                    return;
                }
                HeadlessChat.this.addChatMessage(message, from, thirdperson);
                DefaultSoundChannel.playSoundOnLocalMachine(sound, null);
            }
        });
        t.start();
    }

    private void addChatMessage(String originalMessage, String from, boolean thirdperson) {
        String fullMessage;
        String message = this.trimMessage(originalMessage);
        String time = this.simpleDateFormat.format(new Date());
        String prefix = thirdperson ? (this.m_showTime ? "* " + time + " " + from : "* " + from) : (this.m_showTime ? time + " " + from + ": " : from + ": ");
        this.m_lastText = fullMessage = prefix + " " + message + "\n";
        String currentAllText = this.m_allText.toString();
        if (currentAllText.length() > 200000) {
            this.m_allText = new StringBuffer(currentAllText.substring(100000, currentAllText.length()));
        }
        this.m_allText.append(fullMessage);
        try {
            if (this.m_out != null) {
                this.m_out.print("CHAT: " + fullMessage);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void addServerMessage(String message) {
        String fullMessage;
        this.m_lastText = fullMessage = "Server Message: \n" + message + "\n";
        String currentAllText = this.m_allText.toString();
        if (currentAllText.length() > 200000) {
            this.m_allText = new StringBuffer(currentAllText.substring(100000, currentAllText.length()));
        }
        this.m_allText.append(fullMessage);
        try {
            if (this.m_out != null) {
                this.m_out.print("CHAT: " + fullMessage);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public void addStatusMessage(String message) {
        String fullMessage;
        this.m_lastText = fullMessage = "--- " + message + " ---\n";
        String currentAllText = this.m_allText.toString();
        if (currentAllText.length() > 200000) {
            this.m_allText = new StringBuffer(currentAllText.substring(100000, currentAllText.length()));
        }
        this.m_allText.append(fullMessage);
        try {
            if (this.m_out != null) {
                this.m_out.print("CHAT: " + fullMessage);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private String trimMessage(String originalMessage) {
        if (originalMessage.length() > 200) {
            return originalMessage.substring(0, 199) + "...";
        }
        return originalMessage;
    }

    public String getPlayerDisplayString(INode node) {
        if (this.m_chat == null) {
            return "";
        }
        String extra = "";
        String notes = this.m_chat.getNotesForNode(node);
        if (notes != null && notes.length() > 0) {
            extra = extra + notes;
        }
        String status = this.m_chat.getStatusManager().getStatus(node);
        StringBuilder statusSB = new StringBuilder("");
        if (status != null && status.length() > 0) {
            if (status.length() > 25) {
                status = status.substring(0, 25);
            }
            for (int i = 0; i < status.length(); ++i) {
                char c = status.charAt(i);
                if (c >= '\u0300' && c <= '\u036f') continue;
                statusSB.append(c);
            }
            extra = extra + " (" + statusSB.toString() + ")";
        }
        if (extra.length() == 0) {
            return node.getName();
        }
        return node.getName() + extra;
    }

    public void ignorePlayer(INode player) {
        boolean isIgnored = this.m_chat.isIgnored(player);
        if (!isIgnored) {
            this.m_chat.setIgnored(player, true);
        }
    }

    public void stopIgnoringPlayer(INode player) {
        boolean isIgnored = this.m_chat.isIgnored(player);
        if (isIgnored) {
            this.m_chat.setIgnored(player, false);
        }
    }

    public void slapPlayer(INode player) {
        this.m_chat.sendSlap(player.getName());
    }

    public void slapPlayer(String playerName) {
        this.m_chat.sendSlap(playerName);
    }
}

