/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.chat;

import games.strategy.engine.chat.IStatusChannel;
import games.strategy.engine.chat.IStatusController;
import games.strategy.engine.chat.IStatusListener;
import games.strategy.engine.chat.StatusController;
import games.strategy.net.INode;
import games.strategy.net.Messengers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class StatusManager {
    private final List<IStatusListener> m_listeners = new CopyOnWriteArrayList<IStatusListener>();
    private final Map<INode, String> m_status = new HashMap<INode, String>();
    private final Messengers m_messengers;
    private final Object m_mutex = new Object();
    private final IStatusChannel m_statusChannelSubscribor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusManager(Messengers messengers) {
        IStatusController controller;
        this.m_messengers = messengers;
        this.m_statusChannelSubscribor = new IStatusChannel(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void statusChanged(INode node, String status) {
                Object object = StatusManager.this.m_mutex;
                synchronized (object) {
                    if (status == null) {
                        StatusManager.this.m_status.remove(node);
                    } else {
                        StatusManager.this.m_status.put(node, status);
                    }
                }
                StatusManager.this.notifyStatusChanged(node, status);
            }
        };
        if (messengers.getMessenger().isServer() && !messengers.getRemoteMessenger().hasLocalImplementor(IStatusController.STATUS_CONTROLLER)) {
            controller = new StatusController(messengers);
            messengers.getRemoteMessenger().registerRemote(controller, IStatusController.STATUS_CONTROLLER);
        }
        this.m_messengers.getChannelMessenger().registerChannelSubscriber(this.m_statusChannelSubscribor, IStatusChannel.STATUS_CHANNEL);
        controller = (IStatusController)this.m_messengers.getRemoteMessenger().getRemote(IStatusController.STATUS_CONTROLLER);
        Map<INode, String> values = controller.getAllStatus();
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_status.putAll(values);
        }
    }

    public void shutDown() {
        this.m_messengers.getChannelMessenger().unregisterChannelSubscriber(this.m_statusChannelSubscribor, IStatusChannel.STATUS_CHANNEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatus(INode node) {
        Object object = this.m_mutex;
        synchronized (object) {
            return this.m_status.get(node);
        }
    }

    public void setStatus(String status) {
        IStatusController controller = (IStatusController)this.m_messengers.getRemoteMessenger().getRemote(IStatusController.STATUS_CONTROLLER);
        controller.setStatus(status);
    }

    public void addStatusListener(IStatusListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeStatusListener(IStatusListener listener) {
        this.m_listeners.remove(listener);
    }

    private void notifyStatusChanged(INode node, String newStatus) {
        for (IStatusListener listener : this.m_listeners) {
            listener.statusChanged(node, newStatus);
        }
    }
}

